/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.verify;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.su.uci.control.SequenceToBeExecutedInformationEvent;
import se.ericsson.cello.su.uci.verify.VerificationResult;
import se.ericsson.cello.su.util.operatingsystem.OperatingSystemHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.SequenceInformation;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.sequence.ValidSequencesInformation;
import se.ericsson.cello.sudom.parser.ParserFactoryException;
import se.ericsson.cello.sudom.parser.UpgradeControlFileNotFoundException;
import se.ericsson.cello.sudom.proxy.OptimizedDocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.explicitreplacement.ExplicitReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_AdditionsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_BaseInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_CopyFromOneRPU_Information;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_CopyFromTwoRPUsInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_ModificationInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_PropertyInformation;
import se.ericsson.cello.swmanagement.suaccess.ReliableProgramUniterMoSU_Access;
import se.ericsson.cello.upgradepackage.main.util.ActionResultData;
import se.ericsson.cello.upgradepackage.main.util.ActionResultInformationEnum;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.step.replaceconfigsupportmos.RPU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.rpu.RPU_MO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.rpu.RPU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class RpuConsistencyVerifier {
    public Collection theInconsistentRpus = new LinkedList();
    public Collection theInconsistentRpus_Ose = new LinkedList();
    private String myUP_ProdNo = null;
    private String myUP_Rev = null;
    private String myUCF_Path = null;
    private SequenceToBeExecutedInformationEvent mySequenceToBeExecutedInformationEvent = null;
    private String theAdditionalInformation = "The inconsistent Rpu's present in NewRpu under RpuAddition.";

    public RpuConsistencyVerifier(String string, String string2, String string3, SequenceToBeExecutedInformationEvent sequenceToBeExecutedInformationEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "RpuConsistencyVerifier(String anUP_DocumentNumber, String anUP_DocumentRevision, String anUP_UCF_Path, SequenceToBeExecutedInformationEvent aSequenceToBeExecutedInformationEvent)", "\n\tanUP_DocumentNumber: " + string + "\n\tanUP_DocumentRevision: " + string2 + "\n\tanUP_UCF_Path: " + string3);
        }
        this.myUP_ProdNo = string;
        this.myUP_Rev = string2;
        this.myUCF_Path = string3;
        this.mySequenceToBeExecutedInformationEvent = sequenceToBeExecutedInformationEvent;
    }

    public VerificationResult execute() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "execute()");
        }
        try {
            VerificationResult verificationResult = new VerificationResult(true);
            String string = null;
            String string2 = null;
            String string3 = null;
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = this.getDocumentObjectProxyInterface(this.myUP_ProdNo, this.myUP_Rev, this.myUCF_Path);
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface();
            if (configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null) != null) {
                string = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null).getUP_CompatibilityIndex(null);
                string2 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null).getDocumentNumber(null);
                string3 = configurationVersionMO_HandlerInterface.getCurrentUpgradePackage(null).getDocumentRevision(null);
            } else {
                string = optimizedDocumentObjectProxyInterface.getUP_CompatibilityIndexProxyInterface().getIndex();
                string2 = this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentNumber;
                string3 = this.mySequenceToBeExecutedInformationEvent.initUP_Information.getUP_InstallRequestEvent().upgradePackageDocumentRevision;
            }
            ValidSequencesInformation validSequencesInformation = optimizedDocumentObjectProxyInterface.getValidSequences(string2, string3, string);
            if (validSequencesInformation.isAnyUpgradeVariantSupported()) {
                Collection collection = validSequencesInformation.getAllFirstSupportedSequenceInformations(true);
                SequenceInformation sequenceInformation = (SequenceInformation)collection.iterator().next();
                String string4 = sequenceInformation.currentCase;
                ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface = optimizedDocumentObjectProxyInterface.getExplicitReplacementsProxyInterface();
                RPU_AdditionsProxyInterface rPU_AdditionsProxyInterface = explicitReplacementsProxyInterface.getRPU_AdditionsProxyInterface(string4);
                RPU_MO_HandlerInterface rPU_MO_HandlerInterface = ServiceFinder.getRPU_MO_HandlerInterface();
                Map map = rPU_MO_HandlerInterface.getExistingRPUs();
                Map map2 = rPU_MO_HandlerInterface.getExistingRPUsAdmPassiveSlots();
                Collection collection2 = rPU_AdditionsProxyInterface.getRPUsToBeCopiedFromOneRPU();
                RPU_CopyFromOneRPU_Information rPU_CopyFromOneRPU_Information = null;
                Collection collection3 = null;
                RPU_BaseInformation rPU_BaseInformation = null;
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    rPU_CopyFromOneRPU_Information = (RPU_CopyFromOneRPU_Information)iterator.next();
                    rPU_BaseInformation = rPU_CopyFromOneRPU_Information.oldRPU_Information;
                    collection3 = this.getOriginRPU_MOs(map, rPU_BaseInformation.rpLabel);
                    this.copyRPUsFromOneRPU(map, collection3, rPU_CopyFromOneRPU_Information.newRPU_Informations);
                }
                Collection collection4 = rPU_AdditionsProxyInterface.getRPUsToBeCopiedFromTwoRPUs();
                RPU_CopyFromTwoRPUsInformation rPU_CopyFromTwoRPUsInformation = null;
                Collection collection5 = null;
                Collection collection6 = null;
                RPU_BaseInformation rPU_BaseInformation2 = null;
                RPU_BaseInformation rPU_BaseInformation3 = null;
                Iterator iterator2 = collection4.iterator();
                while (iterator2.hasNext()) {
                    rPU_CopyFromTwoRPUsInformation = (RPU_CopyFromTwoRPUsInformation)iterator2.next();
                    rPU_BaseInformation2 = rPU_CopyFromTwoRPUsInformation.oldRPU_Information1;
                    rPU_BaseInformation3 = rPU_CopyFromTwoRPUsInformation.oldRPU_Information2;
                    collection5 = this.getOriginRPU_MOs(map, rPU_BaseInformation2.rpLabel);
                    collection6 = this.getOriginRPU_MOs(map, rPU_BaseInformation3.rpLabel);
                    this.copyRPUsFromTwoRPU(map, collection5, collection6, rPU_CopyFromTwoRPUsInformation.newRPU_Informations);
                }
                Collection collection7 = rPU_AdditionsProxyInterface.getRPUsToBeModified();
                RPU_ModificationInformation rPU_ModificationInformation = null;
                collection3 = null;
                Collection collection8 = null;
                Iterator iterator3 = collection7.iterator();
                while (iterator3.hasNext()) {
                    rPU_ModificationInformation = (RPU_ModificationInformation)iterator3.next();
                    collection3 = this.getOriginRPU_MOs(map, rPU_ModificationInformation.rpuInformation.rpLabel);
                    collection8 = rPU_ModificationInformation.rpuInformation.oldRP_Label2 == null ? null : this.getOriginRPU_MOs(map, rPU_ModificationInformation.rpuInformation.oldRP_Label2);
                    this.checkRpuIsForDevice_OneLegged(map2, collection3, collection8, rPU_ModificationInformation);
                }
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "execute()", "The inconsistent Rpu's are :" + this.theInconsistentRpus);
                }
                RPU_PropertyInformation rPU_PropertyInformation = null;
                RPU_PropertyInformation rPU_PropertyInformation2 = null;
                Iterator iterator4 = this.theInconsistentRpus.iterator();
                Iterator iterator5 = this.theInconsistentRpus_Ose.iterator();
                while (iterator4.hasNext()) {
                    rPU_PropertyInformation = (RPU_PropertyInformation)iterator4.next();
                    this.theAdditionalInformation = this.theAdditionalInformation + "\n The inconsistent Rpu in NewRpu under RpuAddtion is for device program but having the passive slot(not one legged): " + rPU_PropertyInformation;
                }
                while (iterator5.hasNext()) {
                    rPU_PropertyInformation2 = (RPU_PropertyInformation)iterator5.next();
                    this.theAdditionalInformation = this.theAdditionalInformation + "\n The inconsistent Rpu in NewRpu under RpuAddtion is with isForDeviceProgram is true in OSE: " + rPU_PropertyInformation2;
                }
                if (!this.theInconsistentRpus.isEmpty() || !this.theInconsistentRpus_Ose.isEmpty()) {
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "execute()", "The Rpu's for which configuration mismatch(isForDeviceProgram and having the passive slot) is present are: " + this.theInconsistentRpus);
                    }
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "execute()", "The Rpu's for which configuration mismatch(isForDeviceProgram is true in OSE OS: " + this.theInconsistentRpus_Ose);
                    }
                    ActionResultData actionResultData = new ActionResultData(ActionResultInformationEnum.RPU_ADDITION_INCONSISTENCY, this.theAdditionalInformation);
                    return new VerificationResult(true, false, actionResultData);
                }
                return verificationResult;
            }
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "execute()", "From version not supported and hence no idea to analyze the NewRpu data consistency in the UCF.");
            }
            return verificationResult;
        }
        catch (MoAccessException moAccessException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "execute()", "MoAccessException caught (returns OK): " + (Object)((Object)moAccessException));
            }
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "execute()", "Throwable caught (ignored, returns OK): ", throwable);
            VerificationResult verificationResult = new VerificationResult(true);
            return verificationResult;
        }
    }

    private Collection getOriginRPU_MOs(Map map, String string) {
        LinkedList linkedList;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getOriginRPU_MOs ( Map anOriginRPUs, String aRpLabel )", "anOriginRPUs: " + map + "\n\taRpLabel: " + string);
        }
        if ((linkedList = (LinkedList)map.get(string)) == null) {
            linkedList = new LinkedList();
        }
        return linkedList;
    }

    private void copyRPUsFromOneRPU(Map map, Collection collection, Collection collection2) throws RPU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyRPUsFromOneRPU ( Map anOriginRPU_MOs, Collection anOldRPU_MOs, Collection aNewRPU_PropertyInformations )", "anOriginRPU_MOs: " + map + "\n\tanOldRPU_MOs: " + collection + "\n\taNewRPU_PropertyInformations: " + collection2);
        }
        try {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                RPU_PropertyInformation rPU_PropertyInformation = (RPU_PropertyInformation)iterator.next();
                if (rPU_PropertyInformation.isForDeviceProgram != null && rPU_PropertyInformation.isForDeviceProgram.booleanValue()) {
                    if (OperatingSystemHandler.getOperatingSystem() == 0) {
                        this.theInconsistentRpus_Ose.add(rPU_PropertyInformation);
                        continue;
                    }
                    this.checkRpuIsForDevice_OneLegged(map, collection, rPU_PropertyInformation);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 20, "copyRPUsFromOneRPU ( Map anOriginRPU_MOs, Collection aRPU_MOs, Collection aNewRPU_PropertyInformations )", "No need to check the RPU is for Device or not\n\tanOriginRPU_MOs: " + map + "\n\tanOldRPU_MOs: " + collection + "\n\taNewRPU_PropertyInformations: " + collection2);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyRPUsFromOneRPU ( Map anOriginRPU_MOs, Collection anOldRPU_MOs, Collection aNewRPU_PropertyInformations )", "anOriginRPU_MOs: " + map + "\n\tanOldRPU_MOs: " + collection + "\n\taNewRPU_PropertyInformations: " + collection2 + "\n\tThrowable caught.", throwable);
            throw new RPU_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: copyRPUsFromOneRPU ( Map anOriginRPU_MOs, Collection anOldRPU_MOs, Collection aNewRPU_PropertyInformations )" + "\n\tanOriginRPU_MOs: " + map + "\n\tanOldRPU_MOs: " + collection + "\n\taNewRPU_PropertyInformations: " + collection2 + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private void checkRpuIsForDevice_OneLegged(Map map, Collection collection, RPU_PropertyInformation rPU_PropertyInformation) throws RPU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkRpuIsForDevice_OneLegged ( Map anOriginRPU_MOs, Collection anOldRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "anOriginRPU_MOs: " + map + "\n\tanOldRPU_MOs: " + collection + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation);
        }
        try {
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                if (rPU_PropertyInformation.isReverseRelations && !rPU_PropertyInformation.isOneLegged && reliableProgramUniterMoSU_Access.getAdmActiveSlot(null) != null) {
                    this.theInconsistentRpus.add(rPU_PropertyInformation);
                    continue;
                }
                if (rPU_PropertyInformation.isReverseRelations && rPU_PropertyInformation.isOneLegged && reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null) == null) {
                    this.theInconsistentRpus.add(rPU_PropertyInformation);
                    continue;
                }
                if (!rPU_PropertyInformation.isOneLegged && reliableProgramUniterMoSU_Access.getAdmPassiveSlot(null) != null) {
                    this.theInconsistentRpus.add(rPU_PropertyInformation);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "checkRpuIsForDevice_OneLegged (  Collection anActiveRPU_MOs, Collection aPassiveRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "The New RPU is consistent.\n\ttheOldRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\ttheRPU_MOsWithNewLabel: " + rPU_PropertyInformation.rpLabel + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkRpuIsForDevice_OneLegged ( Map anOriginRPU_MOs, Collection anOldRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "anOriginRPU_MOs: " + map + "\n\tanOldRPU_MOs: " + collection + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tThrowable caught.", throwable);
            throw new RPU_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: checkRpuIsForDevice_OneLegged ( Map anOriginRPU_MOs, Collection anOldRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )" + "\n\tanOriginRPU_MOs: " + map + "\n\tanOldRPU_MOs: " + collection + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private void copyRPUsFromTwoRPU(Map map, Collection collection, Collection collection2, Collection collection3) throws RPU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "copyRPUsFromTwoRPU ( Map anOriginRPU_MOs, Collection aRPU_MOs, Collection aNewRPU_PropertyInformations )", "anOriginRPU_MOs: " + map + "\n\tanActiveRPU_MOs: " + collection + "\n\taPassiveRPU_MOs: " + collection2 + "\n\taNewRPU_PropertyInformations: " + collection3);
        }
        try {
            Iterator iterator = collection3.iterator();
            while (iterator.hasNext()) {
                RPU_PropertyInformation rPU_PropertyInformation = (RPU_PropertyInformation)iterator.next();
                if (rPU_PropertyInformation.isForDeviceProgram != null && rPU_PropertyInformation.isForDeviceProgram.booleanValue()) {
                    if (OperatingSystemHandler.getOperatingSystem() == 0) {
                        this.theInconsistentRpus_Ose.add(rPU_PropertyInformation);
                        continue;
                    }
                    this.checkRpuIsForDevice_OneLegged(map, collection, collection2, rPU_PropertyInformation);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 20, "copyRPUsFromTwoRPU ( Map anOriginRPU_MOs, Collection aRPU_MOs, Collection aNewRPU_PropertyInformations )", "No need to check the RPU is for Device or not\n\tanOriginRPU_MOs: " + map + "\n\tanActiveRPU_MOs: " + collection + "\n\taPassiveRPU_MOs: " + collection2 + "\n\taNewRPU_PropertyInformations: " + collection3);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "copyRPUsFromTwoRPU ( Map anOriginRPU_MOs, Collection anActiveRPU_MOs, Collection aPassiveRPU_MOs, Collection aNewRPU_PropertyInformations )", "anOriginRPU_MOs: " + map + "\n\tanActiveRPU_MOs: " + collection + "\n\taPassiveRPU_MOs: " + collection2 + "\n\taNewRPU_PropertyInformations: " + collection3 + "\n\tThrowable caught.", throwable);
            throw new RPU_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: copyRPUsFromTwoRPU ( Map anOriginRPU_MOs, Collection anActiveRPU_MOs, Collection aPassiveRPU_MOs, Collection aNewRPU_PropertyInformations )" + "\n\tanOriginRPU_MOs: " + map + "\n\tanActiveRPU_MOs: " + collection + "\n\taPassiveRPU_MOs: " + collection2 + "\n\taNewRPU_PropertyInformations: " + collection3 + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private void checkRpuIsForDevice_OneLegged(Map map, Collection collection, Collection collection2, RPU_PropertyInformation rPU_PropertyInformation) throws RPU_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkRpuIsForDevice_OneLegged (  Collection anActiveRPU_MOs, Collection aPassiveRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "anOriginRPU_MOs: " + map + "\n\tanActiveRPU_MOs: " + collection + "\n\taPassiveRPU_MOs: " + collection2 + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation);
        }
        try {
            Collection collection3 = this.getOriginRPU_MOs(map, rPU_PropertyInformation.rpLabel);
            if (collection2.size() != 1) {
                if (collection3.isEmpty()) {
                    Trace.warning(this.getClass(), "checkRpuIsForDevice_OneLegged ( Map anOriginRPU_MOs, Collection aRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "Checking of the old RPUs to a new RPU is NOT executed since the number of instances for OldRpu2 is not equal to one.\n\tNew RP label: " + rPU_PropertyInformation.rpLabel + "\n\tOld RPU - anActiveRPU_MOs: " + collection + "\n\tOld RPU2 - aPassiveRPU_MOs: " + collection2 + "\n\tthe RPU MOs with new label: " + collection3);
                } else if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "checkRpuIsForDevice_OneLegged ( Map anOriginRPU_MOs, Collection aRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "Checking of the old RPUs to a new RPU is NOT executed since at least the OldRpu2 didn't exist and also the new RPU already exists i.e. it has probably already been executed.\n\tNew RPU label: " + rPU_PropertyInformation.rpLabel + "\n\tOld RPU Mo - anActiveRPU_MOs: " + collection + "\n\tOld RPU2 Mo - aPassiveRPU_MOs: " + collection2 + "\n\tthe RPU MO's with new label: " + collection3);
                }
                return;
            }
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            Vector vector = new Vector(collection2);
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access2 = (ReliableProgramUniterMoSU_Access)vector.elementAt(0);
            Vector vector2 = new Vector(collection);
            for (int i = 0; i < vector2.size(); ++i) {
                reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)vector2.elementAt(i);
                if (!rPU_PropertyInformation.isOneLegged && reliableProgramUniterMoSU_Access2.getAdmPassiveSlot(null) != null) {
                    this.theInconsistentRpus.add(rPU_PropertyInformation);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "checkRpuIsForDevice_OneLegged (  Collection anActiveRPU_MOs, Collection aPassiveRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "The NewRPU is consistent.\n\ttheActiveRPU_MO: " + reliableProgramUniterMoSU_Access + "\n\tthePassiveRPU_MO: " + reliableProgramUniterMoSU_Access2 + "\n\ttheRPU_MOsWithNewLabel: " + collection3 + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkRpuIsForDevice_OneLegged ( Map anOriginRPU_MOs, Collection anActiveRPU_MOs, Collection aPassiveRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )", "anOriginRPU_MOs: " + map + "\n\tanActiveRPU_MOs: " + collection + "\n\taPassiveRPU_MOs: " + collection2 + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tThrowable caught.", throwable);
            throw new RPU_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: checkRpuIsForDevice_OneLegged ( Map anOriginRPU_MOs, Collection anActiveRPU_MOs, Collection aPassiveRPU_MOs, RPU_PropertyInformation aNewRPU_PropertyInformation )" + "\n\tanOriginRPU_MOs: " + map + "\n\tanActiveRPU_MOs: " + collection + "\n\taPassiveRPU_MOs: " + collection2 + "\n\taNewRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private void checkRpuIsForDevice_OneLegged(Map map, Collection collection, Collection collection2, RPU_ModificationInformation rPU_ModificationInformation) throws RPU_MO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checkRpuIsForDevice_OneLegged ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "anOriginRPUsAdmPassiveSlots: " + map + "\n\taRPU_MOsToBeModified: " + collection + "\n\taRPU2_MOs: " + collection2 + "\n\taRPU_ModificationInformation: " + rPU_ModificationInformation);
        }
        try {
            if (collection.isEmpty()) {
                return;
            }
            RPU_PropertyInformation rPU_PropertyInformation = rPU_ModificationInformation.rpuInformation;
            boolean bl = false;
            if (rPU_PropertyInformation.oldRP_Label2 != null) {
                if (collection2.size() == 1) {
                    bl = true;
                } else if (collection2.size() == 0) {
                    Trace.warning(this.getClass(), "updatePropertiesInRPU_MOs ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "Not possible to check the passive slot for the RPUs since no RPU MO was found that matches the\n\tgiven OldRPU2 to be used when setting the passive adm slot.\n\tAny other requested modifications of the RPU will be executed.\n\tRequested theRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tSelected RPU MOs to be modified: " + collection);
                } else {
                    Trace.warning(this.getClass(), "updatePropertiesInRPU_MOs ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "Not possible to check the passive slot for the RPUs since more than one RPU MO was found that matches the\n\tgiven OldRPU2 to be used when setting the passive adm slot.\n\tAny other requested modifications of the RPU will be executed.\n\tRequested theRPU_PropertyInformation: " + rPU_PropertyInformation + "\n\tSelected RPU MOs to be modified: " + collection);
                }
            }
            Iterator iterator = collection.iterator();
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access = null;
            ReliableProgramUniterMoSU_Access reliableProgramUniterMoSU_Access2 = null;
            SlotMoSU_Access slotMoSU_Access = null;
            if (rPU_PropertyInformation.isForDeviceProgram != null && rPU_PropertyInformation.isForDeviceProgram.booleanValue()) {
                while (iterator.hasNext()) {
                    reliableProgramUniterMoSU_Access = (ReliableProgramUniterMoSU_Access)iterator.next();
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "checkRpuIsForDevice_OneLegged (Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "Checks RPU properties for RPU MO: " + reliableProgramUniterMoSU_Access + "\n\ttheRPU_PropertyInformation: " + rPU_PropertyInformation);
                    }
                    boolean bl2 = false;
                    if (SU_AccessVersionHandler.getInstance().isSupported("SU_2", reliableProgramUniterMoSU_Access.getSupportedVersions())) {
                        bl2 = reliableProgramUniterMoSU_Access.getIsForDeviceProgram(null);
                    }
                    if (bl) {
                        reliableProgramUniterMoSU_Access2 = (ReliableProgramUniterMoSU_Access)collection2.iterator().next();
                        slotMoSU_Access = (SlotMoSU_Access)map.get(reliableProgramUniterMoSU_Access2.getLocalDistinguishedName());
                        if (rPU_PropertyInformation.isForDeviceProgram != bl2) {
                            this.theInconsistentRpus.add(rPU_PropertyInformation);
                            continue;
                        }
                        if (slotMoSU_Access == null) continue;
                        this.theInconsistentRpus.add(rPU_PropertyInformation);
                        continue;
                    }
                    if (rPU_PropertyInformation.isForDeviceProgram != bl2) {
                        this.theInconsistentRpus.add(rPU_PropertyInformation);
                        continue;
                    }
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "checkRpuIsForDevice_OneLegged (  Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation  )", "The NewRPU is consistent.\n\ttheRPU_MO_ToBeModified: " + reliableProgramUniterMoSU_Access + "\n\ttheRPU_PropertyInformation: " + rPU_PropertyInformation);
                }
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "checkRpuIsForDevice_OneLegged (Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "No need to check the RPU is for device or not\n\tChecks RPU properties for RPU MO: " + reliableProgramUniterMoSU_Access + "\n\ttheRPU_PropertyInformation: " + rPU_PropertyInformation);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checkRpuIsForDevice_OneLegged ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )", "aRPU_MOsToBeModified: " + collection + "\n\taRPU2_MOs: " + collection2 + "\n\taRPU_ModificationInformation: " + rPU_ModificationInformation + "\n\tThrowable caught.", throwable);
            throw new RPU_MO_HandlerException("Class: " + this.getClass().getName() + "\n\tMethod: checkRpuIsForDevice_OneLegged ( Map anOriginRPUsAdmPassiveSlots, Collection aRPU_MOsToBeModified, Collection aRPU2_MOs, RPU_ModificationInformation aRPU_ModificationInformation )" + "\n\taRPU_MOsToBeModified: " + collection + "\n\taRPU2_MOs: " + collection2 + "\n\taRPU_ModificationInformation: " + rPU_ModificationInformation + "\n\tThrowable caught." + "\n\tThrowable data: " + throwable);
        }
    }

    private OptimizedDocumentObjectProxyInterface getDocumentObjectProxyInterface(String string, String string2, String string3) throws UpgradeControlFileParserException, UpgradeControlFileNotFoundException, ParserFactoryException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDocumentObjectProxyInterface(String anUP_ProductNumber, String anUP_ProductRevision, String anUCF_Path)", "anUP_ProductNumber: " + string + "\n\tanUP_ProductRevision: " + string2 + "\n\tanUCF_Path: " + string3);
        }
        try {
            String[] stringArray = new String[]{"ExplicitReplacement"};
            OptimizedDocumentObjectProxyInterface optimizedDocumentObjectProxyInterface = UCF_ParserFacade.parseMainElementsOptimizedInterface(string, string2, string3, stringArray, false);
            return optimizedDocumentObjectProxyInterface;
        }
        catch (UpgradeControlFileNotFoundException upgradeControlFileNotFoundException) {
            throw upgradeControlFileNotFoundException;
        }
        catch (ParserFactoryException parserFactoryException) {
            throw parserFactoryException;
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            throw upgradeControlFileParserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDocumentObjectProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision)", "Throwable caught when searching for a document object for the specific upgrade package, anAbsolutePathToControlFile: " + string3 + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tThrowable message: " + throwable, throwable);
            throw new ParserFactoryException("Class name: " + this.getClass().getName() + "Throwable caught when searching for a document object for the specific upgrade package, " + "\n\tThrowable message: " + throwable);
        }
    }
}

