/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.internaltransport;

import enea.ose.system.Signal;
import se.ericsson.cello.internaltransport.EquipmentInternal;
import se.ericsson.cello.internaltransport.SwitchInternalLinkMo;
import se.ericsson.cello.internaltransport.fropxy.NssPhysicalLinkFroCreateRsp;
import se.ericsson.cello.internaltransport.fropxy.NssPhysicalLinkFroDeleteRsp;
import se.ericsson.cello.internaltransport.fropxy.NssPhysicalLinkFroProxy;
import se.ericsson.cello.internaltransport.fropxy.NssPhysicalLinkFroSetAdmStateRsp;
import se.ericsson.cello.internaltransport.fropxy.NssPhysicalLinkGetAttrRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasPhysicalLinkFroCreateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasPhysicalLinkFroDeleteRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasPhysicalLinkFroProxy;
import se.ericsson.cello.internaltransport.fropxy.SpasPhysicalLinkFroSetAdmStateRsp;
import se.ericsson.cello.internaltransport.fropxy.SpasPhysicalLinkGetAttrRsp;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class SwitchInternalLinkMoImpl
extends CelloMao
implements SwitchInternalLinkMo {
    private static final String NSS_RESOURCE_ID = "nssResourceId";
    private static final String SPAS_RESOURCE_ID = "spasResourceId";
    private static final int SILIPORT_NO_MIN = 0;
    private static final int SILIPORT_NO_MAX = 3;
    private static final int MAX_NUMBER_OF_SWITCHINTERNALLINKS = 8;
    private MoData data;
    private StringAttribute userLabel;
    private ReferenceAttribute plugInUnit1;
    private ReferenceAttribute plugInUnit2;
    private IntegerAttribute siliport1;
    private IntegerAttribute siliport2;
    private IntegerAttribute spasResourceId;
    private IntegerAttribute nssResourceId;
    private static SpasPhysicalLinkFroProxy spasProxy = SpasPhysicalLinkFroProxy.instance();
    private static NssPhysicalLinkFroProxy nssProxy = NssPhysicalLinkFroProxy.instance();
    private static final String PARENT_TYPE_NAME = "InternalLinkGroup";
    private static final int MO_DATA_REVISION_3_5 = 3500;
    private static final int MO_DATA_REVISION_LATEST = 3500;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)PARENT_TYPE_NAME);
        MoAttributeValidator.checkIdentity((String)"SwitchInternalLink", (String)string);
        MoIterator moIterator = managedObject.getChildren();
        int n = 0;
        while (moIterator.hasMoreElements()) {
            if (!(moIterator.nextMo() instanceof SwitchInternalLinkMo)) continue;
            ++n;
        }
        if (n >= 8) {
            throw new MaxNumberExceededException("To many SwitchInternalLink MOs", "SwitchInternalLink");
        }
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"SwitchInternalLink", (int)128, (int)0);
        ManagedObject managedObject3 = SwitchInternalLinkMoImpl.checkAndGetPlugInUnit1(attrList);
        ManagedObject managedObject4 = SwitchInternalLinkMoImpl.checkAndGetPlugInUnit2(attrList, managedObject3);
        int n2 = SwitchInternalLinkMoImpl.checkAndGetSiliport1(attrList);
        int n3 = SwitchInternalLinkMoImpl.checkAndGetSiliport2(attrList);
        int n4 = SwitchInternalLinkMoImpl.checkAndGetAdministrativeState(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"SwitchInternalLink");
        return new SwitchInternalLinkMoImpl(managedObject, string, string2, managedObject3, managedObject4, n2, n3, n4, coordinator);
    }

    private SwitchInternalLinkMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject managedObject3, int n, int n2, int n3, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "SwitchInternalLink", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.siliport1 = new IntegerAttribute("siliport1", false, n);
        this.data.registerPersistentAttr((Attribute)this.siliport1);
        this.siliport2 = new IntegerAttribute("siliport2", false, n2);
        this.data.registerPersistentAttr((Attribute)this.siliport2);
        this.plugInUnit1 = new ReferenceAttribute("plugInUnit1", false, managedObject2);
        this.data.registerPersistentAttr((Attribute)this.plugInUnit1);
        this.plugInUnit2 = new ReferenceAttribute("plugInUnit2", false, managedObject3);
        this.data.registerPersistentAttr((Attribute)this.plugInUnit2);
        if (managedObject2 instanceof EquipmentInternal && managedObject3 instanceof EquipmentInternal) {
            int n4 = ((EquipmentInternal)managedObject2).getAsciPortNumber(coordinator);
            int n5 = ((EquipmentInternal)managedObject2).getSwitchModuleNumber(coordinator);
            int n6 = ((EquipmentInternal)managedObject3).getAsciPortNumber(coordinator);
            int n7 = ((EquipmentInternal)managedObject3).getSwitchModuleNumber(coordinator);
            SpasPhysicalLinkFroCreateRsp spasPhysicalLinkFroCreateRsp = spasProxy.sendSpasPhysicalLinkFroCreateReq(coordinator.getTransactionID(), n5, n4, n, n7, n6, n2, n3);
            this.checkSignal((Signal)spasPhysicalLinkFroCreateRsp);
            if (spasPhysicalLinkFroCreateRsp.getResult() != 1) {
                throw new FroRequestFailedException("SwitchInternalLink", "SpasPhysicalLink", "CreateFroReq: " + spasProxy.getResultMsg(spasPhysicalLinkFroCreateRsp.getResult()), spasPhysicalLinkFroCreateRsp.getResult());
            }
            this.spasResourceId = new IntegerAttribute(SPAS_RESOURCE_ID, false, spasPhysicalLinkFroCreateRsp.getFroId());
            this.data.registerPersistentAttr((Attribute)this.spasResourceId);
            NssPhysicalLinkFroCreateRsp nssPhysicalLinkFroCreateRsp = nssProxy.sendNssPhysicalLinkFroCreateReq(coordinator.getTransactionID(), n3, n5, n4, n, n7, n6, n2);
            this.checkSignal((Signal)nssPhysicalLinkFroCreateRsp);
            if (nssPhysicalLinkFroCreateRsp.getResult() != 0) {
                throw new FroRequestFailedException("SwitchInternalLink", "NssPhysicalLink", "CreateFroReq: " + nssProxy.getResultMsg(nssPhysicalLinkFroCreateRsp.getResult()), nssPhysicalLinkFroCreateRsp.getResult());
            }
            this.nssResourceId = new IntegerAttribute(NSS_RESOURCE_ID, false, nssPhysicalLinkFroCreateRsp.getFroId());
            this.data.registerPersistentAttr((Attribute)this.nssResourceId);
        }
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        this.data.setRevision(3500);
        spasProxy.registerForNotifications(coordinator, this, this.spasResourceId.getValue(coordinator));
        nssProxy.registerForNotifications(coordinator, this, this.nssResourceId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public SwitchInternalLinkMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3500);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(SPAS_RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute(NSS_RESOURCE_ID);
        moDataRecoveryHelper.assertAttribute("plugInUnit1");
        moDataRecoveryHelper.assertAttribute("plugInUnit2");
        moDataRecoveryHelper.assertAttribute("siliport1");
        moDataRecoveryHelper.assertAttribute("siliport2");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.spasResourceId = (IntegerAttribute)moData.getAttribute(SPAS_RESOURCE_ID);
        this.nssResourceId = (IntegerAttribute)moData.getAttribute(NSS_RESOURCE_ID);
        this.plugInUnit1 = (ReferenceAttribute)moData.getAttribute("plugInUnit1");
        this.plugInUnit2 = (ReferenceAttribute)moData.getAttribute("plugInUnit2");
        this.siliport1 = (IntegerAttribute)moData.getAttribute("siliport1");
        this.siliport2 = (IntegerAttribute)moData.getAttribute("siliport2");
        spasProxy.registerForNotifications(null, this, this.spasResourceId.getValue(null));
        nssProxy.registerForNotifications(null, this, this.nssResourceId.getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((Reservable)this.plugInUnit1.getValue(coordinator)).release((ManagedObject)this, coordinator);
        ((Reservable)this.plugInUnit2.getValue(coordinator)).release((ManagedObject)this, coordinator);
        SpasPhysicalLinkFroDeleteRsp spasPhysicalLinkFroDeleteRsp = spasProxy.sendSpasPhysicalLinkFroDeleteReq(coordinator.getTransactionID(), this.spasResourceId.getValue(coordinator));
        this.checkSignal((Signal)spasPhysicalLinkFroDeleteRsp);
        if (spasPhysicalLinkFroDeleteRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchInternalLink", "SpasPhysicalLink", "DeleteFroReq: " + spasProxy.getResultMsg(spasPhysicalLinkFroDeleteRsp.getResult()), spasPhysicalLinkFroDeleteRsp.getResult());
        }
        NssPhysicalLinkFroDeleteRsp nssPhysicalLinkFroDeleteRsp = nssProxy.sendNssPhysicalLinkFroDeleteReq(coordinator.getTransactionID(), this.nssResourceId.getValue(coordinator));
        this.checkSignal((Signal)nssPhysicalLinkFroDeleteRsp);
        if (nssPhysicalLinkFroDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("SwitchInternalLink", "NssPhysicalLink", "DeleteFroReq: " + nssProxy.getResultMsg(nssPhysicalLinkFroDeleteRsp.getResult()), nssPhysicalLinkFroDeleteRsp.getResult());
        }
        spasProxy.deregisterForNotifications(coordinator, this.spasResourceId.getValue(coordinator));
        nssProxy.deregisterForNotifications(coordinator, this.nssResourceId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"SwitchInternalLink", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public ManagedObject getPlugInUnit1(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.plugInUnit1.getValue(coordinator);
    }

    public ManagedObject getPlugInUnit2(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.plugInUnit2.getValue(coordinator);
    }

    public int getSiliport1(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.siliport1.getValue(coordinator);
    }

    public int getSiliport2(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.siliport2.getValue(coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        SpasPhysicalLinkGetAttrRsp spasPhysicalLinkGetAttrRsp = this.retrieveSpasFroAttributes(coordinator);
        return spasPhysicalLinkGetAttrRsp.getAdmStatePhysicalLink();
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("administrativeState", "SwitchInternalLink");
        }
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        SwitchInternalLinkMoImpl.sendChangeNotification(this, stringArray, objectArray, coordinator);
        SpasPhysicalLinkFroSetAdmStateRsp spasPhysicalLinkFroSetAdmStateRsp = spasProxy.sendSpasPhysicalLinkFroSetAdmStateReq(coordinator.getTransactionID(), this.spasResourceId.getValue(coordinator), n);
        this.checkSignal((Signal)spasPhysicalLinkFroSetAdmStateRsp);
        if (spasPhysicalLinkFroSetAdmStateRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchInternalLink", "SpasPhysicalLink", "SetAttrReq: " + spasProxy.getResultMsg(spasPhysicalLinkFroSetAdmStateRsp.getResult()), spasPhysicalLinkFroSetAdmStateRsp.getResult());
        }
        NssPhysicalLinkFroSetAdmStateRsp nssPhysicalLinkFroSetAdmStateRsp = nssProxy.sendNssPhysicalLinkFroSetAdmStateReq(coordinator.getTransactionID(), this.nssResourceId.getValue(coordinator), n);
        this.checkSignal((Signal)nssPhysicalLinkFroSetAdmStateRsp);
        if (nssPhysicalLinkFroSetAdmStateRsp.getResult() != 0) {
            throw new FroRequestFailedException("SwitchInternalLink", "NssPhysicalLink", "SetAttrReq: " + nssProxy.getResultMsg(nssPhysicalLinkFroSetAdmStateRsp.getResult()), nssPhysicalLinkFroSetAdmStateRsp.getResult());
        }
    }

    public int getOperationalStateTraffic(Coordinator coordinator) throws MoAccessException {
        SpasPhysicalLinkGetAttrRsp spasPhysicalLinkGetAttrRsp = this.retrieveSpasFroAttributes(coordinator);
        return spasPhysicalLinkGetAttrRsp.getOpStatePhysicalLink();
    }

    public int getAvailabilityStatusTraffic(Coordinator coordinator) throws MoAccessException {
        SpasPhysicalLinkGetAttrRsp spasPhysicalLinkGetAttrRsp = this.retrieveSpasFroAttributes(coordinator);
        return AvailConverter.convert((int)spasPhysicalLinkGetAttrRsp.getAvailStatePhysicalLink());
    }

    public int getOperationalStateSync(Coordinator coordinator) throws MoAccessException {
        NssPhysicalLinkGetAttrRsp nssPhysicalLinkGetAttrRsp = this.retrieveNssFroAttributes(coordinator);
        return nssPhysicalLinkGetAttrRsp.getOpStatePhysicalLink();
    }

    public int getAvailabilityStatusSync(Coordinator coordinator) throws MoAccessException {
        NssPhysicalLinkGetAttrRsp nssPhysicalLinkGetAttrRsp = this.retrieveNssFroAttributes(coordinator);
        return nssPhysicalLinkGetAttrRsp.getAvailStatePhysicalLink();
    }

    public String getType() {
        return "SwitchInternalLink";
    }

    private SpasPhysicalLinkGetAttrRsp retrieveSpasFroAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        SpasPhysicalLinkGetAttrRsp spasPhysicalLinkGetAttrRsp = spasProxy.sendSpasPhysicalLinkGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.spasResourceId.getValue(coordinator));
        this.checkSignal((Signal)spasPhysicalLinkGetAttrRsp);
        int n = spasPhysicalLinkGetAttrRsp.getResult();
        if (n != 1) {
            throw new FroRequestFailedException("SwitchInternalLink", "SpasPhysicalLink", "GetAttrReq: " + spasProxy.getResultMsg(spasPhysicalLinkGetAttrRsp.getResult()), spasPhysicalLinkGetAttrRsp.getResult());
        }
        return spasPhysicalLinkGetAttrRsp;
    }

    public String getSwitchInternalLinkId(Coordinator coordinator) {
        return this.getNamingAttributeValue();
    }

    private NssPhysicalLinkGetAttrRsp retrieveNssFroAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        NssPhysicalLinkGetAttrRsp nssPhysicalLinkGetAttrRsp = nssProxy.sendNssPhysicalLinkGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.nssResourceId.getValue(coordinator));
        this.checkSignal((Signal)nssPhysicalLinkGetAttrRsp);
        int n = (int)nssPhysicalLinkGetAttrRsp.getResult();
        if (n != 0) {
            throw new FroRequestFailedException("SwitchInternalLink", "NssPhysicalLink", "GetAttrReq: " + nssProxy.getResultMsg((int)nssPhysicalLinkGetAttrRsp.getResult()), (int)nssPhysicalLinkGetAttrRsp.getResult());
        }
        return nssPhysicalLinkGetAttrRsp;
    }

    private static void sendChangeNotification(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) {
        NotificationSender notificationSender = NotificationSender.instance();
        notificationSender.pushAVC(managedObject, stringArray, objectArray, coordinator);
    }

    private void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            throw new FroNotAccessibleException("SwitchInternalLink", "SwitchInternalLink Fro");
        }
    }

    private static ManagedObject checkAndGetPlugInUnit1(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("plugInUnit1");
        if (n == -1) {
            throw new AttrMissingAtCreateException("plugInUnit1", "SwitchInternalLink");
        }
        if (attrList.getValue(n) instanceof ManagedObject) {
            if (!((ManagedObject)attrList.getValue(n)).getType().equals("SwitchCoreUnit") && !((ManagedObject)attrList.getValue(n)).getType().equals("SwitchExtensionUnit")) {
                throw new WrongAttributeTypeException("plugInUnit1", "SwitchInternalLink");
            }
        } else {
            throw new WrongAttributeTypeException("plugInUnit1", "SwitchInternalLink");
        }
        ManagedObject managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    private static ManagedObject checkAndGetPlugInUnit2(AttrList attrList, ManagedObject managedObject) throws MoAccessException {
        int n = attrList.indexOf("plugInUnit2");
        if (n == -1) {
            throw new AttrMissingAtCreateException("plugInUnit2", "SwitchInternalLink");
        }
        if (attrList.getValue(n) instanceof ManagedObject) {
            if (!((ManagedObject)attrList.getValue(n)).getType().equals("SwitchCoreUnit") && !((ManagedObject)attrList.getValue(n)).getType().equals("SwitchExtensionUnit")) {
                throw new WrongAttributeTypeException("plugInUnit2", "SwitchInternalLink");
            }
        } else {
            throw new WrongAttributeTypeException("plugInUnit2", "SwitchInternalLink");
        }
        if (managedObject == attrList.getValue(n)) {
            throw new ValueOutOfRangeException("plugInUnit2", "SwitchInternalLink");
        }
        ManagedObject managedObject2 = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject2;
    }

    private static int checkAndGetSiliport1(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("siliport1");
        if (n == -1) {
            throw new AttrMissingAtCreateException("siliport1", "SwitchInternalLink");
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("siliport1", "SwitchInternalLink");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 3) {
            throw new ValueOutOfRangeException("siliport1", "SwitchInternalLink");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetSiliport2(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("siliport2");
        if (n == -1) {
            throw new AttrMissingAtCreateException("siliport2", "SwitchInternalLink");
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("siliport2", "SwitchInternalLink");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 3) {
            throw new ValueOutOfRangeException("siliport2", "SwitchInternalLink");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetAdministrativeState(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("administrativeState");
        if (n == -1) {
            return 1;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("administrativeState", "SwitchInternalLink");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 0 && n2 != 1) {
            throw new ValueOutOfRangeException("administrativeState", "SwitchInternalLink");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private void setSpasAdmState(Coordinator coordinator, int n) throws FroRequestFailedException, FroNotAccessibleException {
        SpasPhysicalLinkFroSetAdmStateRsp spasPhysicalLinkFroSetAdmStateRsp = spasProxy.sendSpasPhysicalLinkFroSetAdmStateReq(coordinator.getTransactionID(), this.spasResourceId.getValue(coordinator), n);
        this.checkSignal((Signal)spasPhysicalLinkFroSetAdmStateRsp);
        if (spasPhysicalLinkFroSetAdmStateRsp.getResult() != 1) {
            throw new FroRequestFailedException("SwitchInternalLink", "SpasPhysicalLink", "SetAttrReq: " + spasProxy.getResultMsg(spasPhysicalLinkFroSetAdmStateRsp.getResult()), spasPhysicalLinkFroSetAdmStateRsp.getResult());
        }
    }
}

