/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.internaltransport.fropxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.Hashtable;
import se.ericsson.cello.common.fropxy.CmaPortManager;
import se.ericsson.cello.common.fropxy.CmaSignalPort;
import se.ericsson.cello.common.fropxy.FroEmptySignal;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.common.fropxy.FroReqU32U32;
import se.ericsson.cello.common.fropxy.FroReqU32U32U16;
import se.ericsson.cello.common.fropxy.FroSignalHandling;
import se.ericsson.cello.internaltransport.fropxy.NssScuFroCreateReq;
import se.ericsson.cello.internaltransport.fropxy.NssScuFroCreateRsp;
import se.ericsson.cello.internaltransport.fropxy.NssScuFroDeleteRsp;
import se.ericsson.cello.internaltransport.fropxy.NssScuFroFaultCeasedInd;
import se.ericsson.cello.internaltransport.fropxy.NssScuFroFaultInd;
import se.ericsson.cello.internaltransport.fropxy.NssScuFroSetAdmStateRsp;
import se.ericsson.cello.internaltransport.fropxy.NssScuGetAttrRsp;
import se.ericsson.cello.session.NameServerWrapper;
import se.ericsson.cello.session.ServiceSubscriber;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalObserver;
import se.ericsson.cello.support.sigutil.SignalPort;

public class NssScuFroProxy
extends FroProxy {
    private OseProcess op = null;
    public static final int NSS_SCU_RESULT_OK = 0;
    public static final int NSS_SCU_DB_PROBLEMS_RESULT_NOT_OK = 1;
    public static final int NSS_SCU_NON_TRASACTIONAL_OPERATION_RESULT_NOT_OK = 2;
    public static final int NSS_SCU_ANOTHER_TRANSACTION_ACTIVE_RESULT_NOT_OK = 3;
    public static final int NSS_SCU_FRO_ALREADY_EXISTS_RESULT_NOT_OK = 4;
    public static final int NSS_SCU_TRANSACTION_REGISTRATION_FAILED_RESULT_NOT_OK = 5;
    private SignalPort signalPort = PortManager.instance();
    private CmaSignalPort cmaSignalPort = CmaPortManager.instance();
    private static String NSS_SCU_CLASSNAME = "NssScuFro";
    public static final int NSS_SCU_SYNCHRONIZATION_HW_FAILURE = 0;
    private static NssScuFroProxy instance = null;

    public NssScuFroCreateRsp sendNssScuFroCreateReq(long l, int n, int n2, int n3) {
        NssScuFroCreateReq nssScuFroCreateReq = new NssScuFroCreateReq(l, n, n2, n3);
        if (this.op == null && !this.init()) {
            return null;
        }
        NssScuFroCreateRsp nssScuFroCreateRsp = (NssScuFroCreateRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)nssScuFroCreateReq, (Class)NssScuFroCreateRsp.class);
        return nssScuFroCreateRsp;
    }

    public NssScuFroDeleteRsp sendNssScuFroDeleteReq(long l, long l2) {
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(644610, (int)l, (int)l2);
        if (this.op == null && !this.init()) {
            return null;
        }
        NssScuFroDeleteRsp nssScuFroDeleteRsp = (NssScuFroDeleteRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32, (Class)NssScuFroDeleteRsp.class);
        return nssScuFroDeleteRsp;
    }

    public NssScuFroSetAdmStateRsp sendNssScuFroSetAdmStateReq(long l, long l2, int n) {
        FroReqU32U32U16 froReqU32U32U16 = new FroReqU32U32U16(644612, (int)l, (int)l2, n);
        if (this.op == null && !this.init()) {
            return null;
        }
        NssScuFroSetAdmStateRsp nssScuFroSetAdmStateRsp = (NssScuFroSetAdmStateRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32U16, (Class)NssScuFroSetAdmStateRsp.class);
        return nssScuFroSetAdmStateRsp;
    }

    public NssScuGetAttrRsp sendNssScuGetAttrReq(long l, long l2) {
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(644614, (int)l, (int)l2);
        if (this.op == null && !this.init()) {
            return null;
        }
        NssScuGetAttrRsp nssScuGetAttrRsp = (NssScuGetAttrRsp)SignalHelper.sendAndReceive((OseProcess)this.op, (Signal)froReqU32U32, (Class)NssScuGetAttrRsp.class);
        return nssScuGetAttrRsp;
    }

    public void sendNssScuFroNotifSubscribeReq() {
        FroEmptySignal froEmptySignal = new FroEmptySignal(644616);
        OseProcess oseProcess = this.signalPort.getOseProcess();
        if (!this.init()) {
            return;
        }
        SignalHelper.sendWithSender((OseProcess)this.op, (OseProcess)oseProcess, (Signal)froEmptySignal);
    }

    public void serviceAdded() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("serviceAdded(), serviceTag: " + NSS_SCU_CLASSNAME));
        this.sendNssScuFroNotifSubscribeReq();
    }

    public void signalReceived(InSignal inSignal) {
        FroSignalHandling.run((InSignal)inSignal, (Hashtable)this.subscriptions, ((Object)((Object)this)).getClass());
    }

    private NssScuFroProxy() {
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, NssScuFroFaultInd.class);
        this.cmaSignalPort.addSignalObserver((SignalObserver)this, NssScuFroFaultCeasedInd.class);
    }

    public String getResultMsg(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "NSS_SCU_RESULT_OK";
                break;
            }
            case 1: {
                string = "NSS_SCU_DB_PROBLEMS_RESULT_NOT_OK";
                break;
            }
            case 2: {
                string = "NSS_SCU_NON_TRASACTIONAL_OPERATION_RESULT_NOT_OK";
                break;
            }
            case 3: {
                string = "NSS_SCU_ANOTHER_TRANSACTION_ACTIVE_RESULT_NOT_OK";
                break;
            }
            case 4: {
                string = "NSS_SCU_FRO_ALREADY_EXISTS_RESULT_NOT_OK";
                break;
            }
            case 5: {
                string = "NSS_SCU_TRANSACTION_REGISTRATION_FAILED_RESULT_NOT_OK";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + n;
            }
        }
        return string;
    }

    public static NssScuFroProxy instance() {
        if (instance == null) {
            instance = new NssScuFroProxy();
        }
        return instance;
    }

    public void subscribeService() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"subscribeService() ");
        new NameServerWrapper(NSS_SCU_CLASSNAME, (ServiceSubscriber)this);
    }

    public void serviceRemoved() {
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("serviceRemoved(), serviceTag: " + NSS_SCU_CLASSNAME));
        this.op = null;
        super.serviceRemoved(NSS_SCU_CLASSNAME);
    }

    private boolean init() {
        this.op = OseNameServer.lookup((String)NSS_SCU_CLASSNAME);
        if (this.op == null) {
            MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)"init() , op = null ");
            return false;
        }
        MessageLog.trace((int)5, ((Object)((Object)this)).getClass(), (String)("init() , op: " + this.op.getPID()));
        return true;
    }
}

