/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.corba.jacorb;

import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;

public class PTrustManager
implements X509TrustManager {
    private boolean requiresTrust;
    private X509Certificate[] trustees;
    private Logger logger;

    public PTrustManager(boolean bl, X509Certificate[] x509CertificateArray, Configuration configuration) {
        this.trustees = x509CertificateArray;
        this.requiresTrust = bl;
        this.logger = configuration.getNamedLogger("prismtech.sec.jsse");
    }

    public X509Certificate[] getAcceptedIssuers() {
        return this.trustees;
    }

    private final boolean isTrusted(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("check trust for empty certificate chain");
                this.logger.debug("trust outcome: " + !this.requiresTrust);
            }
            return !this.requiresTrust;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("check trust for certificate chain with " + x509CertificateArray.length + " elements");
        }
        for (int i2 = x509CertificateArray.length - 1; i2 >= 0; --i2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("check trust for certificate: " + x509CertificateArray[i2]);
            }
            for (int i3 = this.trustees.length - 1; i3 >= 0; --i3) {
                if (!x509CertificateArray[i2].equals(this.trustees[i3])) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("found trusted cert " + this.trustees[i3]);
                }
                return this.checkChainValidity(x509CertificateArray, i2);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("trust outcome (no trusted certificate found): " + !this.requiresTrust);
        }
        return !this.requiresTrust;
    }

    private final boolean checkChainValidity(X509Certificate[] x509CertificateArray, int n2) {
        try {
            for (int i2 = 0; i2 <= n2; ++i2) {
                x509CertificateArray[i2].checkValidity();
                PublicKey publicKey = x509CertificateArray[Math.min(i2 + 1, x509CertificateArray.length - 1)].getPublicKey();
                x509CertificateArray[i2].verify(publicKey);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("chain verify o.k.");
            }
            return true;
        }
        catch (Exception exception) {
            this.logger.error("Chain invalid", exception);
            return false;
        }
    }

    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this.isTrusted(x509CertificateArray)) {
            return;
        }
        throw new CertificateException();
    }

    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (this.isTrusted(x509CertificateArray)) {
            return;
        }
        throw new CertificateException();
    }
}

