/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.handler;

import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imrutility.imr.EndpointProfile;
import org.jacorb.imrutility.imr.Repository;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.util.POAUtil;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSIENT;
import org.omg.IOP.IOR;

public class IMRRequestHandler {
    private Repository rep;
    private final ORB orb;
    private final Logger logger;

    public IMRRequestHandler(ORB orb) {
        this.logger = ((org.jacorb.orb.ORB)orb).getConfiguration().getNamedLogger("jacorb.imr");
        this.orb = orb;
    }

    public void handle_request(ServerRequest request) {
        EndpointProfile[] forwardEndpoints;
        byte[] objKey;
        block8: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("IMRRequestHandler: handle_request for " + request.operation());
            }
            objKey = request.objectKey();
            if (this.rep == null) {
                this.rep = ((org.jacorb.orb.ORB)this.orb).getImR();
                if (this.rep == null) {
                    this.logger.error("unable to locate ImR");
                    throw new TRANSIENT("Unable to locate ImR", 0, CompletionStatus.COMPLETED_NO);
                }
            }
            String pname = POAUtil.extractPOAName(objKey);
            List pnames = POAUtil.extractScopedPOANames(pname);
            String[] poaName = pnames.toArray(new String[pnames.size()]);
            String implName = POAUtil.extractImplName(objKey);
            forwardEndpoints = null;
            try {
                forwardEndpoints = this.rep.locate(implName, poaName);
            }
            catch (Exception ex) {
                if (!this.logger.isDebugEnabled()) break block8;
                this.logger.debug("Caught exception locating " + implName + '/' + pname, ex);
            }
        }
        if (forwardEndpoints != null && forwardEndpoints.length > 0) {
            IOR forwardTo = ((org.jacorb.orb.ORB)this.orb).createIOR("IDL:omg.org/CORBA/Object:1.0", objKey, forwardEndpoints);
            request.setLocationForward(forwardTo);
            if (this.logger.isDebugEnabled()) {
                ParsedIOR ior = new ParsedIOR((org.jacorb.orb.ORB)this.orb, forwardTo);
                this.logger.debug("IMRRequestHandler: Forwarding request to:\n" + ior);
            }
        } else {
            this.logger.debug("ImR unable to locate target object: no forward endpoints available.");
            request.setSystemException(new TRANSIENT("IMR unable to locate target object", 0, CompletionStatus.COMPLETED_NO));
        }
        request.reply();
    }
}

