/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.persistence;

public class DataLock {
    public static final int SHARED = 0;
    public static final int EXCLUSIVE = 1;
    private int sharedCount = 0;
    private int exclusiveCount = 0;
    private boolean waiting = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLock(int lockType) {
        DataLock dataLock = this;
        synchronized (dataLock) {
            if (lockType == 0) {
                while (this.exclusiveCount > 0 && this.waiting) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException iex) {}
                }
                ++this.sharedCount;
            } else {
                while (this.sharedCount > 0 || this.exclusiveCount > 0) {
                    try {
                        this.waiting = true;
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++this.exclusiveCount;
                this.waiting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(int lockType) {
        DataLock dataLock = this;
        synchronized (dataLock) {
            if (lockType == 0) {
                if (--this.sharedCount == 0) {
                    this.notifyAll();
                }
            } else if (--this.exclusiveCount == 0) {
                this.notifyAll();
            }
        }
    }
}

