/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imrutility.imr.util;

import java.io.BufferedReader;
import java.io.FileReader;
import org.jacorb.imrutility.imr.Activator;
import org.jacorb.imrutility.imr.ActivatorHelper;
import org.jacorb.imrutility.imr.AlreadyRegistered;
import org.jacorb.imrutility.imr.CommandInfo;
import org.jacorb.imrutility.imr.NotFound;
import org.jacorb.imrutility.imr.ServerName;
import org.jacorb.imrutility.imr.StartupFailed;
import org.jacorb.imrutility.imr.UnknownServer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class ActivatorManager {
    private static ORB orb;
    private static Activator activator;

    private ActivatorManager() {
    }

    public static void main(String[] args) {
        orb = ORB.init(args, null);
        if (args.length > 0) {
            if (args[0].equals("-h") || args[0].equals("--help")) {
                ActivatorManager.usage();
            } else {
                ActivatorManager.getActivator();
                int i2 = 0;
                if (args[0].startsWith("-ORBInitRef")) {
                    i2 = 1;
                }
                if (args[i2].equals("-l") || args[i2].equals("--list")) {
                    ActivatorManager.list(args);
                } else if (i2 < args.length - 1) {
                    if (args[i2].equals("-a") || args[i2].equals("--add")) {
                        ActivatorManager.addCommand(args);
                    } else if (args[i2].equals("-r") || args[i2].equals("--remove")) {
                        ActivatorManager.removeCommand(args);
                    } else if (args[i2].equals("-s") || args[i2].equals("--start")) {
                        ActivatorManager.startServer(args);
                    } else {
                        ActivatorManager.usage();
                    }
                } else {
                    ActivatorManager.usage();
                }
            }
        } else {
            ActivatorManager.usage();
        }
    }

    private static void list(String[] args) {
        if (args.length <= 2) {
            ActivatorManager.listAll();
        }
    }

    private static void listAll() {
        CommandInfo[] infoArray = null;
        CommandInfo cinfo = null;
        try {
            infoArray = activator.listCommands();
            if (infoArray.length > 0) {
                for (int i2 = 0; i2 < infoArray.length; ++i2) {
                    cinfo = infoArray[i2];
                    String name = ActivatorManager.getName(cinfo.name);
                    System.out.println("Name            : " + name + "\n");
                    System.out.println("Command         : " + cinfo.cmd + "\n");
                }
            } else {
                System.out.println("No commands registered");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception listing commands\n");
            ex.printStackTrace();
        }
    }

    private static void addCommand(String[] args) {
        String name = null;
        CommandInfo cinfo = null;
        StringBuffer sb = new StringBuffer();
        String cmd = "";
        String command = null;
        for (int i2 = 1; i2 < args.length; ++i2) {
            if (i2 >= args.length - 1 && (!cmd.equals("c") || i2 != args.length - 1)) continue;
            if (args[i2].equals("-n") || args[i2].equals("--name")) {
                cmd = "n";
                name = args[++i2];
            }
            if (args[i2].equals("-p") || args[i2].equals("--poa")) {
                System.out.println("Addition of POAs is not yet implemented");
                System.exit(0);
                continue;
            }
            if (args[i2].equals("-c") || args[i2].equals("--command")) {
                cmd = "c";
                sb.append(args[++i2]);
                sb.append(' ');
                continue;
            }
            if (cmd.equals("c")) {
                sb.append(args[i2]);
                if (i2 >= args.length - 1) continue;
                sb.append(' ');
                continue;
            }
            if (!args[i2].equals("-f") && (!args[i2].equals("--comm_file") || cmd.equals("c"))) continue;
            try {
                cmd = "f";
                BufferedReader br = new BufferedReader(new FileReader(args[++i2]));
                command = br.readLine();
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception reading file");
                System.exit(0);
            }
        }
        if (sb.length() > 0) {
            command = sb.toString();
        }
        if (command == null || command.length() == 0) {
            System.out.println("You must provide the start up command");
            System.exit(0);
        }
        if (name == null) {
            System.out.println("You must provide the server name");
            System.exit(0);
        }
        ServerName sname = new ServerName();
        sname.impl(name);
        cinfo = new CommandInfo(sname, command);
        try {
            activator.addCommand(cinfo);
            System.out.println("Command added");
        }
        catch (AlreadyRegistered ar) {
            System.out.println("Command already registered for " + name);
        }
        catch (Exception ex) {
            System.out.println("Exception adding command \n");
            ex.printStackTrace();
        }
    }

    private static void removeCommand(String[] args) {
        String name = null;
        if (args.length == 0) {
            ActivatorManager.usage();
        } else {
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals("-n") || args[i2].equals("--name")) {
                    if (i2 >= args.length - 1) continue;
                    name = args[++i2];
                    continue;
                }
                if (!args[i2].equals("-p") && !args[i2].equals("--poa")) continue;
                System.out.println("Removal of POAs is not yet implemented");
                System.exit(0);
            }
        }
        if (name == null) {
            System.out.println("You must provide the Server name");
            System.exit(0);
        }
        try {
            ServerName sname = new ServerName();
            sname.impl(name);
            activator.removeCommand(sname);
            System.out.println("Command " + name + " removed");
        }
        catch (NotFound nf) {
            System.out.println(name + " :: Command not found");
        }
        catch (Exception ex) {
            System.out.println("Exception removing command \n");
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void startServer(String[] args) {
        block20: {
            String name = null;
            ServerName sname = null;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals("-n") || args[i2].equals("--name")) {
                    if (i2 >= args.length - 1) continue;
                    name = args[++i2];
                    continue;
                }
                if (!args[1].equals("-p") && !args[1].equals("--poa")) continue;
                System.out.println("Starting of POA is not yet implemented");
                System.exit(0);
            }
            if (name == null) {
                System.out.println("You must provide the Server name");
                System.exit(0);
            }
            sname = new ServerName();
            sname.impl(name);
            activator.startServer(sname, true);
            System.out.println("Server " + name + " started");
            java.lang.Object var5_7 = null;
            try {
                activator.serverStarted(sname);
            }
            catch (UnknownServer us2) {
                System.out.println("UnknownServer exception starting server " + sname);
            }
            catch (Exception ex2) {
                System.out.println("Exception from serverStarted " + sname + ex2);
            }
            break block20;
            {
                catch (UnknownServer us) {
                    System.out.println(name + " :: Server startup command not registered");
                    java.lang.Object var5_8 = null;
                    try {
                        activator.serverStarted(sname);
                    }
                    catch (UnknownServer us2) {
                        System.out.println("UnknownServer exception starting server " + sname);
                    }
                    catch (Exception ex2) {
                        System.out.println("Exception from serverStarted " + sname + ex2);
                    }
                    break block20;
                }
                catch (StartupFailed sf) {
                    System.out.println(sf.reason);
                    java.lang.Object var5_9 = null;
                    try {
                        activator.serverStarted(sname);
                    }
                    catch (UnknownServer us2) {
                        System.out.println("UnknownServer exception starting server " + sname);
                    }
                    catch (Exception ex2) {
                        System.out.println("Exception from serverStarted " + sname + ex2);
                    }
                    break block20;
                }
                catch (Exception ex) {
                    System.out.println("Exception starting server \n");
                    ex.printStackTrace();
                    java.lang.Object var5_10 = null;
                    try {
                        activator.serverStarted(sname);
                    }
                    catch (UnknownServer us2) {
                        System.out.println("UnknownServer exception starting server " + sname);
                    }
                    catch (Exception ex2) {
                        System.out.println("Exception from serverStarted " + sname + ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                java.lang.Object var5_11 = null;
                try {
                    activator.serverStarted(sname);
                }
                catch (UnknownServer us2) {
                    System.out.println("UnknownServer exception starting server " + sname);
                }
                catch (Exception ex2) {
                    System.out.println("Exception from serverStarted " + sname + ex2);
                }
                throw throwable;
            }
        }
    }

    private static String getName(ServerName sname) {
        String name = null;
        String[][] names = null;
        java.lang.Object pnames = null;
        if (sname.discriminator()) {
            name = sname.impl();
        } else {
            names = sname.poas();
            if (names != null) {
                for (int i2 = 0; i2 < names.length; ++i2) {
                    for (int j2 = 0; j2 < names[i2].length; ++j2) {
                        name = name + "/";
                        name = name + names[i2][j2];
                    }
                }
            }
        }
        return name;
    }

    private static void usage() {
        String separator = "--------------------------------------------------------------";
        System.out.println("Usage");
        System.out.println(separator);
        System.out.println(" [ -l | --list ]        : lists all commands registered with  ");
        System.out.println("                          the activator                       ");
        System.out.println();
        System.out.println(separator);
        System.out.println(" [ -a | --add ]         : adds a command for a server using   ");
        System.out.println("                          the following options:-             ");
        System.out.println();
        System.out.println("   [ -n | --name ] <name> the name of the server              ");
        System.out.println();
        System.out.println("   [ -p  | --poa ] <poa name> Not yet implemented             ");
        System.out.println();
        System.out.println("   [ -c | --command ] <command>                               ");
        System.out.println("                          the command to be used to start the ");
        System.out.println("                          the server                          ");
        System.out.println("                                                              ");
        System.out.println("   [ -f | --comm_file ] <filename>                            ");
        System.out.println("                          the name of the file containing the ");
        System.out.println("                          start up command.  This option is   ");
        System.out.println("                          required for Windows NT and Win2K   ");
        System.out.println("                          in place of the -c option where the ");
        System.out.println("                          input exceeds the maximum command   ");
        System.out.println("                          line length.                        ");
        System.out.println(separator);
        System.out.println(" [ -r | -- remove ]     : removes the command registered for  ");
        System.out.println("                          the given name/poa name uses the    ");
        System.out.println("                          following options                   ");
        System.out.println("   [-n, | --name] <name>                                      ");
        System.out.println();
        System.out.println("   [ -p  | --poa ] <poa name> Not yet implemented             ");
        System.out.println(separator);
        System.out.println(" [ -s | --start ]       : starts the server using the command ");
        System.out.println("                          previously registered for the given ");
        System.out.println("                          name/poa name, uses the following   ");
        System.out.println("                          options:                            ");
        System.out.println("   [-n, --name] <name>                                        ");
        System.out.println();
        System.out.println("   [ -p  | --poa ] <poa name> Not yet implemented             ");
        System.out.println(separator);
        System.out.println(" [ -h | --help ]          displays this help                  ");
        System.out.println(separator);
        System.exit(0);
    }

    private static void getActivator() {
        try {
            Object obj = orb.resolve_initial_references("IMRActivator");
            activator = ActivatorHelper.narrow(obj);
            if (activator == null) {
                System.out.println("Unable to locate the Activator");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception locating Activator");
            System.out.println(ex.getMessage());
        }
        if (activator == null) {
            System.exit(0);
        }
    }

    static {
        activator = null;
    }
}

