/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.factory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.iiop.IIOPAddress;

public class FixedAddressSocketFactory
extends AbstractSocketFactory {
    private InetAddress localEndpoint;

    public Socket createSocket(String host, int port) throws IOException {
        if (this.localEndpoint != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Will create client socket bound to endpoint " + this.localEndpoint);
            }
            return new Socket(host, port, this.localEndpoint, 0);
        }
        return new Socket(host, port);
    }

    protected Socket doCreateSocket(String host, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        if (this.localEndpoint != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Will create client socket bound to endpoint " + this.localEndpoint);
            }
            socket.bind(new InetSocketAddress(this.localEndpoint, 0));
        }
        socket.connect(new InetSocketAddress(host, port), timeout);
        return socket;
    }

    public boolean isSSL(Socket socket) {
        return false;
    }

    public void configure(Configuration config) throws ConfigurationException {
        super.configure(config);
        String oaiAddr = config.getAttribute("OAIAddr", "");
        if (oaiAddr.length() > 0) {
            this.localEndpoint = new IIOPAddress(oaiAddr, -1).getConfiguredHost();
        }
    }
}

