/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.indications.fropxy;

import enea.ose.system.InSignal;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.common.fropxy.CmaPortManager;
import se.ericsson.cello.common.fropxy.CmaSignalPort;
import se.ericsson.cello.maofro.proxy.MaoFroGenericEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericFaultCeasedInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericFaultInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericFaultUpdateInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedEventInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedFaultCeaseInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericMomDefinedFaultInd;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalObserver;

public class MaoFroIndicationProxy
implements SignalObserver {
    private static MaoFroIndicationProxy instance = null;
    private CmaSignalPort cmaSignalPort = CmaPortManager.instance();
    private static Map subscriberMap = new HashMap();
    private static int CPP_FROTYPE_RANGE_START = 0;
    private static int CPP_FROTYPE_RANGE_LIMIT = 131071;

    private MaoFroIndicationProxy() {
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericParameterChdInd.class);
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericEventInd.class);
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericFaultInd.class);
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericFaultCeasedInd.class);
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericFaultUpdateInd.class);
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericMomDefinedEventInd.class);
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericMomDefinedFaultInd.class);
        this.cmaSignalPort.addSignalObserver(this, MaoFroGenericMomDefinedFaultCeaseInd.class);
    }

    public void signalReceived(InSignal inSignal) {
        Observer observer;
        if (inSignal instanceof MaoFroGenericInd) {
            Integer n = new Integer(((MaoFroGenericInd)inSignal).getFroType());
            observer = (Observer)subscriberMap.get(n);
            if (observer == null) {
                if (CPP_FROTYPE_RANGE_START <= n && n <= CPP_FROTYPE_RANGE_LIMIT) {
                    MessageLog.info(this.getClass(), (String)("No subscriber is registered for the signal " + inSignal.getClass().getName() + " with froType " + n + " , the signal will be discarded"));
                    return;
                }
                MessageLog.trace((int)5, this.getClass(), (String)("No subscriber is registered for the signal " + inSignal.getClass().getName() + " with froType " + n + " , the signal will be discarded"));
                return;
            }
        } else {
            MessageLog.traceError(this.getClass(), (String)("Unexpected signal " + inSignal.getClass().getName() + " sigNo " + inSignal.getSigNo()));
            return;
        }
        if (inSignal.getClass().equals(MaoFroGenericMomDefinedFaultInd.class)) {
            observer.alarmRaised((MaoFroGenericMomDefinedFaultInd)inSignal);
        } else if (inSignal.getClass().equals(MaoFroGenericMomDefinedFaultCeaseInd.class)) {
            observer.alarmCeased((MaoFroGenericMomDefinedFaultCeaseInd)inSignal);
        } else if (inSignal.getClass().equals(MaoFroGenericMomDefinedEventInd.class)) {
            observer.eventRaised((MaoFroGenericMomDefinedEventInd)inSignal);
        } else if (inSignal.getClass().equals(MaoFroGenericFaultInd.class)) {
            observer.alarmRaised((MaoFroGenericFaultInd)inSignal);
        } else if (inSignal.getClass().equals(MaoFroGenericFaultCeasedInd.class)) {
            observer.alarmCeased((MaoFroGenericFaultCeasedInd)inSignal);
        } else if (inSignal.getClass().equals(MaoFroGenericEventInd.class)) {
            observer.eventRaised((MaoFroGenericEventInd)inSignal);
        } else if (inSignal.getClass().equals(MaoFroGenericParameterChdInd.class)) {
            observer.parameterChanged((MaoFroGenericParameterChdInd)inSignal);
        } else if (inSignal.getClass().equals(MaoFroGenericFaultUpdateInd.class)) {
            observer.updateAlarm((MaoFroGenericFaultUpdateInd)inSignal);
        } else {
            MessageLog.traceError(this.getClass(), (String)("Unexpected signal " + inSignal.getClass().getName() + " sigNo " + inSignal.getSigNo()));
        }
    }

    public void addSubscriber(int n, Observer observer) {
        if (!subscriberMap.containsKey(new Integer(n))) {
            subscriberMap.put(new Integer(n), observer);
        } else {
            MessageLog.traceError(this.getClass(), (String)("MaoFroIndicationSubscriber with froType " + n + " is already registered as subscriber"));
        }
    }

    public static synchronized MaoFroIndicationProxy getInstance() {
        if (instance == null) {
            instance = new MaoFroIndicationProxy();
        }
        return instance;
    }

    public static interface Observer {
        public void alarmRaised(MaoFroGenericFaultInd var1);

        public void alarmRaised(MaoFroGenericMomDefinedFaultInd var1);

        public void alarmCeased(MaoFroGenericFaultCeasedInd var1);

        public void alarmCeased(MaoFroGenericMomDefinedFaultCeaseInd var1);

        public void eventRaised(MaoFroGenericEventInd var1);

        public void eventRaised(MaoFroGenericMomDefinedEventInd var1);

        public void parameterChanged(MaoFroGenericParameterChdInd var1);

        public void ceaseAllAlarms();

        public void updateAlarm(MaoFroGenericFaultUpdateInd var1);
    }
}

