/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.util.ArrayList;

public class InetAddressUtil {
    private static final byte ZERO_BYTE = 0;
    private static final int IPV6_PART_COUNT = 8;
    private static final int IPV4_PART_COUNT = 4;
    private static final int MAX_BIT_LENGTH = 255;
    private static final int MAX_IPV4_PART_LENGTH = 3;
    private static final int BYTE_LENGTH = 16;
    private static final String IPV4_DELIM = ".";
    private static final String IPV6_DELIM = ":";
    private static final char IPV4_DELIM_CHAR = '.';
    private static final char IPV6_DELIM_CHAR = ':';

    public static byte[] ipStringToBytes(String string) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                bl2 = true;
                continue;
            }
            if (c == ':') {
                if (bl2) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (Character.digit(c, 16) != -1) continue;
            return null;
        }
        if (bl) {
            if (bl2 && (string = InetAddressUtil.convertDottedQuadToHex(string)) == null) {
                return null;
            }
            return InetAddressUtil.textToNumericFormatV6(string);
        }
        if (bl2) {
            return InetAddressUtil.textToNumericFormatV4(string);
        }
        return null;
    }

    private static byte[] textToNumericFormatV4(String string) {
        String[] stringArray = InetAddressUtil.getIpAddressInStringBytes(string, IPV4_DELIM);
        if (stringArray.length != 4) {
            return null;
        }
        byte[] byArray = new byte[4];
        try {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = InetAddressUtil.parseOctet(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    private static byte[] textToNumericFormatV6(String string) {
        int n;
        int n2;
        String[] stringArray = InetAddressUtil.getIpAddressInStringBytes(string, IPV6_DELIM);
        if (stringArray.length < 3 || stringArray.length > 9) {
            return null;
        }
        int n3 = -1;
        for (n2 = 1; n2 < stringArray.length - 1; ++n2) {
            if (stringArray[n2].length() != 0) continue;
            if (n3 >= 0) {
                return null;
            }
            n3 = n2;
        }
        if (n3 >= 0) {
            n2 = n3;
            n = stringArray.length - n3 - 1;
            if (stringArray[0].length() == 0 && --n2 != 0) {
                return null;
            }
            if (stringArray[stringArray.length - 1].length() == 0 && --n != 0) {
                return null;
            }
        } else {
            n2 = stringArray.length;
            n = 0;
        }
        int n4 = 8 - (n2 + n);
        if (!(n3 < 0 ? n4 == 0 : n4 >= 1)) {
            return null;
        }
        byte[] byArray = new byte[16];
        try {
            short s;
            int n5;
            int n6 = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                s = InetAddressUtil.parseHextet(stringArray[n5]);
                byArray[n6++] = (byte)(s >> 8 & 0xFF);
                byArray[n6++] = (byte)(s & 0xFF);
                if (n6 < 16) continue;
                return byArray;
            }
            for (n5 = 0; n5 < n4; ++n5) {
                byArray[n6++] = 0;
                byArray[n6++] = 0;
                if (n6 < 16) continue;
                return byArray;
            }
            for (n5 = n; n5 > 0; --n5) {
                s = InetAddressUtil.parseHextet(stringArray[stringArray.length - n5]);
                byArray[n6++] = (byte)(s >> 8 & 0xFF);
                byArray[n6++] = (byte)(s & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    private static String[] getIpAddressInStringBytes(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        String string3 = "";
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            if ((n2 = string.indexOf(string2, n)) != -1) continue;
            string3 = string.substring(n, string.length());
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static byte parseOctet(String string) {
        int n = Integer.parseInt(string);
        if (n > 255 || string.startsWith("0") && string.length() > 3) {
            throw new NumberFormatException();
        }
        return (byte)n;
    }

    private static short parseHextet(String string) {
        int n = Integer.parseInt(string, 16);
        if (n > 65535) {
            throw new NumberFormatException();
        }
        return (short)n;
    }

    private static String convertDottedQuadToHex(String string) {
        int n = string.lastIndexOf(58);
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        byte[] byArray = InetAddressUtil.textToNumericFormatV4(string3);
        if (byArray == null) {
            return null;
        }
        String string4 = Integer.toHexString((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        String string5 = Integer.toHexString((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        return string2 + string4 + IPV6_DELIM + string5;
    }
}

