/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.InetAddressUtil;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.Ipv6AddressValidation;
import se.ericsson.cello.moframework.MoAccessException;

public class IpAddressValidation {
    public static final String V4 = "v4";
    public static final String V6 = "v6";

    public static boolean isDefault(String string) throws IpFormatException {
        if (Ipv4AddressValidation.isIpv4(string)) {
            return Ipv4AddressValidation.isDefault(string);
        }
        if (Ipv6AddressValidation.isIpv6(string)) {
            return Ipv6AddressValidation.isUnspecifiedIpv6(string);
        }
        return false;
    }

    public static void validate(String string) throws IpFormatException {
        if (IpAddressValidation.isDefault(string)) {
            return;
        }
        if (Ipv6AddressValidation.isIpv6(string)) {
            Ipv6AddressValidation.validateIpv6(string);
        } else if (Ipv4AddressValidation.isIpv4(string)) {
            Ipv4AddressValidation.validateIpv4(string);
        } else {
            IpAddressValidation.formatException(string, "");
        }
    }

    private static void formatException(String string, String string2) throws IpFormatException {
        throw new IpFormatException("The address " + string + " is not a valid IP" + string2 + " address");
    }

    public static InetAddress getIpAddress(String string) throws IpFormatException {
        try {
            if (string.equals("")) {
                return InetAddress.getLocalHost();
            }
            byte[] byArray = InetAddressUtil.ipStringToBytes(string);
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            IpAddressValidation.formatException(string, "");
            return null;
        }
    }

    public static boolean isLoopBackIpAddress(String string) throws IpFormatException {
        return IpAddressValidation.getIpAddress(string).isLoopbackAddress();
    }

    public static boolean isMultiCastIpAddress(String string) throws IpFormatException {
        return IpAddressValidation.getIpAddress(string).isMulticastAddress();
    }

    public static void validateHostName(String string, String string2, String string3) throws MoAccessException {
        try {
            if (string3.equals(V4)) {
                Ipv4AddressValidation.validateIpv4(string);
            } else if (string3.equals(V6)) {
                Ipv6AddressValidation.validateIpv6(string);
            } else {
                IpAddressValidation.validate(string);
            }
        }
        catch (IpFormatException ipFormatException) {
            try {
                DomainNameValidation.validate(string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new IllegalAttributeValueException(string + " is not valid IpAddress or domain name", "", string2);
            }
        }
    }

    public static String validateServerURL(String string, String string2, String string3) throws MoAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() != 0) {
            if (string.startsWith("[") && string.indexOf("]") > 0) {
                stringBuffer.append(string.substring(string.indexOf("[") + 1, string.indexOf("]")));
                string = string.substring(string.indexOf("]") + 1);
                IpAddressValidation.validateHostName(stringBuffer.toString(), string3, V6);
            } else {
                int n;
                int n2;
                if (string.startsWith("[") && string.indexOf("]") <= 0 || !string.startsWith("[") && string.indexOf("]") >= 0) {
                    throw new IllegalAttributeValueException("Invalid format ", string2, string3);
                }
                for (int i = 0; i < 3; ++i) {
                    n2 = string.indexOf(".");
                    n = string.indexOf("/");
                    if (n < n2) break;
                    stringBuffer.append(string.substring(0, n2 + 1));
                    string = string.substring(n2 + 1);
                }
                n2 = string.indexOf(":");
                n = string.indexOf("/");
                if (n2 > 0) {
                    stringBuffer.append(string.substring(0, n2));
                    string = string.substring(n2);
                } else if (n > 0) {
                    stringBuffer.append(string.substring(0, n));
                    string = string.substring(n);
                } else {
                    stringBuffer.append(string);
                }
                IpAddressValidation.validateHostName(stringBuffer.toString(), string3, V4);
            }
        } else {
            throw new IllegalAttributeValueException("Invalid IpAddress or domain name after http ", string2, string3);
        }
        IpAddressValidation.validatePort(string, string2, string3);
        return string;
    }

    private static void validatePort(String string, String string2, String string3) throws MoAccessException {
        int n;
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != ':') continue;
            ++n2;
        }
        if (n2 > 1) {
            throw new IllegalAttributeValueException("Invalid format of port number ", string2, string3);
        }
        n = string.indexOf(":");
        int n3 = string.indexOf("/");
        if (n2 == 1 && string.length() > 1) {
            if (n != -1 && n3 == -1) {
                try {
                    Integer.parseInt(string.substring(n + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalAttributeValueException("Port number is not valid", string2, string3);
                }
            } else if (n3 != -1) {
                try {
                    Integer.parseInt(string.substring(n + 1, n3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalAttributeValueException("Port number is not valid", string2, string3);
                }
            }
        } else if (n2 == 1 && string.length() == 1) {
            throw new IllegalAttributeValueException("Port number is not mentioned in URL", string2, string3);
        }
    }

    public static String getHostAddress(String string, String string2) throws MoAccessException {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalAttributeValueException("Given " + string + " is an invalid IpAddress or DomainName", string2);
        }
        return string;
    }
}

