/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import se.ericsson.cello.mao.InetAddressUtil;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;

public class Ipv4AddressValidation {
    public static boolean isDefault(String string) throws IpFormatException {
        IpAddress ipAddress = new IpAddress(string);
        return ipAddress.toInt() == 0;
    }

    public static boolean isIpv4(String string) {
        RE rE = new RE("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
        return rE.match(string);
    }

    public static void validateIpv4(String string) throws IpFormatException {
        try {
            new IpAddress(string);
        }
        catch (NumberFormatException numberFormatException) {
            Ipv4AddressValidation.formatException(string);
        }
    }

    public static boolean isValidIpv4Address(String string) {
        if (Ipv4AddressValidation.isIpv4(string)) {
            try {
                Ipv4AddressValidation.validateIpv4(string);
                return true;
            }
            catch (IpFormatException ipFormatException) {
                return false;
            }
        }
        return false;
    }

    public static void validateIpV4addressWithPrefix(String string) throws IpFormatException {
        int n;
        String[] stringArray = new String[2];
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/') continue;
            ++n2;
        }
        if (n2 == 0) {
            Ipv4AddressValidation.validateIpv4(string);
        } else if (n2 == 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            Ipv4AddressValidation.validateIpv4(stringArray[0]);
            int n3 = 0;
            try {
                n3 = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IpFormatException("Not a valid prefix");
            }
            if (n3 < 1 || n3 > 32) {
                throw new IpFormatException("Not a valid prefix length");
            }
        } else {
            Ipv4AddressValidation.formatException(string);
        }
    }

    public static Inet4Address getIpv4Address(String string) throws IpFormatException {
        try {
            if (string.equals("")) {
                return (Inet4Address)InetAddress.getLocalHost();
            }
            byte[] byArray = InetAddressUtil.ipStringToBytes(string);
            return (Inet4Address)InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            Ipv4AddressValidation.formatException(string);
            return null;
        }
    }

    public static boolean isLoopBackIpAddress(String string) throws IpFormatException {
        return Ipv4AddressValidation.getIpv4Address(string).isLoopbackAddress();
    }

    public static boolean isMultiCastIpAddress(String string) throws IpFormatException {
        return Ipv4AddressValidation.getIpv4Address(string).isMulticastAddress();
    }

    public static boolean isInTheSameSubnet(String string, String string2) throws IpFormatException, IpException {
        String string3;
        String string4 = Ipv4AddressValidation.getNetworkAddress(string);
        return string4.startsWith(string3 = Ipv4AddressValidation.getNetworkAddress(string2)) || string3.startsWith(string4);
    }

    public static String getNetworkAddress(String string) throws IpFormatException, IpException {
        int n;
        String[] stringArray = new String[2];
        int n2 = 32;
        String string2 = string;
        int n3 = 0;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '/') continue;
            ++n3;
        }
        if (n3 == 1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
            n2 = Integer.parseInt(stringArray[1]);
            string2 = stringArray[0];
        }
        String string3 = Ipv4AddressValidation.getBinaryAddress(string2);
        String string4 = string3.substring(0, n2);
        return string4;
    }

    public static String getBinaryAddress(String string) throws IpFormatException, IpException {
        String[] stringArray = new String[4];
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            String string2 = Integer.toBinaryString(Integer.parseInt(stringArray[n]));
            int n2 = 8 - string2.length();
            for (int i = 0; i < n2; ++i) {
                string2 = "0" + string2;
            }
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static void formatException(String string) throws IpFormatException {
        throw new IpFormatException("The address " + string + " is not a valid IPv4 address. ");
    }
}

