/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mao;

import se.ericsson.cello.mao.TransactionHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class TransactionHelperImpl
implements TransactionHelper {
    private static TransactionHelper instance;

    public Control createTransaction(int n, int n2) throws TransactionRolledBackException {
        return this.createTransactionWithTimeOut(n, n2, 3600);
    }

    public Control createTransactionWithTimeOut(int n, int n2, int n3) throws TransactionRolledBackException {
        TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
        Control control = null;
        for (int i = 0; i < n2; ++i) {
            MessageLog.trace((int)5, this.getClass(), (String)("Trying " + (i + 1) + " times while waiting for TRANI to be available, " + "from Thread: " + Thread.currentThread().getName()));
            try {
                control = transactionFactory.create(n3);
                break;
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                if (i < n2) {
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        MessageLog.info(this.getClass(), (String)(Thread.currentThread().getName() + " Thread was interrupted while sleeping"));
                    }
                    continue;
                }
                MessageLog.trace((int)5, this.getClass(), (String)("Unable to create transaction due to transaction server unavailable after retrying for " + n2 + " with interval " + n + " ms" + " from thread " + Thread.currentThread().getName()));
                throw transactionRolledBackException;
            }
        }
        MessageLog.trace((int)5, this.getClass(), (String)("Cello_CMA txId = " + control.getCoordinator().getTransactionID() + " was created by " + Thread.currentThread().getName() + " Thread with timeout = " + n3 + " millisec"));
        return control;
    }

    public void commitTransaction(Control control) throws InactiveTransactionException, TransactionRolledBackException {
        try {
            control.getTerminator().commit();
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            throw inactiveTransactionException;
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            throw transactionRolledBackException;
        }
    }

    public void commitTransaction(Coordinator coordinator) throws InactiveTransactionException, TransactionRolledBackException {
        this.getControl(coordinator.getTransactionID()).getTerminator().commit();
    }

    public void commitTransaction(int n) throws InactiveTransactionException, TransactionRolledBackException {
        this.getControl(n).getTerminator().commit();
    }

    public void commitAndHandleException(Control control) {
        try {
            this.commitTransaction(control);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.trace((int)5, this.getClass(), (String)("Transaction " + control.getCoordinator().getTransactionID() + "does not exist or has been already commited, current thread: " + Thread.currentThread().getName()));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.trace((int)5, this.getClass(), (String)("Transaction " + control.getCoordinator().getTransactionID() + "has already been rolled back, current thread: " + Thread.currentThread().getName()));
        }
    }

    private Control getControl(int n) {
        Control control = TransactionServiceImpl.instance().getTransactionFactory().get(n);
        return control;
    }

    private Coordinator getCoordinator(int n) {
        return this.getControl(n).getCoordinator();
    }

    public static TransactionHelper instance() {
        if (instance == null) {
            instance = new TransactionHelperImpl();
        }
        return instance;
    }

    private TransactionHelperImpl() {
    }
}

