/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.pmapp.CelloScanner;
import se.ericsson.cello.pmapp.fropxy.PmEvent;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.support.thread.ActionListener;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class ObjectLifeCycleEvent
implements Resource,
PmEvent {
    private ActionListener objLifeCycleListener;
    private Object theObject;
    private int messageId;
    private static int TRACE_GROUP = 5;

    private ObjectLifeCycleEvent(ActionListener actionListener, Object object, Coordinator coordinator) {
        this.objLifeCycleListener = actionListener;
        this.theObject = object;
        MessageLog.trace((int)TRACE_GROUP, this.getClass(), (String)("constructor() object=" + this.theObject));
        try {
            coordinator.registerResource((Resource)this);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            // empty catch block
        }
    }

    public ObjectLifeCycleEvent(ActionListener actionListener, ManagedObject managedObject, boolean bl, int n, Coordinator coordinator) {
        this(actionListener, managedObject, coordinator);
        if (n == 0) {
            this.messageId = bl ? 107 : 108;
        } else if (n == 1) {
            this.messageId = bl ? 111 : 112;
        } else if (n == 2) {
            this.messageId = bl ? 113 : 114;
        }
    }

    ObjectLifeCycleEvent(ActionListener actionListener, CelloScanner celloScanner, boolean bl, Coordinator coordinator) {
        this(actionListener, (Object)celloScanner, coordinator);
        this.messageId = bl ? 101 : 103;
    }

    ObjectLifeCycleEvent(ActionListener actionListener, PerformanceMonitoringState performanceMonitoringState, Coordinator coordinator) {
        this(actionListener, (Object)performanceMonitoringState, coordinator);
        this.messageId = performanceMonitoringState.value() == 0 ? 104 : 106;
    }

    public void rollback() {
        if (this.messageId == 101) {
            this.messageId = 102;
            MessageLog.trace((int)TRACE_GROUP, this.getClass(), (String)("rollback(): SCANNER_CREATED_ROLLBACK_EVENT_ID " + this));
            this.objLifeCycleListener.actionPerformed(this.getActionEvent());
        } else if (this.messageId == 104) {
            this.messageId = 105;
            MessageLog.trace((int)TRACE_GROUP, this.getClass(), (String)("rollback(): SCANNER_ACTIVATED_ROLLBACK_EVENT_ID " + this));
            this.objLifeCycleListener.actionPerformed(this.getActionEvent());
        } else {
            MessageLog.trace((int)TRACE_GROUP, this.getClass(), (String)("rollback(: )no action " + this));
        }
    }

    public boolean prepare() {
        return true;
    }

    public void commit() {
        MessageLog.trace((int)TRACE_GROUP, this.getClass(), (String)("commit(): " + this));
        this.objLifeCycleListener.actionPerformed(this.getActionEvent());
    }

    public ActionEvent getActionEvent() {
        return new ActionEvent(this.getTheObject(), this.getMessageId(), null);
    }

    private Object getTheObject() {
        return this.theObject;
    }

    private int getMessageId() {
        return this.messageId;
    }

    public String toString() {
        return this.getClass().getName() + ": theObject=" + this.theObject + ", messageId=" + this.messageId;
    }
}

