/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pmapp;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.ericsson.cello.mao.TransactionHelperImpl;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.pmapp.CelloScanner;
import se.ericsson.cello.pmapp.ExtendedMoTypeHandler;
import se.ericsson.cello.pmapp.GenPmMao;
import se.ericsson.cello.pmapp.PmAppPortal;
import se.ericsson.cello.pmapp.fropxy.GenericPmFroProxy;
import se.ericsson.cello.pmapp.fropxy.Mo2FroIdTranslator;
import se.ericsson.cello.pms.generic.CounterCalculator;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;

public class PmAppCounterCalculator
implements CounterCalculator {
    private static PmAppPortal myPmAppPortal;
    private List moTypeList = new LinkedList();
    private static final int TX_TIMEOUT = 60;
    private static final int RETRY_INTERVAL_TRANSACTION_CREATE = 500;
    private static final int MAX_NO_OF_RETRIES_TRANSACTION_CREATE = 20;

    PmAppCounterCalculator(PmAppPortal pmAppPortal) {
        PmAppCounterCalculator.setPmAppPortal(pmAppPortal);
    }

    private static void setPmAppPortal(PmAppPortal pmAppPortal) {
        myPmAppPortal = pmAppPortal;
    }

    void addMoType(String string) {
        this.moTypeList.add(string);
    }

    public int calculate() {
        MessageLog.trace((int)2, this.getClass(), (String)"Enter method calculate().");
        int n = 0;
        Iterator iterator = myPmAppPortal.getCelloScannerFactory().getActiveScanners();
        while (iterator.hasNext()) {
            CelloScanner celloScanner = (CelloScanner)((Object)iterator.next());
            ObservationClass[] observationClassArray = celloScanner.getObservationClassList();
            ObservationObject[] observationObjectArray = celloScanner.getObservationObjectList();
            n += this.calculateActiveCounters(observationClassArray, observationObjectArray);
        }
        MessageLog.trace((int)2, this.getClass(), (String)("Calculate(), Number of active counters: " + n));
        return n;
    }

    public int calculate(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        int n = this.calculateActiveCounters(ExtendedMoTypeHandler.convertToExtendedClasses(observationClassArray), ExtendedMoTypeHandler.convertToExtendedObjects(observationObjectArray));
        MessageLog.trace((int)2, this.getClass(), (String)("Calculate(oc[], oo[]), Number of active counters: " + n));
        return n;
    }

    private int calculateActiveCounters(ObservationClass[] observationClassArray, ObservationObject[] observationObjectArray) {
        Object object;
        String[] stringArray;
        GenericPmFroProxy genericPmFroProxy;
        String string;
        String string2;
        int n;
        int n2 = 0;
        for (n = 0; n < observationClassArray.length; ++n) {
            string2 = observationClassArray[n].object_class_name;
            string = ExtendedMoTypeHandler.extractMoTypefromMoTypeExtended(string2);
            if (!this.moTypeList.contains(string)) continue;
            genericPmFroProxy = myPmAppPortal.getGenericPmFroProxyFactory().lookupByMoType(string2);
            stringArray = ExtendedMoTypeHandler.getIntersection(observationClassArray[n].class_attribute_list, genericPmFroProxy.getAttributeNames());
            MoIterator moIterator = MoRepository.instance().lookupType(string);
            if (moIterator == null) continue;
            while (moIterator.hasMoreElements()) {
                object = (GenPmMao)moIterator.nextMo();
                if (((ManagedObjectBase)object).isCreated()) {
                    n2 += this.calculateActiveCountersForMoInstance((GenPmMao)object, genericPmFroProxy, string, stringArray, false);
                    continue;
                }
                MessageLog.trace((int)2, this.getClass(), (String)("MO found in repository but not committed yet: " + object));
            }
        }
        for (n = 0; n < observationObjectArray.length; ++n) {
            string2 = Mo2FroIdTranslator.extractMoTypeFromDistinguishedName(observationObjectArray[n].instance_list[0]);
            string = ExtendedMoTypeHandler.extractMoTypefromMoTypeExtended(string2);
            if (!this.moTypeList.contains(string)) continue;
            genericPmFroProxy = myPmAppPortal.getGenericPmFroProxyFactory().lookupByMoType(string2);
            stringArray = ExtendedMoTypeHandler.getIntersection(observationObjectArray[n].instance_attribute_list, genericPmFroProxy.getAttributeNames());
            for (int i = 0; i < observationObjectArray[n].instance_list.length; ++i) {
                object = observationObjectArray[n].instance_list[i];
                String string3 = ExtendedMoTypeHandler.replaceMoTypeinDistinguishedName(string, (String)object);
                GenPmMao genPmMao = (GenPmMao)MoRepository.instance().lookup(string3);
                if (genPmMao != null) {
                    if (((ManagedObjectBase)genPmMao).isCreated()) {
                        n2 += this.calculateActiveCountersForMoInstance(genPmMao, genericPmFroProxy, string, stringArray, true);
                        continue;
                    }
                    MessageLog.trace((int)2, this.getClass(), (String)("MO found in repository but not committed yet: " + string3));
                    continue;
                }
                MessageLog.info(this.getClass(), (String)("MO not found in repository for dn " + string3));
            }
        }
        return n2;
    }

    private int calculateActiveCountersForMoInstance(GenPmMao genPmMao, GenericPmFroProxy genericPmFroProxy, String string, String[] stringArray, boolean bl) {
        int n = 0;
        try {
            if (genPmMao.hasPdfActivationAttribute()) {
                n = this.calculatePdfActivatedMo(genPmMao, genericPmFroProxy, stringArray);
            } else if (genPmMao.hasCounterActivationAttribute()) {
                n = this.calculateInstanceActivatedMo(genPmMao, genericPmFroProxy, stringArray, bl);
            } else {
                MessageLog.traceError(this.getClass(), (String)("Calculate should not have been called for MO type: " + string));
            }
        }
        catch (MoAccessException moAccessException) {
            // empty catch block
        }
        return n;
    }

    private int calculatePdfActivatedMo(GenPmMao genPmMao, GenericPmFroProxy genericPmFroProxy, String[] stringArray) {
        int n = 0;
        Control control = null;
        Coordinator coordinator = null;
        try {
            List list = genericPmFroProxy.getNoOfValuesPerAttribute(stringArray);
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < list.size(); ++i) {
                if ((Integer)list.get(i) > 1) {
                    n2 += ((Integer)list.get(i)).intValue();
                    continue;
                }
                n3 += ((Integer)list.get(i)).intValue();
            }
            n = n3;
            control = PmAppCounterCalculator.createTx();
            if (control != null) {
                coordinator = control.getCoordinator();
            }
            if (genPmMao.getCounterActivation(coordinator)) {
                n += n2;
            }
            if (control != null) {
                control.getTerminator().commit();
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"calculatePdfActivatedMo() Calculation of active PDF counters failed.", (Throwable)moAccessException);
            try {
                if (control != null) {
                    control.getTerminator().rollback();
                }
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.info(this.getClass(), (String)("calculatePdfActivatedMo() rollback failed - inactive " + (Object)((Object)inactiveTransactionException)));
            }
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            MessageLog.traceError(this.getClass(), (String)"calculatePdfActivatedMo() commit failed - rollback", (Throwable)transactionRolledBackException);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"calculatePdfActivatedMo() commit failed - inactive", (Throwable)inactiveTransactionException);
        }
        return n;
    }

    private int calculateInstanceActivatedMo(GenPmMao genPmMao, GenericPmFroProxy genericPmFroProxy, String[] stringArray, boolean bl) {
        int n = 0;
        Control control = null;
        Coordinator coordinator = null;
        if (bl) {
            n = stringArray.length;
        } else {
            try {
                control = PmAppCounterCalculator.createTx();
                if (control != null) {
                    coordinator = control.getCoordinator();
                }
                if (genPmMao.getCounterActivation(coordinator)) {
                    n = stringArray.length;
                }
                if (control != null) {
                    control.getTerminator().commit();
                }
            }
            catch (MoAccessException moAccessException) {
                MessageLog.traceError(this.getClass(), (String)"Calculation of active PDF counters failed.", (Throwable)moAccessException);
                try {
                    if (control != null) {
                        control.getTerminator().rollback();
                    }
                }
                catch (InactiveTransactionException inactiveTransactionException) {
                    MessageLog.info(this.getClass(), (String)("rollback failed - inactive " + (Object)((Object)inactiveTransactionException)));
                }
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                MessageLog.traceError(this.getClass(), (String)"calculateInstanceActivatedMo() commit failed - rollback", (Throwable)transactionRolledBackException);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                MessageLog.traceError(this.getClass(), (String)"calculateInstanceActivatedMo() commit failed - inactive", (Throwable)inactiveTransactionException);
            }
        }
        return n;
    }

    private static Control createTx() {
        try {
            Control control = TransactionHelperImpl.instance().createTransactionWithTimeOut(500, 20, 60);
            return control;
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)PmAppCounterCalculator.class, (String)"Transaction", (Throwable)exception);
            return null;
        }
    }
}

