/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.interceptor;

import java.io.PrintWriter;
import java.io.StringWriter;
import se.ericsson.security.corba.TraceErrorLogAdapter;

public class TraceErrorLogger
implements TraceErrorLogAdapter {
    private static TraceErrorLogAdapter impl = null;
    private boolean debug = Boolean.getBoolean("se.ericsson.security.debug");

    public static void setImplementation(TraceErrorLogAdapter traceErrorLogAdapter) {
        impl = traceErrorLogAdapter;
    }

    public void info(Class clazz, String string) {
        if (impl != null) {
            impl.info(clazz, string);
        } else if (this.debug) {
            String string2 = "<>";
            if (clazz != null) {
                string2 = clazz.getName();
            }
            System.out.println("INFO " + string2 + ": " + string);
        }
    }

    public void trace(int n, Class clazz, String string) {
        if (impl != null) {
            impl.trace(n, clazz, string);
        } else if (this.debug) {
            String string2 = "<>";
            if (clazz != null) {
                string2 = clazz.getName();
            }
            System.out.println("TRACE" + n + " " + string2 + ": " + string);
        }
    }

    public void traceError(Class clazz, String string, Throwable throwable) {
        if (impl != null) {
            impl.traceError(clazz, string, throwable);
        } else {
            String string2 = "<>";
            if (clazz != null) {
                string2 = clazz.getName();
            }
            System.err.println("ERROR " + string2 + ": " + string);
            throwable.printStackTrace();
        }
    }

    public void traceStack(int n, Class clazz, String string, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        String string2 = string + " : " + stringWriter.toString();
        if (impl != null) {
            impl.trace(n, clazz, string2);
        } else if (this.debug) {
            String string3 = "<>";
            if (clazz != null) {
                string3 = clazz.getName();
            }
            System.out.println("TRACE" + n + " " + string3 + ": " + string2);
        }
    }
}

