/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Log {
    private static Log instance;
    Logger logger;

    public static synchronized Log getInstance() {
        if (instance == null) {
            instance = new Log();
        }
        return instance;
    }

    private Log() {
        Logger logger = Logger.getLogger("se.ericsson.security.ssu");
        LogManager logManager = LogManager.getLogManager();
        logManager.addLogger(logger);
        this.logger = logger;
        if (System.getProperty("se.ericsson.security.ssu.debug", "false").equalsIgnoreCase("true")) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            this.logger.setLevel(Level.ALL);
            this.logger.addHandler(consoleHandler);
        }
    }

    public void setLevel(String string) {
        try {
            this.logger.setLevel(Level.parse(string));
        }
        catch (Exception exception) {
            this.logger.warning("Could not set log level: " + string);
        }
    }

    public void info(String string) {
        this.logger.info(string);
    }

    public void config(String string) {
        this.logger.config(string);
    }

    public void error(String string) {
        this.logger.config(string);
    }

    public void error(String string, Exception exception) {
        this.logger.log(Level.SEVERE, string, exception);
    }

    public void warning(String string) {
        this.logger.warning(string);
    }

    public void warning(String string, Exception exception) {
        this.logger.log(Level.WARNING, string, exception);
    }

    public void debug(String string) {
        this.logger.fine(string);
    }

    public void debug(String string, Exception exception) {
        this.logger.log(Level.FINE, string, exception);
    }

    public void entering(String string, String string2) {
        this.logger.entering(string, string2);
    }

    public void exiting(String string, String string2) {
        this.logger.exiting(string, string2);
    }
}

