/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

abstract class CharacterEncoder {
    private PrintStream pStream;

    CharacterEncoder() {
    }

    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        this.pStream = new PrintStream(outputStream);
    }

    protected void encodeBufferSuffix(OutputStream outputStream) throws IOException {
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
    }

    protected void encodeLineSuffix(OutputStream outputStream) throws IOException {
        this.pStream.println();
    }

    protected abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        for (int i = 0; i < byArray.length; ++i) {
            int n = inputStream.read();
            if (n == -1) {
                return i;
            }
            byArray[i] = (byte)n;
        }
        return byArray.length;
    }

    public void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n);
            for (int i = 0; i < n; i += this.bytesPerAtom()) {
                if (i + this.bytesPerAtom() <= n) {
                    this.encodeAtom(outputStream, byArray, i, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outputStream, byArray, i, n - i);
            }
            if (n < this.bytesPerLine()) break;
            this.encodeLineSuffix(outputStream);
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encode(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encode(byteArrayInputStream, outputStream);
    }

    public String encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        String string = null;
        try {
            this.encode(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
            string = byteArrayOutputStream.toString("US-ASCII");
        }
        catch (IOException iOException) {
            throw new Error("ChracterEncoder::encodeBuffer internal error: " + iOException);
        }
        return string;
    }

    public void encodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputStream);
        while ((n = this.readFully(inputStream, byArray)) != 0) {
            this.encodeLinePrefix(outputStream, n);
            for (int i = 0; i < n; i += this.bytesPerAtom()) {
                if (i + this.bytesPerAtom() <= n) {
                    this.encodeAtom(outputStream, byArray, i, this.bytesPerAtom());
                    continue;
                }
                this.encodeAtom(outputStream, byArray, i, n - i);
            }
            this.encodeLineSuffix(outputStream);
            if (n >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputStream);
    }

    public void encodeBuffer(byte[] byArray, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.encodeBuffer(byteArrayInputStream, outputStream);
    }

    public String encodeBuffer(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            this.encodeBuffer(byteArrayInputStream, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toString("US-ASCII");
        }
        catch (IOException iOException) {
            throw new Error("ChracterEncoder::encodeBuffer internal error:" + iOException);
        }
    }
}

