/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.portc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import se.ericsson.security.portc.PortException;
import se.ericsson.security.portc.Reply;

abstract class Request {
    private static Random rnd = new Random();
    private final int packetId = rnd.nextInt(1000);
    private final int expectedReplyType;
    private final int type;
    private StringBuffer data;

    protected Request(int n, int n2) {
        this.type = n;
        this.expectedReplyType = n2;
    }

    protected void init(String string) {
        this.data = new StringBuffer();
        this.data.append(this.type).append("|");
        this.data.append(this.packetId).append("|");
        this.data.append(string);
        int n = this.data.length();
        this.data.insert(0, "|");
        this.data.insert(0, n);
    }

    protected void init(int n) {
        this.init(Integer.toString(n));
    }

    final void writeTo(OutputStream outputStream) throws IOException {
        if (this.data == null) {
            throw new IOException("Request not initilized");
        }
        outputStream.write(this.data.toString().getBytes());
        outputStream.flush();
    }

    void parseReply(Reply reply) throws PortException {
        if (reply.getPacketId() != this.packetId) {
            throw new PortException("Send packed with id " + this.packetId + " but received packed with id " + reply.getPacketId());
        }
        if (reply.getReplyType() != this.expectedReplyType) {
            throw new PortException("Unexpected reply packet type: " + reply);
        }
        if (reply.getErrorCode() != 0) {
            throw new PortException(reply.getErrorMessage());
        }
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return "Unitialized request of type " + this.type;
    }
}

