/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.common.util;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.supsys.omf.aue.common.CrbsSsMetaData;

public class CrbsSsDbUtil {
    private static final Class THIS_CLASS = CrbsSsDbUtil.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    private CrbsSsDbUtil() {
    }

    public static boolean apcFroVersionsTableExist(int n) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "apcFroVersionsTableExist()");
        boolean bl = false;
        DbWrapper dbWrapper = null;
        ResultSet resultSet = null;
        try {
            dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            dbWrapper.openConnection();
            CrbsSsMetaData crbsSsMetaData = new CrbsSsMetaData();
            resultSet = dbWrapper.executeQuery("SELECT COUNT(*) FROM tables WHERE name=" + AueUtil.quote((String)crbsSsMetaData.getFroVersionsTableName()));
            if (resultSet.next()) {
                bl = resultSet.getInt(1) == 1;
            }
        }
        catch (SQLException sQLException) {
            throw new CrbsAueException(AueUtil.appendReason((String)"Failed to retrive information from db.", (Throwable)sQLException), (Throwable)sQLException);
        }
        finally {
            try {
                dbWrapper.closeConnection(n);
            }
            catch (Exception exception) {}
            try {
                resultSet.close();
            }
            catch (Exception exception) {}
        }
        logger.traceReturn(THIS_CLASS, "apcFroVersionsTableExist()");
        return bl;
    }
}

