/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.actions.TableAlreadyExistsException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.ChangeAttributeValueAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;

public class HandleFroSauPositionRefAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = HandleFroSauPositionRefAction.class;
    private static TableHandler tableHandler;
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final String HWUNIT_MO_TYPE = "HwUnit";
    private static final String HWUNIT_TYPE_SAU = "sau";
    private static final String LDN_ATTRIBUTE_NAME = "ldn";
    private static final int CABINET_FRO_TYPE = 0x7040000;
    private static final String POSITION_REF_ATTRIBUTE_NAME = "positionRef";
    private static final String UNIT_TYPE_ATTRIBUTE_NAME = "unitType";
    private static final String SAU_UPDATED_TAG = "sauPositionRefsUpdated";
    private static final String SAU_LIST_TAG = "sauList";
    private final StringBuffer sauList = new StringBuffer();
    private boolean sauUpdated = false;
    private static final AbstractLogger logger;

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        this.findAndUpdateSaus(aueContext);
        try {
            tableHandler.storeInAuePersistency("", SAU_UPDATED_TAG, Boolean.toString(this.sauUpdated));
            tableHandler.storeInAuePersistency("", SAU_LIST_TAG, this.sauList.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("convert(): Failed to store in AUE persistency tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void findAndUpdateSaus(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findAndUpdateSaus()");
        try {
            TableData tableData = null;
            tableData = tableHandler.getTableData(HWUNIT_MO_TYPE);
            if (tableData != null && tableData.isNotEmpty()) {
                String string = this.getLdnToFirstCabinet();
                String string2 = TableDataUtil.createMoRefXmlString((String)POSITION_REF_ATTRIBUTE_NAME, (String)string, (String)Integer.toString(0x7040000), (String)this.getFroIdForCabinet(string));
                Object[] objectArray = TableDataUtil.getLdns((TableData)tableData);
                Object[] objectArray2 = tableData.getAttributeValues(POSITION_REF_ATTRIBUTE_NAME);
                Object[] objectArray3 = tableData.getAttributeValues(UNIT_TYPE_ATTRIBUTE_NAME);
                for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                    if (!objectArray3[i].toString().equalsIgnoreCase(HWUNIT_TYPE_SAU) || !this.isOkToSetPositionRef(objectArray2[i].toString()) || string == null) continue;
                    this.sauUpdated = true;
                    this.setAttributePositionRef(aueContext, string2, LdnUtil.getRdnValue((String)objectArray[i].toString()));
                    tableHandler.storeInAuePersistency(objectArray[i].toString(), POSITION_REF_ATTRIBUTE_NAME, string);
                    this.sauList.append((this.sauList.length() > 0 ? ":" : "") + objectArray[i]);
                }
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("findAndUpdateSaus(): Failed to find read Cabinet or HwUnit tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "findAndUpdateSaus()");
    }

    private String getFroIdForCabinet(String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroIdForCabinet()");
        TableData tableData = null;
        String string2 = null;
        try {
            tableData = tableHandler.getTableData(CABINET_MO_TYPE);
            if (tableData != null) {
                string2 = TableDataUtil.getFroid((String)string, (TableData)tableData);
                logger.traceGeneral(THIS_CLASS, "getFroIdForCabinet(): CabinetLdn: " + string + " FroId: " + string2);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("getFroIdForCabinet(): Failed to find read Cabinet.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "getFroIdForCabinet()");
        return string2;
    }

    private void setAttributePositionRef(AueContext aueContext, String string, String string2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setAttributePositionRef()");
        try {
            ChangeAttributeValueAction changeAttributeValueAction = new ChangeAttributeValueAction();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("Mo", HWUNIT_MO_TYPE);
            hashMap.put("rdnValue", string2);
            hashMap.put("attribute", POSITION_REF_ATTRIBUTE_NAME);
            hashMap.put("newAttributeValue", string);
            changeAttributeValueAction.setMoActionArgs(hashMap);
            changeAttributeValueAction.convert(aueContext);
        }
        catch (NoSuchTableException noSuchTableException) {
            throw new CrbsAueException("setAttributePositionRef(): Failed to find HwUnit table.", (Throwable)noSuchTableException);
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            throw new CrbsAueException("setAttributePositionRef(): HwUnit tabledata already exist.", (Throwable)tableAlreadyExistsException);
        }
        logger.traceReturn(THIS_CLASS, "setAttributePositionRef()");
    }

    private boolean isOkToSetPositionRef(String string) {
        logger.traceEnter(THIS_CLASS, "isOkToSetPositionRef()");
        if (string == null) {
            logger.traceReturn(THIS_CLASS, "isOkToSetPositionRef(): positionRef is NULL");
            return true;
        }
        if (TableDataUtil.getLdnFromMoRef((String)string).equalsIgnoreCase("") || string.equalsIgnoreCase("")) {
            logger.traceReturn(THIS_CLASS, "isOkToSetPositionRef(): LDN is empty");
            return true;
        }
        logger.traceReturn(THIS_CLASS, "isOkToSetPositionRef(): false");
        return false;
    }

    private String getLdnToFirstCabinet() throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getLdnToFirstCabinet()");
        TableData tableData = null;
        String string = null;
        try {
            tableData = tableHandler.getTableData(CABINET_MO_TYPE);
            if (tableData != null && tableData.isNotEmpty()) {
                Map map = tableData.getRecordMap(0);
                string = (String)map.get(LDN_ATTRIBUTE_NAME);
                String string2 = TableDataUtil.getFroid((String)string, (TableData)tableData);
                logger.traceGeneral(THIS_CLASS, "getLdnToFirstCabinet(): CabinetLdn: " + string + " FroId: " + string2);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("getLdnToFirstCabinet(): Failed to find read Cabinet.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "getLdnToFirstCabinet()");
        return string;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }
}

