/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.swmanagement.LoadModuleMo;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class CabinetParametersHelper
extends DefaultHandler {
    private static final String PROFILE_EXTENDED = "ProfileExtended";
    private static final String PROFILE_STANDARD = "ProfileStandard";
    private static final Class THIS_CLASS = CabinetParametersHelper.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CABINET = "Cabinet";
    private static final String EXTERNAL_NODES = "ExternalNodes";
    private static final String CLIMATE_REGULATION = "ClimateRegulationSystem";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String MANAGED_ELEMENT_LDN = "ManagedElement=1";
    public static final String XML_FILE_NAME = "RbsCabinetParametersLm.xml";
    public static final String XML_FILE_SUBPATH = "cabinet" + File.separator;
    private static final String CABINETPAR_CXC_CRBS = "CXC2010275/";
    private static final String CABINET_TYPE_START_STRING = "RBS";
    private static final int CABINET_TYPE_LENGTH = 7;
    private static final char SPACE_CHARACTER = ' ';
    private String cabinetType = "";
    private int defaultNumberOfExternalNodes = 0;
    private String climateRegulationSystem = null;
    private String standardParameters = null;
    private String extendedParameters = null;
    private boolean done = false;
    private boolean foundCabinet = false;
    private boolean useClimateRegulationSystem = false;
    private boolean foundClimateRegulationSystem = false;
    private boolean isParsed = false;

    public int getDefaultNumberOfExternalNodes(AueContext aueContext) throws CrbsAueException {
        this.parseIfNecessary(aueContext, this.getProductNameFromManagedElementMO(aueContext));
        if (!this.foundCabinet) {
            throw new CrbsAueException("Failed to find cabinet type \"" + this.cabinetType + "\" in CabinetParameters file");
        }
        return this.defaultNumberOfExternalNodes;
    }

    public String getStandardParameters(AueContext aueContext) throws CrbsAueException {
        this.parseIfNecessary(aueContext, this.getProductNameFromManagedElementMO(aueContext));
        return this.standardParameters;
    }

    public String getStandardParameters(AueContext aueContext, String string) throws CrbsAueException {
        this.climateRegulationSystem = string;
        this.parseIfNecessary(aueContext, this.getProductNameFromManagedElementMO(aueContext));
        return this.standardParameters;
    }

    public String getStandardParameters(AueContext aueContext, String string, String string2) throws CrbsAueException {
        this.climateRegulationSystem = string2;
        this.parseIfNecessary(aueContext, string);
        return this.standardParameters;
    }

    public String getExtendedParameters(AueContext aueContext) throws CrbsAueException {
        this.parseIfNecessary(aueContext, this.getProductNameFromManagedElementMO(aueContext));
        return this.extendedParameters;
    }

    public String getExtendedParameters(AueContext aueContext, String string) throws CrbsAueException {
        this.climateRegulationSystem = string;
        this.parseIfNecessary(aueContext, this.getProductNameFromManagedElementMO(aueContext));
        return this.extendedParameters;
    }

    public String getExtendedParameters(AueContext aueContext, String string, String string2) throws CrbsAueException {
        this.climateRegulationSystem = string2;
        this.parseIfNecessary(aueContext, string);
        return this.extendedParameters;
    }

    private void parseIfNecessary(AueContext aueContext, String string) throws CrbsAueException {
        if (!this.isParsed) {
            this.cabinetType = this.filterCabinetType(string);
            String string2 = this.getFilePathFromLoadModuleMo(aueContext);
            String string3 = this.getCabinetParamtersFilePath(string2);
            String string4 = this.getCabParamsFileContent(string3);
            this.useClimateRegulationSystem = string4.indexOf(CLIMATE_REGULATION) != -1;
            this.parse(string4);
            this.isParsed = true;
        }
    }

    public String getProductNameFromManagedElementMO(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getProductNameFromManagedElementMO");
        try {
            MoAccessor moAccessor = ((CollectorContext)aueContext).getMoAccessor();
            ManagedElementMo managedElementMo = (ManagedElementMo)moAccessor.lookup(MANAGED_ELEMENT_LDN);
            if (null == managedElementMo) {
                throw new CrbsAueException("Can't find ManagedElement=1");
            }
            String string = managedElementMo.getProductName(null);
            logger.traceReturn(THIS_CLASS, "getProductNameFromManagedElementMO - productName: " + string);
            return string;
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to find read productName from ManagedElement.", (Throwable)moAccessException);
        }
    }

    public String filterCabinetType(String string) {
        String string2 = string;
        if (string2 != null && (string2.endsWith("L") || string2.endsWith("W") || string2.endsWith("G"))) {
            string2 = this.filterCabinetType(string2.substring(0, string2.length() - 1));
        }
        return string2;
    }

    public static String getValidCabinetTypeFromProductName(String string) {
        logger.traceEnter(THIS_CLASS, "getValidCabinetTypeFromProductName()");
        String string2 = CabinetParametersHelper.removeSpaces(string.toUpperCase());
        int n = string2.indexOf(CABINET_TYPE_START_STRING);
        String string3 = n >= 0 && string2.length() >= n + 7 ? string2.substring(n, n + 7) : "";
        if ("RBS6201".equals(string3)) {
            string3 = "RBS6201V2";
        }
        logger.traceReturn(THIS_CLASS, "getValidCabinetTypeFromProductName()");
        return string3;
    }

    public static String removeSpaces(String string) {
        logger.traceEnter(THIS_CLASS, "stripSpaces() - text: " + string);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (' ' == c) continue;
            stringBuffer.append(c);
        }
        logger.traceReturn(THIS_CLASS, "stripSpaces()");
        return stringBuffer.toString();
    }

    private String getFilePathFromLoadModuleMo(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFilePathFromLoadModuleMo");
        String string = null;
        MoAccessor moAccessor = ((CollectorContext)aueContext).getMoAccessor();
        try {
            MoIterator moIterator = moAccessor.lookupType("UpgradePackage");
            if (moIterator == null) {
                throw new CrbsAueException("Can not find any UpgradePackage MO.");
            }
            UpgradePackageMo upgradePackageMo = null;
            UpgradePackageMo upgradePackageMo2 = null;
            while (moIterator.hasMoreElements()) {
                upgradePackageMo = (UpgradePackageMo)moIterator.nextMo();
                if (2 != upgradePackageMo.getState(null)) continue;
                upgradePackageMo2 = upgradePackageMo;
                break;
            }
            if (upgradePackageMo2 == null) {
                throw new CrbsAueException("No Upgrading UpgradePackage Mo Found.");
            }
            ManagedObject[] managedObjectArray = upgradePackageMo2.getLoadModuleList(null);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject managedObject = managedObjectArray[i];
                if (managedObject.getRelativeDistinguishedName().indexOf(CABINETPAR_CXC_CRBS) <= -1) continue;
                string = ((LoadModuleMo)managedObject).getLoadModuleFilePath(null);
                logger.traceDebug(THIS_CLASS, "Read local path from Loadmodule " + managedObject.getLocalDistinguishedName());
                break;
            }
            if (string == null) {
                throw new CrbsAueException("Loadmodule CXC2010275/ is missing in current upgrade package: " + upgradePackageMo2.getRelativeDistinguishedName() + ". Unable to set cabinet parameters.");
            }
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to find Loadmodule CXC2010275/.", (Throwable)moAccessException);
        }
        logger.traceReturn(THIS_CLASS, "getFilePathFromLoadModuleMo = '" + string + "'");
        return string;
    }

    private String getCabinetParamtersFilePath(String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getCabinetParamtersFilePath");
        if (string == null) {
            throw new CrbsAueException("File RbsCabinetParametersLm.xml could not be found on node.");
        }
        String string2 = string.endsWith(XML_FILE_NAME) ? string : (string.endsWith(File.separator) ? string + XML_FILE_SUBPATH + XML_FILE_NAME : string + File.separator + XML_FILE_SUBPATH + XML_FILE_NAME);
        logger.traceReturn(THIS_CLASS, "getCabinetParamtersFilePath - file path: " + string2);
        return string2;
    }

    private String getCabParamsFileContent(String string) throws CrbsAueException {
        StringBuffer stringBuffer;
        block8: {
            logger.traceEnter(THIS_CLASS, "getCabParamsFileContent");
            stringBuffer = new StringBuffer();
            File file = new File(string);
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    stringBuffer.append(string2);
                    string2 = bufferedReader.readLine();
                }
                if (bufferedReader == null) break block8;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new CrbsAueException("Failed to close CabinetParameters file. ", (Throwable)iOException);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CrbsAueException("Failed to open CabinetParameters file.", (Throwable)fileNotFoundException);
            }
            catch (IOException iOException) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException2) {
                    logger.traceAbnormal(THIS_CLASS, "getCabParamsFileContent() - Failed to close CabinetParameters file after caught exception: " + iOException2);
                }
                throw new CrbsAueException("Failed to read CabinetParameters file.", (Throwable)iOException);
            }
        }
        logger.traceReturn(THIS_CLASS, "getCabParamsFileContent");
        return stringBuffer.toString();
    }

    public void parse(String string) throws CrbsAueException {
        this.defaultNumberOfExternalNodes = 0;
        this.done = false;
        this.foundCabinet = false;
        this.foundClimateRegulationSystem = false;
        InputStream inputStream = null;
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this);
            inputStream = new ByteArrayInputStream(string.getBytes());
            xMLReader.parse(new InputSource(inputStream));
        }
        catch (Exception exception) {
            String string2 = AueUtil.appendReason((String)("Could not parse xml:" + string), (Throwable)exception);
            logger.traceError(THIS_CLASS, string2, (Throwable)exception);
            throw new CrbsAueException(string2);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                logger.traceAbnormal(THIS_CLASS, "CabinetParamtersParser.parse() - Failed to close input stream");
            }
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.done) {
            return;
        }
        if (CABINET.equals(string3)) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals(TYPE) || !attributes.getValue(i).equalsIgnoreCase(this.cabinetType)) continue;
                logger.info(THIS_CLASS, "startElement(): CabinetType: " + attributes.getValue(i));
                this.foundCabinet = true;
                break;
            }
        } else if (this.foundCabinet && EXTERNAL_NODES.equals(string3)) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals(VALUE)) continue;
                this.defaultNumberOfExternalNodes = Integer.parseInt(attributes.getValue(i));
                break;
            }
        } else if (this.foundCabinet && this.useClimateRegulationSystem && CLIMATE_REGULATION.equals(string3)) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).equals(VALUE) || !attributes.getValue(i).equals(this.climateRegulationSystem)) continue;
                logger.info(THIS_CLASS, "startElement(): Found matching climateRegulationSystem, " + this.climateRegulationSystem);
                this.foundClimateRegulationSystem = true;
                break;
            }
        } else if (this.foundCabinet && PROFILE_STANDARD.equals(string3) && (!this.useClimateRegulationSystem || this.foundClimateRegulationSystem)) {
            this.standardParameters = this.getStringValue(attributes);
        } else if (this.foundCabinet && PROFILE_EXTENDED.equals(string3) && (!this.useClimateRegulationSystem || this.foundClimateRegulationSystem)) {
            this.extendedParameters = this.getStringValue(attributes);
        }
    }

    private String getStringValue(Attributes attributes) {
        String string = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getQName(i).equals(VALUE)) continue;
            string = attributes.getValue(i).toString();
            break;
        }
        return string;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(CABINET) && this.foundCabinet && !this.done) {
            this.done = true;
        } else if (string3.equals(CLIMATE_REGULATION) && this.foundCabinet && this.useClimateRegulationSystem && this.foundClimateRegulationSystem) {
            this.foundClimateRegulationSystem = false;
        }
    }
}

