/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.fm.alv;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import se.ericsson.cello.emas.fm.alv.AlarmLogApplicationView;
import se.ericsson.cello.emas.fm.alv.AlarmLogRecord;
import se.ericsson.cello.emas.fm.common.AlarmSortedTable;
import se.ericsson.cello.emas.fm.common.AlarmSortedTableModel;
import se.ericsson.cello.emas.fm.common.ColorCodedColumns;
import se.ericsson.cello.emas.fm.common.DetailsController;
import se.ericsson.cello.emas.fm.common.DetailsView;
import se.ericsson.cello.emas.fm.common.ParseXML;
import se.ericsson.cello.emas.fm.common.RightCellRenderer;
import se.ericsson.cello.emas.fm.common.RowDataInterface;
import se.ericsson.cello.emas.fm.common.SelectedObjectInterface;
import se.ericsson.cello.emas.fm.common.TimeFormatRenderer;
import se.ericsson.cello.emas.fm.common.TimeFormatter;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractController;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.Printout;
import se.ericsson.cello.support.mgr.TimeConverter;

public class AlarmLogApplicationController
extends AbstractApplicationController
implements SelectedObjectInterface {
    private AlarmLogApplicationView alarmview;
    private AlarmLogApplicationController ac;
    DetailsController openedAlarmDetails = null;
    private String userid;
    boolean retrievingFinished;
    private int totalAlarms = 0;
    private AlarmSortedTableModel myModelA;
    private PrintAction printAction = new PrintAction();
    private PageLayoutAction pageLayoutAction = new PageLayoutAction();
    private Printout printout = null;
    private PrintPreviewAction printPreviewAction = new PrintPreviewAction();
    private ExportAction exportAction = new ExportAction();
    Vector columnNamesA = new Vector();
    Menu1Listener menu1listener;
    Table1MouseLis mytable1MouseLis;
    AlarmDetails myaddinfo;
    Refresh myrefresh;
    private Vector lines = new Vector();
    private boolean runningRefresh = false;
    private boolean faultInRecord = false;
    private boolean ackIsAvailable;

    protected void init() {
        this.ac = this;
        this.alarmview = (AlarmLogApplicationView)this.getView();
        this.userid = this.getApplication().getUserId();
        this.getAckStatus();
        this.alarmview.idValueLabel.setText(this.userid);
        this.getApplication().setTitle("ALV_APPLICATION_TITLE", null);
        this.retrievingFinished = true;
        this.alarmview.printMenuItem.addActionListener(this.printAction);
        this.alarmview.printPreviewMenuItem.addActionListener(this.printPreviewAction);
        this.alarmview.exportMenuItem.addActionListener(this.exportAction);
        this.alarmview.pageLayoutMenuItem.addActionListener(this.pageLayoutAction);
        String columnTags = this.getString("ALARMLOG_COLUMNS", null).trim();
        if (columnTags.trim().equals("")) {
            this.columnNamesA.addElement("SEVERITY");
            this.columnNamesA.addElement("EVENT_TYPE");
            this.columnNamesA.addElement("EVENT_TIME");
            this.columnNamesA.addElement("MANAGED_OBJECT_INSTANCE");
            this.columnNamesA.addElement("PROBABLE_CAUSE");
            this.columnNamesA.addElement("SPECIFIC_PROBLEM");
            this.columnNamesA.addElement("ADDITIONAL_TEXT");
        } else {
            StringTokenizer columntok = new StringTokenizer(columnTags, ",", false);
            while (columntok.hasMoreTokens()) {
                this.columnNamesA.addElement(columntok.nextToken().trim());
            }
        }
        if (this.ackIsAvailable) {
            this.columnNamesA.addElement("ACK");
        }
        this.myModelA = new AlarmSortedTableModel();
        this.myModelA.setColumnIdentifiers(this.columnNamesA);
        this.alarmview.jTable1.setModel(this.myModelA);
        this.menu1listener = new Menu1Listener();
        this.mytable1MouseLis = new Table1MouseLis();
        this.alarmview.jMenuAlarm.addMenuListener(this.menu1listener);
        this.alarmview.jTable1.addMouseListener(this.mytable1MouseLis);
        this.alarmview.jTable1.getColumnModel().getColumn(0).setCellRenderer(new ColorCodedColumns());
        String rightAligned = this.getString("RIGHT_ALIGNED_COLUMNS", null).trim();
        if (!rightAligned.trim().equals("")) {
            StringTokenizer columnRightTok = new StringTokenizer(rightAligned, ",", false);
            while (columnRightTok.hasMoreTokens()) {
                try {
                    TableColumn x = this.alarmview.jTable1.getColumn(columnRightTok.nextToken());
                    x.setCellRenderer(new RightCellRenderer());
                }
                catch (Exception exep) {}
            }
        }
        try {
            TableColumn x = this.alarmview.jTable1.getColumn("EVENT_TIME");
            x.setCellRenderer(new TimeFormatRenderer());
        }
        catch (Exception exep) {
            Log.logError((String)"Error occured while setting cell renderer");
        }
        this.myaddinfo = new AlarmDetails();
        this.myrefresh = new Refresh();
        this.alarmview.jMenuItemDetails.addActionListener(this.myaddinfo);
        this.alarmview.jMenuItemRefresh.addActionListener(this.myrefresh);
        this.alarmview.popupmenuitemDetails.addActionListener(this.myaddinfo);
        this.processAlarmList();
        if (!this.runningRefresh && this.faultInRecord) {
            this.showMessageDialogForEventLogRecordFault();
        }
    }

    protected void beforeVisible() {
        this.alarmview.setHelpOnWindowKey();
    }

    protected void afterVisible() {
    }

    void processAlarmList() {
        this.setTheTime();
        this.parseFile("input");
        this.alarmview.jTable1.sort();
        this.alarmview.TopLabel2.setText("[" + this.totalAlarms + "]");
    }

    private void getAckStatus() {
        String columnTag = this.getString("ACKNOWLEDGEMENT_USED", null).trim();
        if (columnTag.equals("Yes")) {
            this.ackIsAvailable = true;
        }
    }

    private boolean isAckAvailable() {
        return this.ackIsAvailable;
    }

    private void parseFile(String io) {
        URL xmlURL = null;
        try {
            String name = EmasSystemProperties.getProperty((String)"alarmlogFile", (String)"/logfiles/alarm_log.xml");
            String debuggingOn = EmasSystemProperties.getProperty((String)"debugging", (String)"false");
            if (debuggingOn.equals("false")) {
                URL emasURL = EmasFramework.getEmasBaseUrl();
                xmlURL = new URL(emasURL.getProtocol(), emasURL.getHost(), emasURL.getPort(), name);
            } else {
                URL hostnameURL = new URL(EmasSystemProperties.getProperty((String)"hostAddress"));
                xmlURL = new URL(hostnameURL.getProtocol(), hostnameURL.getHost(), hostnameURL.getPort(), name);
            }
            Log.trace((String)("Get alarm log file from " + xmlURL));
            ParseXML parser = new ParseXML();
            Iterator iterator = parser.parse(new InputSource(xmlURL.openStream()), "RecordContent");
            while (iterator.hasNext()) {
                String content = (String)iterator.next();
                ++this.totalAlarms;
                if (io.equals("input")) {
                    this.parseLineForReading(content);
                    continue;
                }
                if (io.equals("output")) {
                    this.parseLineForWriting(content);
                    continue;
                }
                Log.logError((String)"This shouldn't happen; error in parsing");
            }
        }
        catch (MalformedURLException me) {
            this.reportException(me, "ERROR_XML", null);
        }
        catch (FileNotFoundException fnfe) {
            this.reportException(fnfe, "ERROR_FNF", null);
        }
        catch (IOException ioe) {
            this.reportException(ioe, "ERROR_PARSE", null);
        }
        catch (ParserConfigurationException e) {
            this.reportException(e, "ERROR_PARSE", null);
        }
        catch (SAXException e) {
            this.reportException(e, "ERROR_PARSE", null);
        }
    }

    private void parseLineForReading(String in) {
        AlarmLogRecord lr = new AlarmLogRecord(in, this.isAckAvailable());
        if (lr.getErrorInRecord()) {
            this.myModelA.addRowNoUpdate(lr);
        } else {
            this.faultInRecord = true;
        }
    }

    private void showMessageDialogForEventLogRecordFault() {
        this.showMessageDialog("ERROR_XML", null, "ERROR_TITLE", null, 0, null);
    }

    private void parseLineForWriting(String in) {
        AlarmLogRecord lr = new AlarmLogRecord(in, this.isAckAvailable());
        String line = lr.getLineForWriting();
        this.lines.addElement(line);
    }

    private void disableAlarmMenuItems() {
        this.alarmview.jMenuItemDetails.setEnabled(false);
    }

    public boolean canStop() {
        try {
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public void setTheTime() {
        String timeString = new TimeConverter().getCurrentTime();
        this.alarmview.TopLabel4.setText(timeString);
    }

    public RowDataInterface getSelectedObject() {
        RowDataInterface tmpRecord = null;
        int selectedIndex = this.alarmview.jTable1.getOriginalRow(this.alarmview.jTable1.getSelectedRow());
        tmpRecord = (RowDataInterface)this.myModelA.getRow(selectedIndex);
        return tmpRecord;
    }

    public void disposeDetailWindow() {
        this.openedAlarmDetails = null;
    }

    public AbstractDialogController startDialog(boolean modal, String titleKey, Object[] titleArgs, Class dialogViewClass, Class dialogControllerClass) {
        this.getApplication().setCursor(Application.DEFAULT_CURSOR);
        return super.startDialog(modal, titleKey, titleArgs, dialogViewClass, dialogControllerClass, (Object[][])null);
    }

    public void stopApp() {
        this.viewClosing();
    }

    protected void viewClosing() {
        this.getApplicationManager().exitApplicationEMTApp();
    }

    private class Menu1Listener
    implements MenuListener {
        private Menu1Listener() {
        }

        public void menuSelected(MenuEvent e) {
            int[] numSelectedRowsTable = ((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1.getSelectedRows();
            if (numSelectedRowsTable.length == 0) {
                AlarmLogApplicationController.this.disableAlarmMenuItems();
            } else if (((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1.getSelectedRow() != -1) {
                if (numSelectedRowsTable.length == 1) {
                    ((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jMenuItemDetails.setEnabled(true);
                } else if (numSelectedRowsTable.length > 1) {
                    ((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jMenuItemDetails.setEnabled(false);
                }
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    private class Refresh
    implements ActionListener {
        private Refresh() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmLogApplicationController.this.runningRefresh = true;
            AlarmLogApplicationController.this.faultInRecord = false;
            AlarmLogApplicationController.this.getApplication().setStatus("STATUS_ALARMLOG_REBUILD", null);
            if (((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1.getModel().getRowCount() != 0) {
                AlarmLogApplicationController.this.myModelA.removeAllRows();
            }
            AlarmLogApplicationController.this.totalAlarms = 0;
            AlarmLogApplicationController.this.processAlarmList();
            AlarmLogApplicationController.this.getApplication().setStatus("", null);
            if (AlarmLogApplicationController.this.faultInRecord) {
                AlarmLogApplicationController.this.showMessageDialogForEventLogRecordFault();
            }
        }
    }

    private class AlarmDetails
    implements ActionListener {
        private AlarmDetails() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmLogApplicationController.this.getApplication().setStatus("", null);
            if (AlarmLogApplicationController.this.openedAlarmDetails != null) {
                AlarmLogApplicationController.this.openedAlarmDetails.stopDialog();
            }
            AlarmLogApplicationController.this.openedAlarmDetails = (DetailsController)AlarmLogApplicationController.this.startDialog(false, "ALARM_DETAILS_TITLE", null, DetailsView.class, DetailsController.class);
        }
    }

    private class Table1MouseLis
    extends MouseAdapter {
        private Table1MouseLis() {
        }

        public void mouseClicked(MouseEvent e) {
            if ((e.getModifiers() & 4) == 4) {
                Point p = e.getPoint();
                int row = ((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1.rowAtPoint(p);
                int col = ((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1.columnAtPoint(p);
                ((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1.changeSelection(row, col, false, false);
                ((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.popupmenuitemDetails.setEnabled(true);
                AlarmLogApplicationController.this.showPopupMenu(((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.mypopupmenu, (Component)((Object)((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1), (int)e.getPoint().getX(), (int)e.getPoint().getY());
            }
        }
    }

    private class ExportAction
    implements ActionListener {
        private ExportAction() {
        }

        public void actionPerformed(ActionEvent event) {
            JFileChooser fileChooser;
            int status;
            String defaultPath = System.getProperty("user.home");
            if (defaultPath == null) {
                Log.logError((String)"Error retrieving user home directory");
                defaultPath = "";
            }
            if ((status = (fileChooser = new JFileChooser(defaultPath)).showSaveDialog((Component)((Object)AlarmLogApplicationController.this.alarmview))) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    AlarmLogApplicationController.this.parseFile("output");
                    FileWriter filewriter = new FileWriter(file);
                    for (int i = 0; i < AlarmLogApplicationController.this.lines.size(); ++i) {
                        String writeLine = (String)AlarmLogApplicationController.this.lines.elementAt(i);
                        filewriter.write(writeLine, 0, writeLine.length());
                    }
                    filewriter.close();
                    AlarmLogApplicationController.this.lines = new Vector();
                    AlarmLogApplicationController.this.showMessageDialog("FILE_SAVED", null, "SAVED_TITLE", null, 1, null);
                }
                catch (IOException ioe) {
                    Log.logError((String)"Input/output exception while saving file");
                }
            }
        }
    }

    private class PrintPreviewAction
    implements ActionListener {
        private PrintPreviewAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Printout printout = new Printout((Component)((Object)new PrintableAlarmSortedTable(((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1)), AlarmLogApplicationController.this.getApplication().getLanguageBundle().getString("ALARM_LOG"));
            printout.preview((AbstractController)AlarmLogApplicationController.this.ac, "PRINT_ALARM_LOG", 0);
        }
    }

    private class PageLayoutAction
    implements ActionListener {
        private PageLayoutAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (AlarmLogApplicationController.this.printout == null) {
                AlarmLogApplicationController.this.printout = new Printout((Component)((Object)new PrintableAlarmSortedTable(((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1)), AlarmLogApplicationController.this.getApplication().getLanguageBundle().getString("ALARM_LOG"));
            }
            AlarmLogApplicationController.this.printout.pageLayout();
            AlarmLogApplicationController.this.getApplication().bringToFront();
        }
    }

    private class PrintableAlarmSortedTable
    extends AlarmSortedTable {
        private static final long serialVersionUID = 2614164389320712952L;
        private AlarmSortedTable decoratedTable = null;

        public PrintableAlarmSortedTable(AlarmSortedTable table) {
            this.decoratedTable = table;
        }

        public TableColumnModel getColumnModel() {
            if (this.decoratedTable == null) {
                return super.getColumnModel();
            }
            return this.decoratedTable.getColumnModel();
        }

        public int getRowCount() {
            if (this.decoratedTable == null) {
                return super.getRowCount();
            }
            return this.decoratedTable.getRowCount();
        }

        public Object getValueAt(int row, int column) {
            if (this.decoratedTable == null) {
                return super.getValueAt(row, column);
            }
            Object obj = this.decoratedTable.getValueAt(row, column);
            if (obj == null) {
                return "";
            }
            if (this.decoratedTable.getColumnName(column).equals("EVENT_TIME")) {
                obj = TimeFormatter.setTimeFormat(obj);
            }
            return obj;
        }
    }

    private class PrintAction
    implements ActionListener {
        private PrintAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (AlarmLogApplicationController.this.printout == null) {
                AlarmLogApplicationController.this.printout = new Printout((Component)((Object)new PrintableAlarmSortedTable(((AlarmLogApplicationController)AlarmLogApplicationController.this).alarmview.jTable1)), AlarmLogApplicationController.this.getApplication().getLanguageBundle().getString("ALARM_LOG"));
            }
            AlarmLogApplicationController.this.printout.print();
            AlarmLogApplicationController.this.getApplication().bringToFront();
        }
    }
}

