/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import se.ericsson.cello.support.gui.AboutEmasDialogView;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.security.launcher.ApplicationFileInterface;

public class AboutEmasDialogController
extends AbstractDialogController {
    private AboutEmasDialogView view;
    private OkButtonListener okButtonListener = new OkButtonListener();

    protected void init() {
        Log.traceFlow();
        this.view = (AboutEmasDialogView)this.getView();
        this.view.okButton.addActionListener(this.okButtonListener);
        String prodNo = EmasSystemProperties.getProperty("CUSTOM_APPL_PROD_NO", "Missing Product Number");
        String revision = EmasSystemProperties.getProperty("CUSTOM_APPL_REV", "Missing Revision");
        String releaseVersion = prodNo + " " + revision;
        String releaseLabel = this.getString("EMAS_RELEASEVERSION_LABEL", null);
        String configurationLabel = this.getString("CONFIGURATION_LABEL", null);
        this.view.setReleaseVersion(releaseLabel + " " + releaseVersion);
        this.view.setReleaseVersion("\n\n" + configurationLabel);
        Collection confFiles = this.getApplicationManager().getConfigurationFiles();
        for (ApplicationFileInterface afi : confFiles) {
            String configFile = afi.getName() + " " + afi.getRevision();
            this.view.setReleaseVersion("\n" + configFile);
        }
    }

    public void afterVisible() {
        this.view.okButton.requestFocus();
    }

    protected void stop() {
        Log.traceFlow();
        this.view.okButton.removeActionListener(this.okButtonListener);
    }

    private class OkButtonListener
    implements ActionListener {
        private OkButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            Log.traceFlow();
            AboutEmasDialogController.this.stopDialog();
        }
    }
}

