/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ConcurrentModificationException;
import javax.swing.Timer;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import se.ericsson.cello.support.gui.ConnectionStatus;
import se.ericsson.cello.support.gui.ConnectionSupervisorInterface;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSFacade;

public class ConnectionSupervisorService
extends Thread
implements ActionListener {
    private Object server;
    private ConnectionSupervisorInterface requestor;
    private int interval;
    private long testStart;
    private Timer timeOut;
    private boolean alreadyWarned = false;
    private boolean doneReconnect = false;
    private Boolean continueChecking = Boolean.TRUE;
    private static final int TIME_BETWEEN_NODE_CHECKS = 10000;
    private static URL namerootUrl;
    private static URL emasHtmlUrl;
    private CSFacade csFacade = null;
    ConnectionStatus connectionStatus = ConnectionStatus.UNKNOWN;
    static final long TRANSIENT_ERROR_THESHOLD = 15000L;
    private boolean THIS_IS_A_REAL_NODE = true;

    public ConnectionSupervisorService(Object server, ConnectionSupervisorInterface requestor, int interval, URL namerootUrl, URL emasHtmlUrl) {
        super("Connection Supervisor ");
        Log.trace("ConnectionSupervisorService - Constructor");
        this.server = server;
        this.requestor = requestor;
        this.interval = interval * 4000;
        ConnectionSupervisorService.namerootUrl = namerootUrl;
        ConnectionSupervisorService.emasHtmlUrl = emasHtmlUrl;
        this.csFacade = CSFacade.getInstance();
        if (emasHtmlUrl.getPort() == 8080) {
            this.THIS_IS_A_REAL_NODE = false;
        }
    }

    private synchronized boolean testConnection2() {
        boolean connectionIsOK = true;
        this.connectionStatus = ConnectionStatus.CONNECTION_UP;
        if (this.connectionStatus == ConnectionStatus.CONNECTION_UP) {
            this.testStart = System.currentTimeMillis();
        }
        try {
            if (this.continueChecking == Boolean.FALSE) {
                return true;
            }
            if (this.THIS_IS_A_REAL_NODE && this.csFacade.getnotificationDown()) {
                this.doReconnect();
            } else if (this.doneReconnect) {
                this.connectionStatus = ConnectionStatus.CONNECTION_UP;
                this.timeOut.stop();
                this.requestor.connectionRestored(true);
                this.alreadyWarned = false;
                this.doneReconnect = false;
            } else if (this.server._non_existent()) {
                Log.logNotify("server._non_existent() == true");
                this.doReconnect();
            }
        }
        catch (TRANSIENT e) {
            this.connectionStatus = ConnectionStatus.TRANSIENT_LOSS;
            this.requestor.connectionWarning(this.timeSinceTestStart(), this.connectionStatus);
            try {
                this.wait(10000L);
            }
            catch (Exception waitExcept) {
                System.out.println("Wait exception " + waitExcept);
            }
        }
        catch (OBJECT_NOT_EXIST e) {
            this.doReconnect();
        }
        catch (COMM_FAILURE ee) {
            Log.trace("COMM_FAILURE occured: ");
            this.doReconnect();
        }
        catch (ConcurrentModificationException e) {
            Log.logError("Problem cleaning up: ", e);
        }
        catch (NullPointerException e) {
            connectionIsOK = false;
        }
        catch (Exception e) {
            connectionIsOK = false;
            Log.logError("General problem with connection", e);
        }
        return connectionIsOK;
    }

    protected void timeoutWarning(int timeoutValue) {
        if (this.continueChecking == Boolean.TRUE) {
            Log.trace("timeoutWarning( int timeout )");
            if (!this.alreadyWarned && this.connectionStatus == ConnectionStatus.CONNECTION_UP) {
                this.connectionStatus = ConnectionStatus.UNKNOWN;
            }
            this.alreadyWarned = true;
            this.requestor.connectionWarning(this.timeSinceTestStart(), this.connectionStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        this.timeOut = new Timer(this.interval, this);
        this.timeOut.setRepeats(true);
        boolean connectionIsOK = true;
        while (connectionIsOK && this.continueChecking == Boolean.TRUE) {
            try {
                ConnectionSupervisorService.sleep(10000L);
                this.timeOut.start();
                if (this.continueChecking == Boolean.FALSE) {
                    Log.trace("Breaking connection supervision check in function run!");
                    break;
                }
                connectionIsOK = this.testConnection2();
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                Log.logError("ConnectionSupervisorService interrupted. ", e);
            }
            finally {
                this.timeOut.stop();
            }
        }
        if (!connectionIsOK) {
            Log.logNotify("Connection not ok");
            Log.logNotify("calling requestor.ConnectionError");
            this.requestor.connectionError();
            return;
        }
        Log.trace("Connection ok");
    }

    public void actionPerformed(ActionEvent evt) {
        Log.logNotify("Checking for connection..........");
        if (this.continueChecking == Boolean.FALSE) {
            this.quit();
        } else {
            java.lang.Object source = evt.getSource();
            if (source == this.timeOut) {
                this.timeoutWarning(this.interval);
            } else {
                Log.logWarning("An event from an unknown source!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quit() {
        Log.trace("entering quit of connection supervision service");
        Boolean bl = this.continueChecking;
        synchronized (bl) {
            Log.trace("inside synchronized block of connection supervision service");
            this.continueChecking = Boolean.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopConnectionSupervision() {
        Boolean bl = this.continueChecking;
        synchronized (bl) {
            this.timeOut.stop();
            this.continueChecking = Boolean.FALSE;
            Log.logNotify("Stopped connection supervision service............................................");
        }
    }

    private synchronized boolean doCheckHTTP() {
        try {
            BufferedReader r = null;
            URLConnection conn = emasHtmlUrl.openConnection();
            if (conn != null) {
                r = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String line = null;
                line = r.readLine();
                r.close();
                if (line != null) {
                    Log.logNotify("doCheckHTTP true!");
                    return true;
                }
            }
            Log.logNotify("doCheckHTTP false!");
            return false;
        }
        catch (IOException ee) {
            Log.trace("IOException occured: " + ee);
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean doCheckSocketPart2() {
        return true;
    }

    private String getNamerootIor() throws MalformedURLException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(namerootUrl.openStream()));
        String nsRef = reader.readLine();
        reader.close();
        return nsRef;
    }

    private boolean doCheckORB2() {
        return !this.csFacade.getnotificationDown();
    }

    protected final int timeSinceTestStart() {
        return (int)((System.currentTimeMillis() - this.testStart) / 1000L);
    }

    public ConnectionStatus determineBestConnection() {
        if (this.THIS_IS_A_REAL_NODE && !this.doCheckSocketPart2()) {
            Log.logNotify("No network connection to host!");
            return ConnectionStatus.WAITING_FOR_IP;
        }
        if (!this.doCheckHTTP()) {
            Log.logNotify("Host's HTTP server not reachable");
            return ConnectionStatus.WAITING_FOR_HTTP;
        }
        try {
            String nameroot = this.getNamerootIor();
            if (!this.doCheckORB2()) {
                Log.logNotify("Host's ORB(NameService) is not reachable");
                return ConnectionStatus.WAITING_FOR_ORB;
            }
        }
        catch (Exception e) {
            Log.logError("This should not happen", e);
        }
        return ConnectionStatus.CONNECTION_UP;
    }

    private void doReconnect() {
        Log.logNotify("Attempt Reconnection");
        this.connectionStatus = ConnectionStatus.TRANSIENT_LOSS;
        this.requestor.connectionWarning(this.timeSinceTestStart(), this.connectionStatus);
        this.connectionStatus = ConnectionStatus.WAITING_FOR_HTTP;
        while (!this.doCheckHTTP() && this.continueChecking == Boolean.TRUE) {
            try {
                ConnectionSupervisorService.sleep(8000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.connectionStatus = ConnectionStatus.TRANSIENT_LOSS;
            this.requestor.connectionWarning(this.timeSinceTestStart(), this.connectionStatus);
            Log.logNotify("Host's HTTP server not reachable!");
        }
        Log.logNotify("Host's HTTP server IS REACHABLE!");
        this.connectionStatus = ConnectionStatus.WAITING_FOR_ORB;
        this.requestor.connectionWarning(this.timeSinceTestStart(), this.connectionStatus);
        try {
            ConnectionSupervisorService.sleep(22000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.connectionStatus = ConnectionStatus.WAITING_FOR_ORB;
        this.requestor.connectionWarning(this.timeSinceTestStart(), this.connectionStatus);
        while (!this.doCheckORB2() && this.continueChecking == Boolean.TRUE) {
            try {
                ConnectionSupervisorService.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.connectionStatus = ConnectionStatus.TRANSIENT_LOSS;
            this.requestor.connectionWarning(this.timeSinceTestStart(), this.connectionStatus);
        }
        Log.logNotify("Host's ORB(NameService) IS REACHABLE!");
        this.doneReconnect = true;
        this.connectionStatus = ConnectionStatus.CONNECTION_UP;
    }
}

