/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import se.ericsson.cello.support.gui.ApplicationTreeModel;
import se.ericsson.cello.support.gui.ElementType;
import se.ericsson.cello.support.gui.MenuModel;
import se.ericsson.cello.support.gui.TaskMenuEntry;
import se.ericsson.cello.support.gui.gengui.GenMenu;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class MenuTree
extends GenMenu
implements Observer {
    private static final long serialVersionUID = 4920559394978615262L;
    private static final String ERROR_NO_MENU = "ERROR_NO_MENU";
    private static final String INCORRECT_MENU_ENTRY = "INCORRECT_MENU_ENTRY";
    private MenuModel menuModel;
    private ApplicationTreeModel treeModel;
    private ActionListener myActionListener;
    private static GenMenu theMenu;

    public MenuTree(MenuModel model, ActionListener actionListener) {
        Log.trace("Constructor MenuTree");
        this.menuModel = model;
        this.myActionListener = actionListener;
        theMenu = this;
        this.menuModel.addObserver(this);
        this.createMenuTree();
    }

    private void createMenuTree() {
        theMenu.removeAll();
        this.treeModel = new ApplicationTreeModel(theMenu);
        TaskMenuEntry[] menu = this.menuModel.getMenu();
        if (menu == null) {
            Log.trace("createMenuTree() no menu");
            theMenu.setEnabled(false);
        } else {
            theMenu.setEnabled(true);
            int nrEntries = menu.length;
            for (int idx = 0; idx < nrEntries; ++idx) {
                String tag = menu[idx].tag;
                String translations = menu[idx].translations;
                short indentlevel = menu[idx].indentLevel;
                ElementType type = menu[idx].type;
                boolean initialVisible = menu[idx].initialVisible;
                String link = menu[idx].link;
                Log.trace("translate(): processing nr." + idx + ": tag=" + menu[idx].tag + ", translations=" + menu[idx].translations + ", indentlevel=" + menu[idx].indentLevel + ", type=" + menu[idx].type.toInteger() + ", initialVisible=" + menu[idx].initialVisible + ", link=" + menu[idx].link);
                if (!initialVisible) continue;
                if (type.toInteger() == ElementType.FOLDER.toInteger()) {
                    this.treeModel.addFolder(translations, tag, indentlevel);
                    continue;
                }
                this.treeModel.addLink(translations, tag, link, indentlevel, this.myActionListener);
            }
        }
    }

    public void update(Observable obs, Object atg) {
        Log.trace("destroy()");
        this.createMenuTree();
    }

    public GenMenu[] getMenu() {
        Log.trace("getMenu()");
        GenMenu[] currentMenu = null;
        Component[] theMenuComponents = theMenu.getMenuComponents();
        currentMenu = new GenMenu[theMenuComponents.length];
        for (int counter = 0; counter < theMenuComponents.length; ++counter) {
            currentMenu[counter] = (GenMenu)theMenuComponents[counter];
        }
        return currentMenu;
    }

    void destroy() {
        Log.trace("destroy()");
        this.menuModel.deleteObserver(this);
        if (this.treeModel != null) {
            this.treeModel.removeAllItems();
            this.treeModel = null;
        }
        this.myActionListener = null;
        theMenu = null;
    }
}

