/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Object value_return;
    private ThreadVar threadVariant;

    protected synchronized Object getValue() {
        return this.value_return;
    }

    private synchronized void setValues(Object a) {
        this.value_return = a;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread th = this.threadVariant.get();
        if (th != null) {
            th.interrupt();
        }
        this.threadVariant.clear();
    }

    public Object get() {
        Thread th;
        while ((th = this.threadVariant.get()) != null) {
            try {
                th.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorker() {
        final Runnable doFinish = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable Construct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.setValues(SwingWorker.this.construct());
                }
                finally {
                    SwingWorker.this.threadVariant.clear();
                }
                SwingUtilities.invokeLater(doFinish);
            }
        };
        Thread th = new Thread(Construct);
        this.threadVariant = new ThreadVar(th);
    }

    public void start() {
        Thread th = this.threadVariant.get();
        if (th != null) {
            th.start();
        }
    }

    private static class ThreadVar {
        private Thread threads;

        ThreadVar(Thread t) {
            this.threads = t;
        }

        synchronized Thread get() {
            return this.threads;
        }

        synchronized void clear() {
            this.threads = null;
        }
    }
}

