/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.gengui.TranslatableComboBox;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;

public class GenTranslatableStringComboBox
extends LabelledField
implements LocaleChangeListener,
ActionListener {
    private static final long serialVersionUID = 327918434403933838L;
    private TranslatableComboBox boxes = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private int widthComboBox = 0;
    private String myBundle = null;
    private boolean doActions = false;

    public GenTranslatableStringComboBox(String translations, String tag, String[] buttonTags, boolean sorting) {
        super(translations, tag);
        this.myBundle = translations;
        this.boxes = new TranslatableComboBox(buttonTags, sorting);
        this.boxes.addActionListener(this);
        this.add(this.boxes);
    }

    public GenTranslatableStringComboBox(String translations, String tag, String[] buttonTags) {
        this(translations, tag, buttonTags, true);
    }

    public GenTranslatableStringComboBox(String tag, String[] buttonTags, boolean sorting) {
        super(tag);
        Log.traceFlow();
        this.boxes = new TranslatableComboBox(buttonTags, sorting);
        this.boxes.addActionListener(this);
        this.add(this.boxes);
    }

    public GenTranslatableStringComboBox(String tag, String[] buttonTags) {
        this(tag, buttonTags, true);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
        this.doActions = true;
    }

    public void setWidth(int width) {
        Dimension myDim = this.boxes.getPreferredSize();
        myDim.width = width;
        this.widthComboBox = width;
        this.boxes.setPreferredSize(myDim);
    }

    public void setValue(String boxTag) throws SyntaxException {
        Log.trace("setValue()");
        boolean buttonNotDefined = true;
        for (int i = 0; i < this.boxes.getTranslatableItemCount(); ++i) {
            if (!this.boxes.getTranslatableItemAt(i).equals(boxTag)) continue;
            this.doActions = false;
            this.boxes.setSelectedIndex(i);
            this.doActions = true;
            buttonNotDefined = false;
        }
        if (buttonNotDefined) {
            throw new SyntaxException();
        }
    }

    public String getValue() {
        Log.trace("getValue()");
        return (String)this.boxes.getTranslatableItemAt(this.boxes.getSelectedIndex());
    }

    public int getSelectedIndex() {
        return this.boxes.getUnsortedIndex();
    }

    public void removeAllItems() {
        this.doActions = false;
        if (this.boxes.getItemCount() > 0) {
            this.boxes.removeAllItems();
        }
        this.layoutComponent();
        this.doActions = true;
    }

    public void addItems(String[] items) {
        this.doActions = false;
        this.boxes.addTranslatableItems(items);
        if (this.boxes.getSelectedIndex() == -1) {
            this.boxes.setSelectedIndex(0);
        }
        this.layoutComponent();
        this.doActions = true;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.boxes;
    }

    public void updateLocale(Locale locale) {
        this.doActions = false;
        Log.trace("translate()");
        super.updateLocale(locale);
        this.boxes.setBundle(GuilibResourceBundle.getBundle(this.myBundle, locale, this.getClass().getClassLoader()));
        this.layoutComponent();
        this.doActions = true;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.actionListener != null && this.doActions) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
        }
    }
}

