/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.io.PrintStream;

public class TraceHelper {
    private static int TraceType = 0;
    static final int MIN_TRACE_TYPE = 0;
    static final int MAX_TRACE_TYPE = 6;
    static final int APP_TRACE_OFF = 0;
    static final int APP_TRACE_ALL = 1;
    static final int APP_TRACE_OBJECT = 2;
    static final int APP_TRACE_EXCEPTION = 3;
    static final int APP_TRACE_METHOD = 4;
    static final int APP_TRACE_IDLMETHOD = 5;
    static final int APP_TRACE_VAR = 6;
    static final String[] TRACE_LEVEL_KEYS = new String[]{"GSL_APP_TRACE_OFF", "GSL_APP_TRACE_ALL", "GSL_APP_TRACE_OBJECT", "GSL_APP_TRACE_EXCEPTION", "GSL_APP_TRACE_METHOD", "GSL_APP_TRACE_IDLMETHOD", "GSL_APP_TRACE_VAR"};
    static final int[] TRACE_LEVEL_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static PrintStream logger;

    private TraceHelper() {
    }

    public static void traceEnter(Object object, String meth) {
        if (TraceType == 1 || TraceType == 4) {
            String s = object.getClass().getName() + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread();
            TraceHelper.trace("Trace Method Enter: ", s);
        }
    }

    public static void traceEnter(Object object, String meth, String args) {
        if (TraceType == 1 || TraceType == 4) {
            String s = object.getClass().getName() + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace Method Enter: ", s);
        }
    }

    public static void traceEnter(String classname, String meth) {
        if (TraceType == 1 || TraceType == 4) {
            String s = classname + ";" + meth + ";" + Thread.currentThread();
            TraceHelper.trace("Trace Method Enter: ", s);
        }
    }

    public static void traceEnter(String classname, String meth, String args) {
        if (TraceType == 1 || TraceType == 4) {
            String s = classname + ";" + meth + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace Method Enter: ", s);
        }
    }

    public static void traceExit(Object object, String meth) {
        if (TraceType == 1 || TraceType == 4) {
            String s = object.getClass().getName() + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread();
            TraceHelper.trace("Trace Method Exit: ", s);
        }
    }

    public static void traceExit(Object object, String meth, String args) {
        if (TraceType == 1 || TraceType == 4) {
            String s = object.getClass().getName() + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace Method Exit: ", s);
        }
    }

    public static void traceExit(String classname, String meth) {
        if (TraceType == 1 || TraceType == 4) {
            String s = classname + ";" + meth + ";" + Thread.currentThread();
            TraceHelper.trace("Trace Method Exit: ", s);
        }
    }

    public static void traceExit(String classname, String meth, String args) {
        if (TraceType == 1 || TraceType == 4) {
            String s = classname + ";" + meth + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace Method Exit: ", s);
        }
    }

    public static void traceEnterIDL(Object object, String iface, String meth) {
        if (TraceType == 1 || TraceType == 5) {
            String s = object.getClass().getName() + ";" + iface + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread();
            TraceHelper.trace("Trace IDL Method Enter: ", s);
        }
    }

    public static void traceEnterIDL(Object object, String iface, String meth, String args) {
        if (TraceType == 1 || TraceType == 5) {
            String s = object.getClass().getName() + ";" + iface + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace IDL Method Enter: ", s);
        }
    }

    public static void traceEnterIDL(String classname, String iface, String meth) {
        if (TraceType == 1 || TraceType == 5) {
            String s = classname + ";" + iface + ";" + meth + ";" + Thread.currentThread();
            TraceHelper.trace("Trace IDL Method Enter: ", s);
        }
    }

    public static void traceEnterIDL(String classname, String iface, String meth, String args) {
        if (TraceType == 1 || TraceType == 5) {
            String s = classname + ";" + iface + ";" + meth + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace IDL Method Enter: ", s);
        }
    }

    public static void traceExitIDL(Object object, String iface, String meth) {
        if (TraceType == 1 || TraceType == 5) {
            String s = object.getClass().getName() + ";" + iface + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread();
            TraceHelper.trace("Trace IDL Method Exit: ", s);
        }
    }

    public static void traceExitIDL(Object object, String iface, String meth, String args) {
        if (TraceType == 1 || TraceType == 5) {
            String s = object.getClass().getName() + ";" + iface + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace IDL Method Exit: ", s);
        }
    }

    public static void traceExitIDL(String classname, String iface, String meth) {
        if (TraceType == 1 || TraceType == 5) {
            String s = classname + ";" + iface + ";" + meth + ";" + Thread.currentThread();
            TraceHelper.trace("Trace IDL Method Exit: ", s);
        }
    }

    public static void traceExitIDL(String classname, String iface, String meth, String args) {
        if (TraceType == 1 || TraceType == 5) {
            String s = classname + ";" + iface + ";" + meth + ";" + Thread.currentThread() + ";" + args;
            TraceHelper.trace("Trace IDL Method Exit: ", s);
        }
    }

    public static void traceGeneral(Object object, String descr) {
        if (TraceType == 1) {
            String s = object.getClass().getName() + object.toString() + ";" + Thread.currentThread() + ";" + descr;
            TraceHelper.trace("Trace: ", s);
        }
    }

    public static void traceGeneral(String classname, String descr) {
        if (TraceType == 1) {
            String s = classname + ";" + Thread.currentThread() + ";" + descr;
            TraceHelper.trace("Trace: ", s);
        }
    }

    public static void traceException(Object object, String meth, String descr) {
        if (TraceType == 1 || TraceType == 3) {
            String s = object.getClass().getName() + ";" + meth + ";" + object.toString() + ";" + Thread.currentThread() + ";" + descr;
            TraceHelper.trace("Trace Exception: ", s);
        }
    }

    public static void traceException(String classname, String meth, String descr) {
        if (TraceType == 1 || TraceType == 3) {
            String s = classname + ";" + meth + ";" + Thread.currentThread() + ";" + descr;
            TraceHelper.trace("Trace Exception: ", s);
        }
    }

    public static void traceObject(Object object, String createdobject) {
        if (TraceType == 1 || TraceType == 2) {
            String s = object.getClass().getName() + ";" + createdobject + ";" + object.toString() + ";" + Thread.currentThread() + "; Created";
            TraceHelper.trace("Trace Object Creation: ", s);
        }
    }

    public static void traceObject(String classname, String newObject) {
        if (TraceType == 1 || TraceType == 2) {
            String s = classname + "; Created " + newObject + ";" + Thread.currentThread();
            TraceHelper.trace("Trace Object Creation: ", s);
        }
    }

    public static void traceVarChanged(Object o, String meth, String varName, String varValue) {
        if (TraceType == 1 || TraceType == 6) {
            String b = o.toString();
            String packageString = "com.ericsson.nms.umts";
            int packageLength = packageString.length();
            if (b.startsWith(packageString)) {
                b = b.substring(packageLength);
            }
            String s = b + ";" + meth + ";" + Thread.currentThread() + ";" + varName + ";" + varValue;
            TraceHelper.trace("Trace Var Changed: ", s);
        }
    }

    public static void traceVarChanged(String classname, String meth, String varName, String varValue) {
        if (TraceType == 1 || TraceType == 6) {
            String s = classname + ";" + meth + ";" + Thread.currentThread() + ";" + varName + ";" + varValue;
            TraceHelper.trace("Trace Var Changed: ", s);
        }
    }

    static final void setTraceType(int tracetype) {
        TraceHelper.assertion(tracetype >= 0 && tracetype <= 6, "Illegal trace value: " + tracetype);
        TraceType = tracetype;
    }

    static final int getTraceType() {
        return TraceType;
    }

    private static void assertion(boolean assertion, String msg) {
        if (!assertion) {
            throw new RuntimeException("Assertion failed: " + msg);
        }
    }

    private static final void trace(String tracetype, String msg) {
        StringBuffer buf = new StringBuffer();
        buf.append(tracetype).append(" ");
        if (msg != null) {
            buf.append(msg);
        }
        TraceHelper.println(buf.toString());
    }

    private static void println(String str) {
        TraceHelper.getLogger().println(str);
        TraceHelper.getLogger().println();
    }

    private static final PrintStream getLogger() {
        if (logger == null) {
            logger = System.out;
        }
        return logger;
    }
}

