/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.table;

import java.awt.Toolkit;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import se.ericsson.cello.support.gui.guilib.table.FaultyInputEvent;
import se.ericsson.cello.support.gui.guilib.table.FaultyInputListener;
import se.ericsson.cello.support.gui.guilib.table.SmartTableCell;

public class SmartTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 710421411675150611L;
    private Vector columnNames = new Vector();
    private Vector rows = new Vector();
    private Vector faultyInputListeners = new Vector();
    private Vector tableChangedListeners = new Vector();
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    public SmartTableModel(String[] columnNames) {
        this.setColumnNames(columnNames);
    }

    private void setColumnNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.columnNames.add(names[i]);
        }
    }

    public void addFaultyInputListener(FaultyInputListener listener) {
        this.faultyInputListeners.addElement(listener);
    }

    public void removeFaultyInputListener(FaultyInputListener listener) {
        this.faultyInputListeners.removeElement(listener);
    }

    public void addRow(SmartTableCell[] tableCells) {
        Vector<SmartTableCell> vector = new Vector<SmartTableCell>(tableCells.length);
        for (int i = 0; i < tableCells.length; ++i) {
            vector.addElement(tableCells[i]);
        }
        this.addRow(vector);
    }

    public void addRow(Vector tableCells) {
        if (tableCells.size() < this.columnNames.size()) {
            throw new RuntimeException("Vector size smaller than number of columns");
        }
        Enumeration enume = tableCells.elements();
        while (enume.hasMoreElements()) {
            if (enume.nextElement() instanceof SmartTableCell) continue;
            throw new RuntimeException("Only instances of SmartTableCell can be added");
        }
        this.rows.addElement(tableCells);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void removeRow(Vector tableCells) {
        int index = this.rows.indexOf(tableCells);
        if (index != -1) {
            this.removeRow(index);
        }
    }

    public void removeRow(int rowNumber) {
        this.rows.remove(rowNumber);
        this.fireTableRowsDeleted(rowNumber, rowNumber);
    }

    public void removeRows(int[] rowNumbers) {
        Arrays.sort(rowNumbers);
        for (int i = rowNumbers.length - 1; i >= 0; --i) {
            this.rows.remove(rowNumbers[i]);
        }
        this.fireTableRowsDeleted(0, 0);
    }

    public void removeAllRows() {
        int nrOfRows = this.getRowCount() - 1;
        this.rows.removeAllElements();
        this.fireTableRowsDeleted(0, nrOfRows);
    }

    public Object getValueAt(int row, int col) {
        Vector cellValues = (Vector)this.rows.elementAt(row);
        SmartTableCell tableCell = (SmartTableCell)cellValues.elementAt(col);
        return tableCell.getValue();
    }

    public SmartTableCell getCellAt(int row, int col) {
        Vector cellValues = (Vector)this.rows.elementAt(row);
        return (SmartTableCell)cellValues.elementAt(col);
    }

    public void setValueAt(Object value, int row, int col) {
        if (value instanceof String) {
            String tempValue = (String)value;
            value = tempValue.trim();
        }
        Vector cellValues = (Vector)this.rows.elementAt(row);
        SmartTableCell tableCell = (SmartTableCell)cellValues.elementAt(col);
        Object oldValue = tableCell.getCellValue();
        if (!tableCell.setValue(value)) {
            this.toolkit.beep();
            Enumeration enume = this.faultyInputListeners.elements();
            while (enume.hasMoreElements()) {
                ((FaultyInputListener)enume.nextElement()).faultyInput(new FaultyInputEvent(value, row, col));
            }
            return;
        }
        Object newValue = tableCell.getCellValue();
        if (oldValue == null) {
            if (newValue != null) {
                this.fireTableCellUpdated(row, col);
            }
        } else if (!oldValue.equals(newValue)) {
            this.fireTableCellUpdated(row, col);
        }
    }

    public boolean isCellEditable(int row, int col) {
        Vector cellValues = (Vector)this.rows.elementAt(row);
        SmartTableCell tableCell = (SmartTableCell)cellValues.elementAt(col);
        return tableCell.isEditable();
    }

    public void setCellEditable(boolean editable, int row, int col) {
        Vector cellValues = (Vector)this.rows.elementAt(row);
        SmartTableCell tableCell = (SmartTableCell)cellValues.elementAt(col);
        tableCell.setEditable(editable);
    }

    public String getColumnName(int col) {
        return (String)this.columnNames.elementAt(col);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }
}

