/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.StreamHandler;
import se.ericsson.cello.support.logging.XMLFormatter;

public class FileHandler
extends StreamHandler {
    private MeteredStream meterstr;
    private int limitation;
    private int counts;
    private String patterns;
    private String lockFileNames;
    private long lockCookies;
    private File[] file;
    private static final int MAX_VALUE_LOCKS = 100;
    private static HashMap locks = new HashMap();

    private void open(File fname) throws IOException {
        FileOutputStream fout = new FileOutputStream(fname);
        BufferedOutputStream boutS = new BufferedOutputStream(fout);
        this.meterstr = new MeteredStream(fout);
        this.setOutputStream(this.meterstr);
    }

    private void configuration() {
        LogManager logManager = LogManager.getLogManager();
        String className = FileHandler.class.getName();
        this.patterns = logManager.getStringProperty(className + ".pattern", "%t/java.log");
        this.limitation = logManager.getIntProperty(className + ".limit", 0);
        this.counts = logManager.getIntProperty(className + ".count", 1);
        this.setLevel(logManager.getLevelProperty(className + ".level", Level.ALL));
        this.setFilter(logManager.getFilterProperty(className + ".filter", null));
        this.setFormatter(logManager.getFormatterProperty(className + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(logManager.getStringProperty(className + ".encoding", null));
        }
        catch (Exception excep) {
            try {
                this.setEncoding(null);
            }
            catch (Exception excep2) {
                // empty catch block
            }
        }
    }

    public FileHandler() throws IOException, SecurityException {
        this.checkAccessRight();
        this.configuration();
        this.openFile();
    }

    public FileHandler(String patterns) throws IOException, SecurityException {
        this.checkAccessRight();
        this.configuration();
        this.patterns = patterns;
        this.limitation = 0;
        this.counts = 1;
        this.openFile();
    }

    public FileHandler(String patterns, int limit, int count) throws IOException, SecurityException {
        this.checkAccessRight();
        this.configuration();
        this.patterns = patterns;
        this.limitation = limit;
        this.counts = count;
        this.openFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openFile() throws IOException {
        LogManager logManager = LogManager.getLogManager();
        logManager.checkAccess();
        if (this.counts < 1) {
            throw new IllegalArgumentException("file count = " + this.counts);
        }
        if (this.limitation < 0) {
            this.limitation = 0;
        }
        int uniqu = -1;
        while (true) {
            if (++uniqu > 100) {
                throw new IOException("Couldn't get lock for " + this.patterns);
            }
            this.lockFileNames = this.generate(this.patterns, 0, uniqu).toString() + ".lck";
            HashMap hashMap = locks;
            synchronized (hashMap) {
                if (locks.get(this.lockFileNames) == null) break;
            }
        }
        {
            locks.put(this.lockFileNames, this.lockFileNames);
        }
        this.file = new File[this.counts];
        for (int i = 0; i < this.counts; ++i) {
            this.file[i] = this.generate(this.patterns, i, uniqu);
        }
        this.rotateFile();
        Exception excep = this.getException();
        if (excep == null) {
            return;
        }
        if (excep instanceof IOException) {
            throw (IOException)excep;
        }
        if (excep instanceof SecurityException) {
            throw (SecurityException)excep;
        }
        throw new IOException("Exception: " + excep);
    }

    private File generate(String pattern, int generation, int unique) {
        File fi = null;
        String words = "";
        int in = 0;
        boolean sag = false;
        boolean sau = false;
        while (in < pattern.length()) {
            char chs = pattern.charAt(in);
            char chs2 = '\u0000';
            if (++in < pattern.length()) {
                chs2 = Character.toLowerCase(pattern.charAt(in));
            }
            if (chs == '/') {
                fi = fi == null ? new File(words) : new File(fi, words);
                words = "";
                continue;
            }
            if (chs == '%') {
                if (chs2 == 't') {
                    String tmpDirectory = System.getProperty("java.io.tmpdir");
                    if (tmpDirectory == null) {
                        tmpDirectory = System.getProperty("user.home");
                    }
                    fi = new File(tmpDirectory);
                    ++in;
                    words = "";
                    continue;
                }
                if (chs2 == 'h') {
                    fi = new File(System.getProperty("user.home"));
                    ++in;
                    words = "";
                    continue;
                }
                if (chs2 == 'g') {
                    words = words + generation;
                    sag = true;
                    ++in;
                    continue;
                }
                if (chs2 == 'u') {
                    words = words + unique;
                    sau = true;
                    ++in;
                    continue;
                }
                if (chs2 == '%') {
                    words = words + "%";
                    ++in;
                    continue;
                }
            }
            words = words + chs;
        }
        if (this.counts > 1 && !sag) {
            words = words + "." + generation;
        }
        if (unique > 0 && !sau) {
            words = words + "." + unique;
        }
        if (words.length() > 0) {
            fi = fi == null ? new File(words) : new File(fi, words);
        }
        return fi;
    }

    private synchronized void rotateFile() {
        Level logLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        for (int i = this.counts - 2; i >= 0; --i) {
            File file1 = this.file[i];
            File file2 = this.file[i + 1];
            if (!file1.exists()) continue;
            if (file2.exists()) {
                file2.delete();
            }
            file1.renameTo(file2);
        }
        try {
            this.open(this.file[0]);
        }
        catch (IOException ioException) {
            this.setException(ioException);
        }
        this.setLevel(logLevel);
    }

    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        super.publish(logRecord);
        this.flush();
        if (this.limitation > 0 && this.meterstr.writtenVal >= this.limitation) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    FileHandler.this.rotateFile();
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SecurityException {
        super.close();
        HashMap hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileNames);
        }
        this.lockCookies = 0L;
    }

    private native long lockFile(String var1);

    private native void unlockFile(long var1);

    private class MeteredStream
    extends OutputStream {
        OutputStream outputStream;
        int writtenVal = 0;

        MeteredStream(OutputStream out) {
            this.outputStream = out;
        }

        public void write(int c) throws IOException {
            this.outputStream.write(c);
            ++this.writtenVal;
        }

        public void write(byte[] buffer) throws IOException {
            this.outputStream.write(buffer);
            this.writtenVal += buffer.length;
        }

        public void write(byte[] buffer, int off, int lens) throws IOException {
            this.outputStream.write(buffer, off, lens);
            this.writtenVal += lens;
        }

        public void flush() throws IOException {
            this.outputStream.flush();
        }

        public void close() throws IOException {
            this.outputStream.close();
        }
    }
}

