/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.logging.Filter;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.Logger;
import se.ericsson.cello.support.logging.LoggingPermission;
import sun.security.action.GetPropertyAction;

public class LogManager {
    private static LogManager managerLog;
    private Vector handl = new Vector();
    private Properties prop = new LogProperties();
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(LogManager.class);
    private LogNode rootLog = new LogNode();
    private Permission ourPermission = new LoggingPermission("control", null);

    static void initialize() {
        String cname = null;
        try {
            GetPropertyAction a = new GetPropertyAction("se.ericsson.cello.support.logging.manager");
            cname = AccessController.doPrivileged(a);
            if (cname != null) {
                Class<?> claz = Class.forName(cname);
                managerLog = (LogManager)claz.newInstance();
            }
        }
        catch (Exception ex) {
            System.err.println("Could not load Logmanager \"" + cname + "\"");
            ex.printStackTrace();
        }
        if (managerLog == null) {
            managerLog = new LogManager();
        }
        try {
            managerLog.readConfiguration();
        }
        catch (Exception ex) {
            System.err.println("Can't read logging configuration:");
            System.err.println("" + ex);
        }
    }

    protected LogManager() {
    }

    public static LogManager getLogManager() {
        return managerLog;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkAccess();
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkAccess();
        this.changeSupport.removePropertyChangeListener(l);
    }

    public synchronized boolean addLogger(Logger l) {
        l.getName().length();
        LogNode node = this.findNode(l.getName(), true);
        if (node.getLogger() == null) {
            node.setLogger(l);
            return true;
        }
        return false;
    }

    private LogNode findNode(String named, boolean create) {
        if (named == null || named.equals("")) {
            return this.rootLog;
        }
        LogNode rootnode = this.rootLog;
        while (named.length() > 0) {
            LogNode children;
            String head;
            int index = named.indexOf(".");
            if (index > 0) {
                head = named.substring(0, index);
                named = named.substring(index + 1);
            } else {
                head = named;
                named = "";
            }
            if (rootnode.children == null) {
                if (!create) {
                    return null;
                }
                rootnode.children = new HashMap();
            }
            if ((children = (LogNode)rootnode.children.get(head)) == null) {
                if (!create) {
                    return null;
                }
                children = new LogNode();
                rootnode.children.put(head, children);
                children.level = rootnode.level;
            }
            rootnode = children;
        }
        return rootnode;
    }

    public Logger getLogger(String named) {
        LogNode nodes = this.findNode(named, false);
        if (nodes == null) {
            return null;
        }
        return nodes.getLogger();
    }

    public synchronized void setLevel(String name, Level level) throws SecurityException {
        if (level == null || name == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
        LogNode node = this.findNode(name, true);
        node.walkAndSet(level);
    }

    public synchronized Level getLevel(String named) {
        LogNode noderoot = this.rootLog;
        Level level = this.rootLog.level;
        while (noderoot != null && named.length() > 0) {
            String head;
            int index = named.indexOf(".");
            if (index > 0) {
                head = named.substring(0, index);
                named = named.substring(index + 1);
            } else {
                head = named;
                named = "";
            }
            if (noderoot.children == null || (noderoot = (LogNode)noderoot.children.get(head)) == null) break;
            level = noderoot.level;
        }
        return level;
    }

    public synchronized void addGlobalHandler(Handler handler) throws SecurityException {
        handler.getClass();
        this.checkAccess();
        this.handl.add(handler);
    }

    public synchronized void removeGlobalHandler(Handler handler) throws SecurityException {
        this.checkAccess();
        this.handl.remove(handler);
    }

    public synchronized void removeAllGlobalHandlers() throws SecurityException {
        this.checkAccess();
        this.handl.clear();
    }

    public synchronized Handler[] getGlobalHandlers() throws SecurityException {
        this.checkAccess();
        Object[] result = new Handler[this.handl.size()];
        this.handl.copyInto(result);
        return result;
    }

    public synchronized Enumeration getLoggerNames() {
        return new LogEnumerator(this.rootLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException, SecurityException {
        InputStream inPutStream;
        String fname;
        this.checkAccess();
        this.reset();
        String cname = EmasSystemProperties.getProperty("se.ericsson.cello.support.logging.config.class");
        if (cname != null) {
            try {
                Class<?> claz = Class.forName(cname);
                claz.newInstance();
                return;
            }
            catch (Exception ex) {
                System.err.println("Logging configuration class \"" + cname + "\" failed");
                System.err.println("" + ex);
            }
        }
        if ((fname = EmasSystemProperties.getProperty("se.ericsson.cello.support.logging.config.file")) != null) {
            inPutStream = new FileInputStream(fname);
        } else {
            fname = "/se/ericsson/cello/support/logging/resources/logging.properties";
            inPutStream = this.getClass().getResourceAsStream(fname);
        }
        BufferedInputStream bins = new BufferedInputStream(inPutStream);
        try {
            this.readConfiguration(bins);
        }
        finally {
            if (inPutStream != null) {
                inPutStream.close();
            }
        }
    }

    private void reset() {
        this.prop = new LogProperties();
        while (this.handl.size() > 0) {
            Handler hand = (Handler)this.handl.elementAt(0);
            this.removeGlobalHandler(hand);
            try {
                hand.close();
            }
            catch (Exception exception) {}
        }
    }

    private String[] parseClassNames(String propertyName) {
        String hands = this.prop.getProperty(propertyName, "");
        hands = hands.trim();
        int index = 0;
        Vector<String> result = new Vector<String>();
        while (index < hands.length()) {
            int ends;
            for (ends = index; ends < hands.length() && !Character.isWhitespace(hands.charAt(ends)) && hands.charAt(ends) != ','; ++ends) {
            }
            String words = hands.substring(index, ends);
            index = ends + 1;
            if ((words = words.trim()).length() == 0) continue;
            result.add(words);
        }
        return result.toArray(new String[result.size()]);
    }

    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        Class<?> claz;
        String words;
        int i;
        this.checkAccess();
        this.reset();
        this.prop.load(ins);
        String[] parsenames = this.parseClassNames("handlers");
        for (i = 0; i < parsenames.length; ++i) {
            words = parsenames[i];
            try {
                claz = Class.forName(words);
                Handler h = (Handler)claz.newInstance();
                this.addGlobalHandler(h);
                try {
                    String levs = this.prop.getProperty(words + ".level");
                    if (levs == null) continue;
                    h.setLevel(Level.parse(levs));
                }
                catch (Exception ex) {}
                continue;
            }
            catch (Exception ex) {
                System.err.println("Can't load log handler \"" + words + "\"");
                System.err.println("" + ex);
                ex.printStackTrace();
            }
        }
        parsenames = this.parseClassNames("config");
        for (i = 0; i < parsenames.length; ++i) {
            words = parsenames[i];
            try {
                claz = Class.forName(words);
                claz.newInstance();
                continue;
            }
            catch (Exception ex) {
                System.err.println("Can't load config class \"" + words + "\"");
                System.err.println("" + ex);
            }
        }
        this.changeSupport.firePropertyChange(null, null, null);
    }

    public String getProperty(String name) {
        return this.prop.getProperty(name);
    }

    String getStringProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value.trim();
    }

    int getIntProperty(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    Level getLevelProperty(String named, Level defaultValue) {
        String value = this.getProperty(named);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Level.parse(value.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    Filter getFilterProperty(String named, Filter defaultValue) {
        String value = this.getProperty(named);
        try {
            if (value != null) {
                Class<?> claz = Class.forName(value);
                return (Filter)claz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    Formatter getFormatterProperty(String named, Formatter defaultValue) {
        String value = this.getProperty(named);
        try {
            if (value != null) {
                Class<?> claz = Class.forName(value);
                return (Formatter)claz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    public void publish(LogRecord recorder) {
        for (int j = 0; j < this.handl.size(); ++j) {
            Handler hand = (Handler)this.handl.elementAt(j);
            hand.publish(recorder);
        }
    }

    public void flush() {
        for (int j = 0; j < this.handl.size(); ++j) {
            Handler hand = (Handler)this.handl.elementAt(j);
            hand.flush();
        }
    }

    public static void dispose() {
        if (managerLog != null) {
            managerLog.cleanup();
            managerLog = null;
        }
    }

    public void cleanup() {
        this.flush();
        this.handl.clear();
        this.handl = null;
        this.prop = null;
        this.rootLog.dispose();
        this.rootLog = null;
    }

    public void checkAccess() throws SecurityException {
        SecurityManager smanage = System.getSecurityManager();
        if (smanage == null) {
            return;
        }
        smanage.checkPermission(this.ourPermission);
    }

    static {
        if (System.getSecurityManager() == null) {
            LogManager.initialize();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LogManager.initialize();
                    return null;
                }
            });
        }
    }

    private class LogProperties
    extends Properties {
        private static final long serialVersionUID = -8689417385463056463L;

        private LogProperties() {
        }

        public Object put(Object keyObject, Object valueObject) {
            Level lev;
            Object reSult = super.put(keyObject, valueObject);
            String key = (String)keyObject;
            if (!key.endsWith(".level")) {
                return reSult;
            }
            int index = key.length() - 6;
            String named = key.substring(0, index);
            String val = (String)valueObject;
            try {
                lev = Level.parse(val);
            }
            catch (Exception ex) {
                System.err.println("Bad level value for property: " + key);
                return reSult;
            }
            LogManager.this.setLevel(named, lev);
            return reSult;
        }
    }

    private static class LogEnumerator
    implements Enumeration {
        private Vector names = new Vector();
        private int index = 0;

        private LogEnumerator(LogNode root) {
            this.addTree(root, "");
        }

        private void addTree(LogNode node, String name) {
            if (node.getLogger() != null) {
                this.names.addElement(name);
            }
            if (node.children == null) {
                return;
            }
            for (String key : node.children.keySet()) {
                LogNode child = (LogNode)node.children.get(key);
                String cname = name.length() == 0 ? key : name + "." + key;
                this.addTree(child, cname);
            }
        }

        public boolean hasMoreElements() {
            return this.index < this.names.size();
        }

        public Object nextElement() {
            if (this.index >= this.names.size()) {
                throw new NoSuchElementException();
            }
            Object result = this.names.elementAt(this.index);
            ++this.index;
            return result;
        }
    }

    private static class LogNode {
        HashMap children;
        WeakReference loggerRef;
        Level level = Level.INFO;

        private LogNode() {
        }

        Logger getLogger() {
            if (this.loggerRef == null) {
                return null;
            }
            return (Logger)this.loggerRef.get();
        }

        void setLogger(Logger l) {
            this.loggerRef = new WeakReference<Logger>(l);
        }

        void walkAndSet(Level level) {
            this.level = level;
            Logger l = this.getLogger();
            if (l != null) {
                l.setLevel(level);
            }
            if (this.children == null) {
                return;
            }
            for (LogNode node : this.children.values()) {
                node.walkAndSet(level);
            }
        }

        public void dispose() {
            for (LogNode node : this.children.values()) {
                node.clean();
            }
            this.clean();
        }

        public void clean() {
            if (this.children != null) {
                this.children.clear();
            }
            this.loggerRef = null;
            this.children = null;
        }
    }
}

