/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import se.ericsson.cello.support.logging.Filter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;

public class Logger {
    private static final int off_Value = Level.OFF.intValue();
    private LogManager logManager = LogManager.getLogManager();
    private String names;
    private Level levelObjects;
    private int level_Value;
    private ArrayList handlersArray;
    private String resourceBundledName;
    private ResourceBundle catalogResource;
    private boolean useGlobalHandlers = true;
    private Filter filters;
    private boolean anonymous_value;
    public static final Logger globalLogger = Logger.getLogger("global");

    protected Logger(String names, String resourceBundName) {
        this.resourceBundledName = resourceBundName;
        if (resourceBundName != null) {
            this.catalogResource = ResourceBundle.getBundle(resourceBundName);
        }
        this.names = names;
        this.levelObjects = Level.ALL;
        this.level_Value = this.levelObjects.intValue();
    }

    public static synchronized Logger getLogger(String names) {
        if (names.equals("")) {
            throw new IllegalArgumentException("need a logger name");
        }
        LogManager managerLog = LogManager.getLogManager();
        Logger resultLog = managerLog.getLogger(names);
        if (resultLog == null) {
            managerLog.addLogger(new Logger(names, null));
            resultLog = managerLog.getLogger(names);
            resultLog.levelObjects = managerLog.getLevel(names);
            resultLog.level_Value = resultLog.levelObjects.intValue();
        }
        return resultLog;
    }

    public static synchronized Logger getLogger(String names, String resourceBundName) {
        if (names.equals("")) {
            throw new IllegalArgumentException("need a logger name");
        }
        LogManager managerLog = LogManager.getLogManager();
        Logger resultLog = managerLog.getLogger(names);
        if (resultLog == null) {
            ResourceBundle.getBundle(resourceBundName);
            managerLog.addLogger(new Logger(names, null));
            resultLog = managerLog.getLogger(names);
            resultLog.levelObjects = managerLog.getLevel(names);
            resultLog.level_Value = resultLog.levelObjects.intValue();
        }
        if (resultLog.resourceBundledName == null) {
            resultLog.catalogResource = ResourceBundle.getBundle(resourceBundName);
            resultLog.resourceBundledName = resourceBundName;
        } else if (!resultLog.resourceBundledName.equals(resourceBundName)) {
            throw new IllegalArgumentException(resultLog.resourceBundledName + " != " + resourceBundName);
        }
        return resultLog;
    }

    public static synchronized Logger getAnonymousLogger() {
        LogManager managerLog = LogManager.getLogManager();
        Logger resultLog = new Logger(null, null);
        resultLog.anonymous_value = true;
        Level level = managerLog.getLevel("");
        resultLog.setLevel(level);
        return resultLog;
    }

    public static synchronized Logger getAnonymousLogger(String resourceBundName) {
        LogManager managerLog = LogManager.getLogManager();
        Logger resultLog = new Logger(null, null);
        resultLog.anonymous_value = true;
        resultLog.setLevel(managerLog.getLevel(""));
        resultLog.resourceBundledName = resourceBundName;
        resultLog.catalogResource = ResourceBundle.getBundle(resourceBundName);
        return resultLog;
    }

    public ResourceBundle getResourceBundle() {
        return this.catalogResource;
    }

    public String getResourceBundleName() {
        return this.resourceBundledName;
    }

    public void setFilter(Filter newFilters) throws SecurityException {
        if (!this.anonymous_value) {
            this.logManager.checkAccess();
        }
        this.filters = newFilters;
    }

    public Filter getFilter() {
        return this.filters;
    }

    public synchronized void log(LogRecord record) {
        record.setLoggerName(this.names);
        record.setResourceBundle(this.catalogResource);
        record.setResourceBundleName(this.resourceBundledName);
        if (record.getLevel().intValue() < this.level_Value || this.level_Value == off_Value) {
            return;
        }
        if (this.filters != null && !this.filters.isLoggable(record)) {
            return;
        }
        if (this.useGlobalHandlers) {
            this.logManager.publish(record);
        }
        if (this.handlersArray != null) {
            for (int i = 0; i < this.handlersArray.size(); ++i) {
                Handler h = (Handler)this.handlersArray.get(i);
                h.publish(record);
            }
        }
    }

    public void log(Level levelValue, String sClass, String sMethod, String msgValue) {
        if (levelValue.intValue() < this.level_Value || this.level_Value == off_Value) {
            return;
        }
        LogRecord lRecord = new LogRecord(levelValue, msgValue);
        lRecord.setSourceClassName(sClass);
        lRecord.setSourceMethodName(sMethod);
        this.log(lRecord);
    }

    public void log(Level levels, String sClass, String sMethod, String msgValue, Object[] parameters) {
        if (levels.intValue() < this.level_Value || this.level_Value == off_Value) {
            return;
        }
        LogRecord lRecord = new LogRecord(levels, msgValue);
        lRecord.setSourceClassName(sClass);
        lRecord.setSourceMethodName(sMethod);
        lRecord.setParameters(parameters);
        this.log(lRecord);
    }

    public void log(Level levelValue, String sClass, String sMethod, String msgValue, Throwable th) {
        if (levelValue.intValue() < this.level_Value || this.level_Value == off_Value) {
            return;
        }
        LogRecord lRecord = new LogRecord(levelValue, msgValue);
        lRecord.setSourceClassName(sClass);
        lRecord.setSourceMethodName(sMethod);
        lRecord.setThrown(th);
        this.log(lRecord);
    }

    public void entering(String sourceClassValue, String sourceMethodValue) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINER, sourceClassValue, sourceMethodValue, "ENTRY");
    }

    public void entering(String sourceClassValue, String sourceMethodValue, Object[] params) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINER, sourceClassValue, sourceMethodValue, "ENTRY", params);
    }

    public void exiting(String sourceClassValue, String sourceMethodValue) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINER, sourceClassValue, sourceMethodValue, "RETURN");
    }

    public void exiting(String sourceClassValue, String sourceMethodValue, Object resultObject) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        Object[] param = new Object[]{resultObject};
        this.log(Level.FINER, sourceClassValue, sourceMethodValue, "RETURN", param);
    }

    public void throwing(String sourceClassValue, String sourceMethodValue, Throwable thrown) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        LogRecord lRecord = new LogRecord(Level.FINER, "THROW");
        lRecord.setSourceClassName(sourceClassValue);
        lRecord.setSourceMethodName(sourceMethodValue);
        lRecord.setThrown(thrown);
        this.log(lRecord);
    }

    public void severe(String sourceClassValue, String sourceMethodValue, String message, Object[] params) {
        if (Level.SEVERE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.SEVERE, sourceClassValue, sourceMethodValue, message, params);
    }

    public void severe(String sourceClassValue, String sourceMethodValue, String message) {
        if (Level.SEVERE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.SEVERE, sourceClassValue, sourceMethodValue, message);
    }

    public void warning(String sourceClassValue, String sourceMethodValue, String message, Object[] params) {
        if (Level.WARNING.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.WARNING, sourceClassValue, sourceMethodValue, message, params);
    }

    public void warning(String sourceClassValue, String sourceMethodValue, String message) {
        if (Level.WARNING.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.WARNING, sourceClassValue, sourceMethodValue, message);
    }

    public void info(String sourceClassValue, String sourceMethodValue, String msg, Object[] params) {
        if (Level.INFO.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.INFO, sourceClassValue, sourceMethodValue, msg, params);
    }

    public void info(String sourceClassValue, String sourceMethodValue, String message) {
        if (Level.INFO.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.INFO, sourceClassValue, sourceMethodValue, message);
    }

    public void config(String sourceClassValue, String sourceMethodValue, String message, Object[] params) {
        if (Level.CONFIG.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.CONFIG, sourceClassValue, sourceMethodValue, message, params);
    }

    public void config(String sourceClassValue, String sourceMethodValue, String msg) {
        if (Level.CONFIG.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.CONFIG, sourceClassValue, sourceMethodValue, msg);
    }

    public void fine(String sourceClassValue, String sourceMethodValue, String msg, Object[] params) {
        if (Level.FINE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINE, sourceClassValue, sourceMethodValue, msg, params);
    }

    public void fine(String sourceClassValue, String sourceMethodValue, String msg) {
        if (Level.FINE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINE, sourceClassValue, sourceMethodValue, msg);
    }

    public void finer(String sourceClassValue, String sourceMethodValue, String msg, Object[] params) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINER, sourceClassValue, sourceMethodValue, msg, params);
    }

    public void finer(String sourceClassValue, String sourceMethodValue, String msg) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINER, sourceClassValue, sourceMethodValue, msg);
    }

    public void finest(String sourceClassValue, String sourceMethodValue, String msg, Object[] params) {
        if (Level.FINEST.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINEST, sourceClassValue, sourceMethodValue, msg, params);
    }

    public void finest(String sourceClassValue, String sourceMethodValue, String msg) {
        if (Level.FINEST.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINEST, sourceClassValue, sourceMethodValue, msg);
    }

    private void inferCaller(LogRecord record) {
        try {
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            new Exception("").printStackTrace(pwriter);
            pwriter.close();
            String traces = swriter.toString();
            int index = traces.lastIndexOf("java.util.logging.Logger");
            index = traces.indexOf("(", index) + 3;
            int ends = traces.indexOf("(", index);
            int dots = traces.lastIndexOf(".", ends);
            int starts = traces.lastIndexOf(" ", dots) + 1;
            record.setSourceClassName(traces.substring(starts, dots));
            record.setSourceMethodName(traces.substring(dots + 1, ends));
        }
        catch (Exception ex) {
            return;
        }
    }

    public void log(Level lev, String msgValue) {
        if (lev.intValue() < this.level_Value || this.level_Value == off_Value) {
            return;
        }
        LogRecord lrecord = new LogRecord(lev, msgValue);
        this.inferCaller(lrecord);
        this.log(lrecord);
    }

    public void log(Level lev, String msgValue, Object[] parameters) {
        if (lev.intValue() < this.level_Value || this.level_Value == off_Value) {
            return;
        }
        LogRecord lrecord = new LogRecord(lev, msgValue);
        lrecord.setParameters(parameters);
        this.inferCaller(lrecord);
        this.log(lrecord);
    }

    public void log(Level lev, String message, Throwable th) {
        if (lev.intValue() < this.level_Value || this.level_Value == off_Value) {
            return;
        }
        LogRecord lrecord = new LogRecord(lev, message);
        lrecord.setThrown(th);
        this.inferCaller(lrecord);
        this.log(lrecord);
    }

    public void severe(String msgValue, Object[] params) {
        if (Level.SEVERE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.SEVERE, msgValue, params);
    }

    public void severe(String msgValue) {
        if (Level.SEVERE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.SEVERE, msgValue);
    }

    public void warning(String msgValue, Object[] parameters) {
        if (Level.WARNING.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.WARNING, msgValue, parameters);
    }

    public void warning(String msgValue) {
        if (Level.WARNING.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.WARNING, msgValue);
    }

    public void info(String msgValue, Object[] parameters) {
        if (Level.INFO.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.INFO, msgValue, parameters);
    }

    public void info(String msgValue) {
        if (Level.INFO.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.INFO, msgValue);
    }

    public void config(String msgValue, Object[] parameters) {
        if (Level.CONFIG.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.CONFIG, msgValue, parameters);
    }

    public void config(String msgValue) {
        if (Level.CONFIG.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.CONFIG, msgValue);
    }

    public void fine(String msgValue, Object[] params) {
        if (Level.FINE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINE, msgValue, params);
    }

    public void fine(String msgValue) {
        if (Level.FINE.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINE, msgValue);
    }

    public void finer(String msgValue, Object[] parameters) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINER, msgValue, parameters);
    }

    public void finer(String msgValue) {
        if (Level.FINER.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINER, msgValue);
    }

    public void finest(String msgValue, Object[] parameters) {
        if (Level.FINEST.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINEST, msgValue, parameters);
    }

    public void finest(String msgValue) {
        if (Level.FINEST.intValue() < this.level_Value) {
            return;
        }
        this.log(Level.FINEST, msgValue);
    }

    public synchronized void setLevel(Level newLevelValue) throws SecurityException {
        if (newLevelValue == null) {
            throw new NullPointerException();
        }
        if (!this.anonymous_value) {
            this.logManager.checkAccess();
        }
        this.levelObjects = newLevelValue;
        this.level_Value = this.levelObjects.intValue();
    }

    public Level getLevel() {
        return this.levelObjects;
    }

    public boolean isLoggable(Level levelVal) {
        return levelVal.intValue() >= this.level_Value && this.level_Value != off_Value;
    }

    public String getName() {
        return this.names;
    }

    public synchronized void addHandler(Handler handlerAdd) throws SecurityException {
        handlerAdd.getClass();
        if (!this.anonymous_value) {
            this.logManager.checkAccess();
        }
        if (this.handlersArray == null) {
            this.handlersArray = new ArrayList();
        }
        this.handlersArray.add(handlerAdd);
    }

    public synchronized void removeHandler(Handler handlerRemove) throws SecurityException {
        if (!this.anonymous_value) {
            this.logManager.checkAccess();
        }
        if (this.handlersArray == null) {
            return;
        }
        this.handlersArray.remove(handlerRemove);
    }

    public synchronized Handler[] getHandlers() throws SecurityException {
        if (!this.anonymous_value) {
            this.logManager.checkAccess();
        }
        if (this.handlersArray == null) {
            return new Handler[0];
        }
        Handler[] results = new Handler[this.handlersArray.size()];
        results = this.handlersArray.toArray(results);
        return results;
    }

    public void setUseGlobalHandlers(boolean useGlobalHandlers) {
        if (!this.anonymous_value) {
            this.logManager.checkAccess();
        }
        this.useGlobalHandlers = useGlobalHandlers;
    }

    public boolean getUseGlobalHandlers() {
        return this.useGlobalHandlers;
    }
}

