/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.SimpleFormatter;

public class StreamHandler
extends Handler {
    private OutputStream outputStr;
    private boolean doneHead;
    private Writer writers;

    private void configure() {
        LogManager managerlog = LogManager.getLogManager();
        String cnamed = StreamHandler.class.getName();
        this.setLevel(managerlog.getLevelProperty(cnamed + ".level", Level.INFO));
        this.setFilter(managerlog.getFilterProperty(cnamed + ".filter", null));
        this.setFormatter(managerlog.getFormatterProperty(cnamed + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(managerlog.getStringProperty(cnamed + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public StreamHandler() {
        this.sealedder = false;
        this.configure();
        this.sealedder = true;
    }

    public StreamHandler(OutputStream out, Formatter formatter) {
        this.sealedder = false;
        this.configure();
        this.setFormatter(formatter);
        this.setOutputStream(out);
        this.sealedder = true;
    }

    protected synchronized void setOutputStream(OutputStream outPut) throws SecurityException {
        if (outPut == null) {
            throw new NullPointerException();
        }
        this.flushAndClose();
        this.outputStr = outPut;
        this.doneHead = false;
        String encoding = this.getEncoding();
        if (encoding == null) {
            this.writers = new OutputStreamWriter(this.outputStr);
        } else {
            try {
                this.writers = new OutputStreamWriter(this.outputStr, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error("Unexpected exception " + ex);
            }
        }
    }

    public void setEncoding(String encode) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encode);
        if (this.outputStr == null) {
            return;
        }
        this.flush();
        this.writers = encode == null ? new OutputStreamWriter(this.outputStr) : new OutputStreamWriter(this.outputStr, encode);
    }

    public synchronized void publish(LogRecord recordLog) {
        if (!this.isLoggable(recordLog)) {
            return;
        }
        String msger = this.getFormatter().format(recordLog);
        try {
            if (!this.doneHead) {
                this.writers.write(this.getFormatter().getHead(this));
                this.doneHead = true;
            }
            this.writers.write(msger);
        }
        catch (Exception ex) {
            this.setException(ex);
        }
    }

    public boolean isLoggable(LogRecord recordLog) {
        if (this.writers == null) {
            return false;
        }
        return super.isLoggable(recordLog);
    }

    public synchronized void flush() {
        if (this.writers != null) {
            try {
                this.writers.flush();
            }
            catch (Exception ex) {
                this.setException(ex);
            }
        }
    }

    private synchronized void flushAndClose() throws SecurityException {
        this.checkAccessRight();
        if (this.writers != null) {
            try {
                if (!this.doneHead) {
                    this.writers.write(this.getFormatter().getHead(this));
                    this.doneHead = true;
                }
                this.writers.write(this.getFormatter().getTail(this));
                this.writers.flush();
                this.writers.close();
            }
            catch (Exception ex) {
                this.setException(ex);
            }
            this.writers = null;
            this.outputStr = null;
        }
    }

    public synchronized void close() throws SecurityException {
        this.flushAndClose();
    }
}

