/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;
import se.ericsson.cello.support.proxy.RequestedAttributeSeq;

public class AttributeBufferTable {
    private Hashtable table = new Hashtable();

    public AttributeBufferTable(RequestedAttributeSeq[] request, NameValue[][] values) {
        if (request.length != values.length) {
            throw new IllegalArgumentException("The number of MO's doesn't match the number of NameValue arrays");
        }
        for (int reqIter = 0; reqIter < request.length; ++reqIter) {
            this.addAttributes(request[reqIter], values[reqIter]);
        }
    }

    public AttributeBufferTable() {
    }

    public AttributeBuffer getAttributeBuffer(MOProxy mo) {
        if (mo != null) {
            return (AttributeBuffer)this.table.get(mo.getDN());
        }
        return null;
    }

    public Object getAttribute(MOProxy mo, String name) {
        Object returnValue = null;
        AttributeBuffer ab = this.getAttributeBuffer(mo);
        if (ab != null) {
            returnValue = ab.getAttribute(name);
        }
        return returnValue;
    }

    public void addAttributeBuffer(MOProxy mo, AttributeBuffer buffer) {
        this.table.put(mo.getDN(), buffer);
    }

    public void addAttributes(RequestedAttributeSeq request, NameValue[] values) {
        if (request.attributes.length != values.length) {
            throw new IllegalArgumentException("The number of values doesn't match the number of value names for MO : " + request.getLdn());
        }
        AttributeBuffer attribBuffer = new AttributeBuffer();
        for (int valIter = 0; valIter < values.length; ++valIter) {
            attribBuffer.setAttribute(request.attributes[valIter], values[valIter].getValue());
        }
        this.addAttributeBuffer(request.getMo(), attribBuffer);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(500);
        Set tableSet = this.table.keySet();
        Iterator i = tableSet.iterator();
        boolean first = true;
        while (i.hasNext()) {
            String ldn = (String)i.next();
            if (!first) {
                sb.append("\n");
            }
            sb.append(ldn + "\n\t");
            AttributeBuffer buffer = (AttributeBuffer)this.table.get(ldn);
            NameValue[] nv = buffer.getNameValues();
            for (int j = 0; j < nv.length; ++j) {
                if (j != 0) {
                    sb.append(",");
                }
                sb.append(nv[j].getName());
                sb.append(":");
                sb.append(nv[j].getValue());
            }
            first = false;
        }
        return sb.toString();
    }
}

