/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.proxy.action;

import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;
import org.threegppsa5.AlarmIRPSystem.InvalidParameter;
import org.threegppsa5.AlarmIRPSystem.OperationNotSupported;
import org.threegppsa5.NotificationIRPConstDefs.SubscriptionStateHolder;
import org.threegppsa5.NotificationIRPSystem.GetSubscriptionStatus;
import org.threegppsa5.NotificationIRPSystem._NotificationIRPOperations;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractCorbaRequest;
import se.ericsson.cello.support.gui.guilib.infra.AbstractRequest;
import se.ericsson.cello.support.proxy.AlarmCorbaInterface;

public class GetSubscriptionStatusCorbaCall
extends AbstractCorbaRequest {
    private _NotificationIRPOperations irpRef = null;
    private String subscriptionid;
    private AlarmCorbaInterface myCorbaInterface = null;

    public GetSubscriptionStatusCorbaCall(AlarmCorbaInterface corbaInterface, _NotificationIRPOperations irpNotificationRef, String subscriptionid) {
        this.irpRef = irpNotificationRef;
        this.subscriptionid = subscriptionid;
        this.myCorbaInterface = corbaInterface;
        this.setProgressMode(AbstractRequest.NO_PROGRESS);
        this.setBlockMode(AbstractRequest.BLOCK_NOTHING);
    }

    protected void invoke() throws UserException {
        Log.log(6, "get_subscription_status for id: " + this.subscriptionid);
        SubscriptionStateHolder stateStatus = new SubscriptionStateHolder();
        StringHolder filter = new StringHolder();
        IntHolder time_tick = new IntHolder();
        this.irpRef.get_subscription_status(this.subscriptionid, filter, stateStatus, time_tick);
    }

    protected void handleSuccesful() {
    }

    protected boolean handleUserException(UserException ue) {
        this.myCorbaInterface.setStatus(7);
        this.myCorbaInterface.setSubscriptionOK(false);
        if (ue instanceof GetSubscriptionStatus) {
            this.myCorbaInterface.unsubscribeCheck();
            this.myCorbaInterface.showErrorDialog(7);
            Log.logError("GetSubscriptionStatus for id: " + this.subscriptionid, ue);
        } else if (ue instanceof OperationNotSupported) {
            this.myCorbaInterface.showErrorDialog(7);
            Log.logError("GetSubscriptionStatus for id: " + this.subscriptionid, ue);
        } else if (ue instanceof InvalidParameter) {
            this.myCorbaInterface.showErrorDialog(7);
            Log.logError("GetSubscriptionStatus for id: " + this.subscriptionid, ue);
        } else {
            Log.logError("GetSubscriptionStatus for id: " + this.subscriptionid, ue);
            this.myCorbaInterface.showErrorDialog(14);
        }
        return false;
    }
}

