/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.helpers;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.NanoTimer;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Perf;

public final class Utils {
    private static final NanoTimer nanoTimer;
    private static final String providerProp = "edu.emory.mathcs.backport.java.util.concurrent.NanoTimerProvider";

    private Utils() {
    }

    public static long nanoTime() {
        return nanoTimer.nanoTime();
    }

    public static long awaitNanos(Condition condition, long l2) throws InterruptedException {
        if (l2 <= 0L) {
            return l2;
        }
        long l3 = Utils.nanoTime();
        condition.await(l2, TimeUnit.NANOSECONDS);
        return l2 - (Utils.nanoTime() - l3);
    }

    private static long gcd(long l2, long l3) {
        while (l3 > 0L) {
            long l4 = l2 % l3;
            l2 = l3;
            l3 = l4;
        }
        return l2;
    }

    static {
        NanoTimer nanoTimer = null;
        try {
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(Utils.providerProp);
                }
            });
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                nanoTimer = (NanoTimer)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            System.err.println("WARNING: unable to load Perf provider; switching to a default");
            exception.printStackTrace();
        }
        if (nanoTimer == null) {
            try {
                nanoTimer = new SunPerfProvider();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nanoTimer == null) {
            nanoTimer = new MillisProvider();
        }
        Utils.nanoTimer = nanoTimer;
    }

    private static final class MillisProvider
    implements NanoTimer {
        MillisProvider() {
        }

        public long nanoTime() {
            return System.currentTimeMillis() * 1000000L;
        }
    }

    private static final class SunPerfProvider
    implements NanoTimer {
        final Perf perf = (Perf)AccessController.doPrivileged(new PrivilegedAction(this){
            private final /* synthetic */ SunPerfProvider this$0;
            {
                this.this$0 = sunPerfProvider;
            }

            public Object run() {
                return Perf.getPerf();
            }
        });
        final long multiplier;
        final long divisor;

        SunPerfProvider() {
            long l2 = 1000000000L;
            long l3 = this.perf.highResFrequency();
            long l4 = Utils.gcd(l2, l3);
            this.multiplier = l2 / l4;
            this.divisor = l3 / l4;
        }

        public long nanoTime() {
            long l2 = this.perf.highResCounter();
            return l2 / this.divisor * this.multiplier + l2 % this.divisor * this.multiplier / this.divisor;
        }
    }
}

