/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

class CondVar
implements Condition,
Serializable {
    protected final ExclusiveLock lock;

    CondVar(ExclusiveLock exclusiveLock) {
        this.lock = exclusiveLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        int n2 = this.lock.getHoldCount();
        if (n2 == 0) {
            throw new IllegalMonitorStateException();
        }
        boolean bl = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i2 = n2; i2 > 0; --i2) {
                    this.lock.unlock();
                }
                while (true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        continue;
                    }
                    break;
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            for (int i3 = n2; i3 > 0; --i3) {
                this.lock.lock();
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        for (int i4 = n2; i4 > 0; --i4) {
            this.lock.lock();
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        int n2 = this.lock.getHoldCount();
        if (n2 == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i2 = n2; i2 > 0; --i2) {
                    this.lock.unlock();
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            for (int i3 = n2; i3 > 0; --i3) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i4 = n2; i4 > 0; --i4) {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        int n2 = this.lock.getHoldCount();
        if (n2 == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long l3 = timeUnit.toNanos(l2);
        boolean bl = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i2 = n2; i2 > 0; --i2) {
                    this.lock.unlock();
                }
                try {
                    if (l3 > 0L) {
                        long l4 = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, l3);
                        bl = Utils.nanoTime() - l4 < l3;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            for (int i3 = n2; i3 > 0; --i3) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i4 = n2; i4 > 0; --i4) {
            this.lock.lock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitUntil(Date date) throws InterruptedException {
        if (date == null) {
            throw new NullPointerException();
        }
        int n2 = this.lock.getHoldCount();
        if (n2 == 0) {
            throw new IllegalMonitorStateException();
        }
        long l2 = date.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean bl = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                for (int i2 = n2; i2 > 0; --i2) {
                    this.lock.unlock();
                }
                try {
                    long l3 = System.currentTimeMillis();
                    long l4 = l2 - l3;
                    if (l4 > 0L) {
                        this.wait(l4);
                        bl = System.currentTimeMillis() - l3 < l4;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            for (int i3 = n2; i3 > 0; --i3) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i4 = n2; i4 > 0; --i4) {
            this.lock.lock();
        }
        return bl;
    }

    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    protected ExclusiveLock getLock() {
        return this.lock;
    }

    protected boolean hasWaiters() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected int getWaitQueueLength() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected Collection getWaitingThreads() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    static interface ExclusiveLock
    extends Lock {
        public boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

