/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.List;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.ParsedIOROperations;
import org.jacorb.orb.RebindRetryStrategy;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public abstract class AbstractRebindRetryStrategy
implements RebindRetryStrategy {
    protected final Logger logger;

    protected AbstractRebindRetryStrategy(Logger logger) {
        this.logger = logger;
    }

    protected AbstractRebindRetryStrategy(Configuration config) {
        this.logger = config.getNamedLogger(this.getClass().getName());
    }

    protected abstract boolean checkExceptionStatus(SystemException var1);

    protected boolean checkExceptionType(SystemException e2) {
        if (e2 instanceof COMM_FAILURE) {
            return true;
        }
        if (e2 instanceof TRANSIENT) {
            return true;
        }
        if (e2 instanceof NO_RESPONSE) {
            return true;
        }
        return e2 instanceof OBJ_ADAPTER;
    }

    public final boolean try_rebind(RebindRetryStrategy.RebindCallback callback, ParsedIOROperations failingIOR, SystemException cause, List serviceContexts) {
        this.logger.info("try rebind for " + this + " using ior " + failingIOR);
        if (!this.checkExceptionType(cause)) {
            this.logger.info("cannot recover from exception type: " + cause.getClass().getName());
            return false;
        }
        if (!this.checkExceptionStatus(cause)) {
            this.logger.info("cannot recover from completion status: " + cause.completed);
            return false;
        }
        return this.doTryRebind(callback, failingIOR, cause, serviceContexts);
    }

    protected boolean doTryRebind(RebindRetryStrategy.RebindCallback callback, ParsedIOROperations failingIOR, SystemException cause, List serviceContexts) {
        return false;
    }
}

