/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.AbstractBufferManager;
import org.jacorb.orb.buffermanager.BufferManagerExpansionPolicy;
import org.jacorb.orb.buffermanager.DefaultExpansionPolicy;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_MEMORY;

public class BufferManager
extends AbstractBufferManager {
    private static final int MIN_CACHE = 9;
    private static final double LOG2 = Math.log(2.0);
    protected final Collection[] bufferPool;
    private byte[] bufferMax = null;
    private final int maxManagedBufferSize;
    private final int threshold;
    private final int maxMessageBufferSize;
    private Reaper reaper;
    private final int time;
    private BufferManagerExpansionPolicy expansionPolicy;
    private final Logger logger;

    public BufferManager(Configuration configuration) {
        this.time = configuration.getAttributeAsInteger("jacorb.bufferManagerMaxFlush", 0);
        this.maxManagedBufferSize = configuration.getAttributeAsInteger("jacorb.maxManagedBufSize", 22);
        this.threshold = configuration.getAttributeAsInteger("jacorb.bufferManagerThreshold", 20);
        this.maxMessageBufferSize = configuration.getAttributeAsInteger("jacorb.maxMessageBufferSize", 0);
        this.logger = configuration.getNamedLogger("jacorb.buffermanager");
        try {
            this.expansionPolicy = (BufferManagerExpansionPolicy)configuration.getAttributeAsObject("jacorb.buffermanager.expansionpolicy", DefaultExpansionPolicy.class.getName());
            if (this.expansionPolicy instanceof Configurable) {
                ((Configurable)((Object)this.expansionPolicy)).configure(configuration);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BufferManager expansion policy " + this.expansionPolicy);
            }
        }
        catch (ConfigurationException e2) {
            this.expansionPolicy = null;
        }
        this.bufferPool = this.initBufferPool(configuration, this.maxManagedBufferSize);
        int[] sizes = new int[]{1023, 2047};
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            for (int min = 0; min < 10; ++min) {
                int position = BufferManager.calcLog(sizes[i2]) - 9;
                this.storeBuffer(position, new byte[sizes[i2]]);
            }
        }
        if (this.time > 0) {
            if (this.reaper != null) {
                this.reaper.dispose();
            }
            this.reaper = new Reaper(this.time);
            this.reaper.setName("BufferManager MaxCache Reaper");
            this.reaper.setDaemon(true);
            this.reaper.start();
        }
    }

    protected void storeBuffer(int position, byte[] buffer) {
        this.bufferPool[position].add(buffer);
    }

    protected Collection[] initBufferPool(Configuration configuration, int maxSize) {
        Collection[] bufferPool = new List[maxSize];
        for (int i2 = 0; i2 < bufferPool.length; ++i2) {
            bufferPool[i2] = new ArrayList(this.threshold);
        }
        return bufferPool;
    }

    private static final int calcLog(int value) {
        if (value <= 1023) {
            return 9;
        }
        return (int)Math.floor(Math.log(value) / LOG2);
    }

    public byte[] getExpandedBuffer(int size) {
        if (size < 0) {
            throw new INTERNAL("Unable to cache and create buffer of negative size. Possible overflow issue.");
        }
        if (this.expansionPolicy != null) {
            size = this.expansionPolicy.getExpandedSize(size);
        }
        return this.getBuffer(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBuffer(int size) {
        byte[] result = null;
        if (size < 0) {
            throw new INTERNAL("Unable to cache and create buffer of negative size. Possible overflow issue.");
        }
        int log = BufferManager.calcLog(size);
        if (this.maxMessageBufferSize > 0 && size > this.maxMessageBufferSize) {
            throw new NO_MEMORY("Memory buffer allocation failed - requested " + size + " bytes but maximum allowed buffer size is " + this.maxMessageBufferSize + " bytes.");
        }
        if (log > this.maxManagedBufferSize) {
            try {
                if (this.time < 0) {
                    result = new byte[size];
                }
                BufferManager bufferManager = this;
                synchronized (bufferManager) {
                    if (this.bufferMax == null || this.bufferMax.length < size) {
                        this.bufferMax = new byte[size];
                    }
                    result = this.bufferMax;
                    this.bufferMax = null;
                }
            }
            catch (Throwable e2) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("BufferManager OutOfMemory requesting " + size, e2);
                }
                throw new NO_MEMORY(e2.toString());
            }
        } else {
            int index = log > 9 ? log - 9 : 0;
            Collection s2 = this.bufferPool[index];
            result = this.doFetchBuffer(s2);
            if (result == null) {
                result = new byte[(log > 9 ? 1 << log + 1 : 1024) - 1];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doFetchBuffer(Collection list) {
        Collection collection = list;
        synchronized (collection) {
            int size = list.size();
            if (size > 0) {
                return (byte[])((AbstractList)list).remove(size - 1);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer(byte[] current, boolean cdrStr) {
        int log_curr;
        if (current != null && (log_curr = BufferManager.calcLog(current.length)) >= 9) {
            if (log_curr > this.maxManagedBufferSize) {
                BufferManager bufferManager = this;
                synchronized (bufferManager) {
                    if (cdrStr && this.time >= 0 && (this.bufferMax == null || this.bufferMax.length < current.length)) {
                        this.bufferMax = current;
                    }
                    return;
                }
            }
            Collection s2 = this.bufferPool[log_curr - 9];
            this.doReturnBuffer(s2, current, this.threshold);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReturnBuffer(Collection list, byte[] buffer, int threshold) {
        Collection collection = list;
        synchronized (collection) {
            if (list.size() < threshold) {
                list.add(buffer);
            }
        }
    }

    public void release() {
        for (int i2 = 0; i2 < this.bufferPool.length; ++i2) {
            this.bufferPool[i2].clear();
        }
        if (this.reaper != null) {
            this.reaper.dispose();
            this.reaper = null;
        }
    }

    static /* synthetic */ byte[] access$002(BufferManager x0, byte[] x1) {
        x0.bufferMax = x1;
        return x1;
    }

    private final class Reaper
    extends Thread {
        private boolean done;
        private int sleepInterval;

        public Reaper(int sleepInterval) {
            super("BufferManagerReaper");
            this.done = false;
            this.sleepInterval = 0;
            this.sleepInterval = sleepInterval * 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                try {
                    long time = (long)this.sleepInterval + System.currentTimeMillis();
                    object = this;
                    synchronized (object) {
                        while (!this.done && System.currentTimeMillis() <= time) {
                            this.wait(this.sleepInterval);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                object = this;
                synchronized (object) {
                    if (this.done) {
                        break;
                    }
                }
                object = BufferManager.this;
                synchronized (object) {
                    BufferManager.access$002(BufferManager.this, null);
                }
            }
        }

        public synchronized void dispose() {
            this.done = true;
            this.interrupt();
            this.notify();
        }
    }
}

