/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.portableInterceptor.DefaultServerInterceptor;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;

public class BiDirConnectionServerInterceptor
extends DefaultServerInterceptor {
    private static final String NAME = "BiDirConnectionServerInterceptor";
    private final transient ORB orb;
    private final ClientConnectionManager conn_mg;
    private final Logger logger;

    protected BiDirConnectionServerInterceptor(ORB orb) {
        this.orb = orb;
        this.logger = orb.getConfiguration().getNamedLogger("jacorb.giop.bidir.interceptor");
        this.conn_mg = orb.getClientConnectionManager();
    }

    public String name() {
        return NAME;
    }

    public void destroy() {
    }

    public void receive_request_service_contexts(ServerRequestInfo requestInfo) throws ForwardRequest {
        if (this.orb.useBiDirGIOP()) {
            try {
                ServiceContext context = requestInfo.get_request_service_context(5);
                this.addConnections(requestInfo, context);
            }
            catch (BAD_PARAM e2) {
                this.logger.debug("no BiDir context present");
            }
        }
    }

    private void addConnections(ServerRequestInfo requestInfo, ServiceContext ctx) {
        BiDirIIOPServiceContext bidir_ctx = this.readBiDirContext(ctx);
        GIOPConnection connection = ((ServerRequestInfoImpl)requestInfo).request.getConnection();
        for (int i2 = 0; i2 < bidir_ctx.listen_points.length; ++i2) {
            ListenPoint listenPoint = bidir_ctx.listen_points[i2];
            IIOPAddress addr = new IIOPAddress(listenPoint.host, listenPoint.port);
            try {
                addr.configure(this.orb.getConfiguration());
            }
            catch (ConfigurationException ce) {
                this.logger.warn("ConfigurationException", ce);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Client conn. added to target " + addr);
            }
            this.conn_mg.addConnection(connection, new IIOPProfile(addr, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BiDirIIOPServiceContext readBiDirContext(ServiceContext ctx) {
        CDRInputStream cdr_in = new CDRInputStream(this.orb, ctx.context_data);
        try {
            cdr_in.openEncapsulatedArray();
            BiDirIIOPServiceContext biDirIIOPServiceContext = BiDirIIOPServiceContextHelper.read(cdr_in);
            return biDirIIOPServiceContext;
        }
        finally {
            cdr_in.close();
        }
    }
}

