/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.MessageOutputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.ServiceContextHelper;

public class ServiceContextTransportingOutputStream
extends MessageOutputStream {
    private static final ServiceContext padding_ctx = new ServiceContext(1245790977, new byte[0]);
    protected int header_end = -1;
    protected int header_padding = 0;
    protected List contexts;

    public ServiceContextTransportingOutputStream(ORB orb) {
        super(orb);
    }

    public List getServiceContextList() {
        if (this.contexts == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.contexts);
    }

    protected void markHeaderEnd() {
        this.header_end = this.size();
        this.header_padding = 8 - this.size() % 8;
        this.header_padding = this.header_padding == 8 ? 0 : this.header_padding;
        this.skip(this.header_padding);
    }

    private int getHeaderEnd() {
        return this.header_end;
    }

    public int getBodyBegin() {
        return this.header_end + this.header_padding;
    }

    private int getHeaderPadding() {
        return this.header_padding;
    }

    private boolean hasBody() {
        return this.size() > this.getBodyBegin();
    }

    public void insertMsgSize() {
        if (this.header_padding == 0) {
            this.insertMsgSize(this.size() - 12);
        } else if (this.size() > this.header_end + this.header_padding) {
            this.insertMsgSize(this.size() - 12);
        } else {
            this.insertMsgSize(this.size() - this.header_padding - 12);
            this.reduceSize(this.header_padding);
        }
    }

    public void write_to(GIOPConnection conn) throws IOException {
        if (this.contexts == null || this.contexts.isEmpty()) {
            this.writeToWithoutContexts(conn);
        } else {
            this.writeToWithContexts(conn);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeToWithContexts(GIOPConnection conn) throws IOException {
        CDROutputStream ctx_out = null;
        try {
            switch (this.giop_minor) {
                case 0: 
                case 1: {
                    this.addServiceContext(padding_ctx);
                    ctx_out = this.createContextStream();
                    int difference = 8 - (12 + ctx_out.size()) % 8;
                    int n2 = difference = difference == 8 ? 0 : difference;
                    if (difference > 0) {
                        ctx_out.reduceSize(4);
                        ctx_out.write_ulong(difference);
                        ctx_out.increaseSize(difference);
                    }
                    this.insertMsgSize(this.size() - 12 - 4 + ctx_out.size());
                    this.write(conn, 0, 12);
                    ctx_out.write(conn, 0, ctx_out.size());
                    this.write(conn, 16, this.size() - 16);
                    return;
                }
                case 2: {
                    ctx_out = this.createContextStream();
                    int new_header_end = this.getHeaderEnd() - 4 + ctx_out.size();
                    int difference = 8 - new_header_end % 8;
                    int n3 = difference = difference == 8 ? 0 : difference;
                    if (difference > 0 && this.hasBody()) {
                        ctx_out.increaseSize(difference);
                    }
                    this.insertMsgSize(this.size() - 12 - 4 - this.getHeaderPadding() + ctx_out.size());
                    this.write(conn, 0, this.getHeaderEnd() - 4);
                    ctx_out.write(conn, 0, ctx_out.size());
                    this.write(conn, this.getBodyBegin(), this.size() - this.getBodyBegin());
                    return;
                }
                default: {
                    throw new MARSHAL("Unknown GIOP minor: " + this.giop_minor);
                }
            }
        }
        finally {
            if (ctx_out != null) {
                ctx_out.close();
            }
        }
    }

    private void writeToWithoutContexts(GIOPConnection conn) throws IOException {
        this.insertMsgSize();
        this.write(conn, 0, this.size());
    }

    public void addServiceContext(ServiceContext ctx) {
        if (this.contexts == null) {
            this.contexts = new ArrayList();
        }
        this.contexts.add(ctx);
    }

    private CDROutputStream createContextStream() {
        CDROutputStream out = new CDROutputStream(this.orb);
        out.write_ulong(this.contexts.size());
        for (int i2 = 0; i2 < this.contexts.size(); ++i2) {
            ServiceContextHelper.write(out, (ServiceContext)this.contexts.get(i2));
        }
        return out;
    }
}

