/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.listener.TCPConnectionEvent;
import org.jacorb.orb.listener.TCPConnectionListener;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.SSLIOP.SSL;
import org.omg.SSLIOP.SSLHelper;

public class ClientIIOPConnection
extends IIOPConnection
implements Configurable {
    private int timeout = 0;
    private int ssl_port = -1;
    private int noOfRetries = 5;
    private int retryInterval;
    private boolean doSupportSSL = false;
    private TransportManager transportManager;
    private TCPConnectionListener connectionListener;
    private boolean keepAlive;
    public static int openTransports = 0;
    private Exception exception = null;
    private boolean do_shutdown = false;

    public ClientIIOPConnection() {
        this.use_ssl = false;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.idle_timeout", 0);
        this.noOfRetries = configuration.getAttributeAsInteger("jacorb.retries", 5);
        this.retryInterval = configuration.getAttributeAsInteger("jacorb.retry_interval", 500);
        this.doSupportSSL = configuration.getAttributeAsBoolean("jacorb.security.support_ssl", false);
        this.transportManager = this.configuration.getORB().getTransportManager();
        this.keepAlive = configuration.getAttributeAsBoolean("jacorb.connection.client.keepalive", false);
        this.connectionListener = this.transportManager.getSocketFactoryManager().getTCPListener();
    }

    public synchronized void connect(Profile server_profile, long time_out) {
        if (!this.connected) {
            if (!(server_profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + server_profile.getClass());
            }
            this.profile = (IIOPProfile)server_profile;
            IIOPLoopback loopback = this.getLocalLoopback();
            if (loopback != null) {
                String connectionDetails;
                IIOPLoopbackInputStream lis = new IIOPLoopbackInputStream();
                IIOPLoopbackOutputStream los = new IIOPLoopbackOutputStream();
                this.connection_info = connectionDetails = this.profile + " using loopback connection";
                loopback.initLoopback(connectionDetails, lis, los);
                this.in_stream = lis;
                this.out_stream = los;
                this.connected = true;
                ++openTransports;
                return;
            }
            this.checkSSL();
            int retries = this.noOfRetries;
            while (retries >= 0 && !this.do_shutdown) {
                try {
                    this.createSocket(time_out);
                    this.socket.setTcpNoDelay(true);
                    if (this.timeout != 0) {
                        this.socket.setSoTimeout(this.timeout);
                    }
                    this.socket.setKeepAlive(this.keepAlive);
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : "") + (this.timeout == 0 ? "" : " Timeout: " + this.timeout));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException c2) {
                    this.logger.debug("Exception", c2);
                    if (--retries < 0 || this.do_shutdown) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying to connect to " + this.connection_info);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Retry count is " + retries + '/' + this.noOfRetries + " and retry interval is " + this.retryInterval);
                    }
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException i2) {}
                }
                catch (TIMEOUT e2) {
                    this.profile = null;
                    this.use_ssl = false;
                    this.ssl_port = -1;
                    throw e2;
                }
            }
            if (retries < 0) {
                this.profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
            if (this.do_shutdown) {
                this.profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Shutdown is invoked during connection to " + this.connection_info);
            }
        }
    }

    private IIOPLoopback getLocalLoopback() {
        IIOPProfile iiopProfile = (IIOPProfile)this.profile;
        ArrayList<ProtocolAddressBase> addressList = new ArrayList<ProtocolAddressBase>();
        addressList.add(iiopProfile.getAddress());
        addressList.addAll(iiopProfile.getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        IIOPLoopbackRegistry registry = IIOPLoopbackRegistry.getRegistry();
        while (addressIterator.hasNext()) {
            IIOPLoopback loopback;
            IIOPAddress address = (IIOPAddress)((IIOPAddress)addressIterator.next()).copy();
            if (iiopProfile.getSSL() != null) {
                address.setPort(iiopProfile.getSSLPort());
            }
            if ((loopback = registry.getLoopback(address)) == null) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("connect to " + address + " using IIOPLoopback");
            }
            return loopback;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSocket(long time_out) throws IOException {
        ArrayList<ProtocolAddressBase> addressList = new ArrayList<ProtocolAddressBase>();
        addressList.add(((IIOPProfile)this.profile).getAddress());
        addressList.addAll(((IIOPProfile)this.profile).getAlternateAddresses());
        Iterator addressIterator = addressList.iterator();
        this.exception = null;
        this.socket = null;
        while (this.socket == null && addressIterator.hasNext()) {
            Object var11_10;
            try {
                block12: {
                    try {
                        IIOPAddress address = (IIOPAddress)addressIterator.next();
                        SocketFactory factory = this.use_ssl ? this.getSSLSocketFactory() : this.getSocketFactory();
                        String ipAddress = address.getIP();
                        int port = this.use_ssl ? this.ssl_port : address.getPort();
                        this.connection_info = ipAddress.indexOf(58) == -1 ? ipAddress + ":" + port : "[" + ipAddress + "]:" + port;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Trying to connect to " + this.connection_info + " with timeout=" + time_out + (this.use_ssl ? " using SSL." : "."));
                        }
                        this.exception = null;
                        if (time_out > 0L) {
                            int truncatedTimeout = (int)time_out;
                            if ((long)truncatedTimeout != time_out) {
                                this.logger.warn("timeout might be changed due to conversion from long to int. old value: " + time_out + " new value: " + truncatedTimeout);
                            }
                            this.socket = factory.createSocket(ipAddress, port, truncatedTimeout);
                            break block12;
                        }
                        this.socket = factory.createSocket(ipAddress, port);
                    }
                    catch (Exception e2) {
                        this.exception = e2;
                        var11_10 = null;
                        if (this.socket == null || !this.connectionListener.isListenerEnabled()) continue;
                        this.connectionListener.connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
                        continue;
                    }
                }
                var11_10 = null;
                if (this.socket == null || !this.connectionListener.isListenerEnabled()) continue;
                this.connectionListener.connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
            }
            catch (Throwable throwable) {
                var11_10 = null;
                if (this.socket != null && this.connectionListener.isListenerEnabled()) {
                    this.connectionListener.connectionOpened(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
                }
                throw throwable;
            }
        }
        if (this.exception != null) {
            if (this.exception instanceof SocketTimeoutException) {
                throw new TIMEOUT("connection timeout of " + this.timeout + " milliseconds expired: " + this.exception);
            }
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            throw new IOException("Unexpected exception occured: " + this.exception.toString());
        }
    }

    public synchronized void close() {
        if (!this.connected) {
            return;
        }
        try {
            block15: {
                try {
                    IOException exception = null;
                    if (this.socket != null) {
                        try {
                            if (!(this.socket instanceof SSLSocket) && !this.socket.isClosed()) {
                                this.socket.shutdownOutput();
                            }
                        }
                        catch (IOException ex) {
                            this.logger.warn("ClientIIOPConnection - Unexpected exception is thrown during socket.shutdownOutput call", ex);
                            exception = ex;
                        }
                        this.socket.close();
                    }
                    if (this.in_stream != null) {
                        this.in_stream.close();
                    }
                    if (this.out_stream != null) {
                        this.out_stream.close();
                    }
                    --openTransports;
                    if (exception != null) {
                        throw exception;
                    }
                    if (!this.logger.isInfoEnabled()) break block15;
                    this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
                }
                catch (IOException ex) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exception when closing the socket", ex);
                    }
                    throw this.handleCommFailure(ex);
                }
            }
            Object var4_4 = null;
            this.connected = false;
            if (this.socket != null && this.connectionListener.isListenerEnabled()) {
                this.connectionListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.connected = false;
            if (this.socket != null && this.connectionListener.isListenerEnabled()) {
                this.connectionListener.connectionClosed(new TCPConnectionEvent(this, this.socket.getInetAddress().toString(), this.socket.getPort(), this.socket.getLocalPort(), this.getLocalhost()));
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSSL() {
        if (((IIOPProfile)this.profile).getSSL() == null) {
            return;
        }
        CompoundSecMechList sas = (CompoundSecMechList)((IIOPProfile)this.profile).getComponent(33, CompoundSecMechListHelper.class);
        TLS_SEC_TRANS tls = null;
        if (sas != null && sas.mechanism_list[0].transport_mech.tag == 36) {
            byte[] tagData = sas.mechanism_list[0].transport_mech.component_data;
            CDRInputStream in = new CDRInputStream(tagData);
            try {
                in.openEncapsulatedArray();
                tls = TLS_SEC_TRANSHelper.read(in);
            }
            finally {
                in.close();
            }
        }
        SSL ssl = (SSL)((IIOPProfile)this.profile).getComponent(20, SSLHelper.class);
        int minimum_options = 126;
        int client_required = 0;
        int client_supported = 0;
        if (this.doSupportSSL) {
            client_required = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.required_options", 16, 16);
            client_supported = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.supported_options", 16, 16);
        }
        if (tls != null && (tls.target_supports & minimum_options) != 0 && this.doSupportSSL && (client_supported & minimum_options) != 0 && ((tls.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            this.use_ssl = true;
            this.ssl_port = tls.addresses[0].port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
        } else if (ssl != null && (ssl.target_supports & minimum_options) != 0 && this.doSupportSSL && (client_supported & minimum_options) != 0 && ((ssl.target_requires & minimum_options) != 0 || (client_required & minimum_options) != 0)) {
            this.use_ssl = true;
            this.ssl_port = ssl.port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
        } else {
            if (this.doSupportSSL && (client_required & minimum_options) != 0) {
                throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
            }
            this.use_ssl = false;
            this.ssl_port = -1;
        }
    }

    private SocketFactory getSocketFactory() {
        return this.transportManager.getSocketFactoryManager().getSocketFactory();
    }

    private SocketFactory getSSLSocketFactory() {
        return this.transportManager.getSocketFactoryManager().getSSLSocketFactory();
    }

    public void shutdown() {
        this.do_shutdown = true;
    }
}

