/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.debug.trace;

import se.ericsson.cello.support.debug.trace.PackageFilter;
import se.ericsson.cello.support.debug.trace.PlainPackageFilter;

class VariableFilter
implements Cloneable {
    boolean info;
    boolean error;
    boolean enter;
    boolean ret;
    boolean state;
    boolean param;
    boolean send_sig;
    boolean rec_sig;
    boolean[] group = new boolean[10];

    public VariableFilter() {
    }

    public VariableFilter(String string, PackageFilter packageFilter) {
        this.info = packageFilter.filterInfo(string);
        this.error = packageFilter.filterError(string);
        this.enter = packageFilter.filterEnter(string);
        this.ret = packageFilter.filterReturn(string);
        this.state = packageFilter.filterState(string);
        this.param = packageFilter.filterParam(string);
        this.send_sig = packageFilter.filterSendSig(string);
        this.rec_sig = packageFilter.filterRecSig(string);
        for (int i = 0; i < this.group.length; ++i) {
            this.group[i] = packageFilter.filterGroup(i, string);
        }
    }

    public VariableFilter(PlainPackageFilter plainPackageFilter) {
        this.info = plainPackageFilter.infoEntry.isFilterAlwaysOn();
        this.error = plainPackageFilter.errorEntry.isFilterAlwaysOn();
        this.enter = plainPackageFilter.enterEntry.isFilterAlwaysOn();
        this.ret = plainPackageFilter.returnEntry.isFilterAlwaysOn();
        this.state = plainPackageFilter.stateEntry.isFilterAlwaysOn();
        this.param = plainPackageFilter.paramEntry.isFilterAlwaysOn();
        this.send_sig = plainPackageFilter.sendSigEntry.isFilterAlwaysOn();
        this.rec_sig = plainPackageFilter.recSigEntry.isFilterAlwaysOn();
        for (int i = 0; i < plainPackageFilter.groupEntry.length; ++i) {
            this.group[i] = plainPackageFilter.groupEntry[i].isFilterAlwaysOn();
        }
    }

    public final String toString() {
        String string = "[info = " + this.info + "\n" + "error = " + this.error + "\n" + "enter = " + this.enter + "\n" + "return = " + this.ret + "\n" + "state = " + this.state + "\n" + "param = " + this.param + "\n" + "send signal = " + this.send_sig + "\n" + "receive signal = " + this.rec_sig + "\n" + "group = [";
        for (int i = 0; i < this.group.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + this.group[i];
        }
        return string + "]\n" + "]";
    }

    public VariableFilter and(VariableFilter variableFilter) {
        this.info = this.info && variableFilter.info;
        this.error = this.error && variableFilter.error;
        this.enter = this.enter && variableFilter.enter;
        this.ret = this.ret && variableFilter.ret;
        this.state = this.state && variableFilter.state;
        this.param = this.param && variableFilter.param;
        this.send_sig = this.send_sig && variableFilter.send_sig;
        this.rec_sig = this.rec_sig && variableFilter.rec_sig;
        for (int i = 0; i < this.group.length; ++i) {
            this.group[i] = this.group[i] && variableFilter.group[i];
        }
        return this;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("SHOULD NOT HAPPEN");
        }
    }
}

