/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.log;

import java.io.File;
import java.io.Serializable;
import se.ericsson.cello.support.debug.MessageLog;

class FilesData
implements Serializable {
    private File[] files;
    private int noOfFiles;
    private int totsize;
    private int size;
    private File directory;
    private int currentIndex;
    private int currentFileNum;
    private boolean wraps;
    static final long serialVersionUID = -1900001557199466734L;

    FilesData(File file, int n, int n2, boolean bl) {
        if (!file.isDirectory()) {
            throw new RuntimeException("Not a directory");
        }
        if (n / n2 <= 100) {
            throw new RuntimeException("File size to small");
        }
        this.totsize = n;
        this.size = n / n2;
        this.noOfFiles = n2;
        this.directory = file;
        this.currentIndex = 0;
        this.currentFileNum = 0;
        this.wraps = bl;
        this.files = new File[n2];
        for (int i = 0; i < n2; ++i) {
            this.createFile(i).delete();
        }
        this.files[this.currentIndex] = this.createFile(this.currentFileNum);
    }

    void deleteOldestFile() {
        if (!this.files[0].delete()) {
            MessageLog.info(this.getClass(), "Warning - Log file " + this.files[0] + " does not exist. Assume deleted");
        }
        for (int i = 0; i < this.currentIndex; ++i) {
            this.files[i] = this.files[i + 1];
        }
        --this.currentIndex;
    }

    File getCurrentFile() {
        return this.files[this.currentIndex];
    }

    File getFile(int n) {
        if (n < 0 || n > this.currentIndex) {
            return null;
        }
        return this.files[n];
    }

    int getFileNum(int n) {
        return this.currentFileNum - this.currentIndex + n;
    }

    int getIndex(int n) {
        return this.currentIndex - (this.currentFileNum - n);
    }

    int getFileCount() {
        return this.currentIndex + 1;
    }

    int getCurrentFileNum() {
        return this.currentFileNum;
    }

    boolean addNewFile() {
        if (this.currentIndex == this.noOfFiles - 1) {
            return false;
        }
        if (!this.files[this.currentIndex].exists()) {
            return false;
        }
        this.currentFileNum = (this.currentFileNum + 1) % Integer.MAX_VALUE;
        this.files[++this.currentIndex] = this.createFile(this.currentFileNum);
        return true;
    }

    int getTotalSize() {
        return this.totsize;
    }

    int getFileSize() {
        return this.size;
    }

    File getDirectory() {
        return this.directory;
    }

    boolean isWrapper() {
        return this.wraps;
    }

    boolean isLast() {
        return this.currentIndex == this.noOfFiles - 1;
    }

    void deleteAll() {
        for (int i = 0; i <= this.currentIndex; ++i) {
            this.files[i].delete();
        }
        this.currentIndex = 0;
        this.currentFileNum = 0;
    }

    protected File createFile(int n) {
        return new File(this.directory, "log" + n + ".objects");
    }
}

