/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.scheduler;

import com.jtheory.jdring.AlarmEntry;
import com.jtheory.jdring.AlarmListener;
import com.jtheory.jdring.AlarmManager;
import com.jtheory.jdring.PastDateException;
import java.util.Date;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.scheduler.EventAdaptor;
import se.ericsson.cello.support.scheduler.ScheduleEntry;
import se.ericsson.cello.support.scheduler.ScheduleEntryImpl;
import se.ericsson.cello.support.scheduler.ScheduleTime;
import se.ericsson.cello.support.scheduler.ScheduledTask;
import se.ericsson.cello.support.scheduler.Scheduler;

public class SchedulerImpl
implements Scheduler {
    static SchedulerImpl _theOne = null;
    AlarmManager _mgr = new AlarmManager();

    public static SchedulerImpl instance() {
        if (_theOne == null) {
            _theOne = new SchedulerImpl();
        }
        return _theOne;
    }

    private SchedulerImpl() {
    }

    public ScheduleEntry createSchedule(String string, ScheduleTime scheduleTime, ScheduledTask scheduledTask, boolean bl) {
        try {
            EventAdaptor eventAdaptor = new EventAdaptor(scheduledTask);
            AlarmEntry alarmEntry = this._mgr.addAlarm(string, scheduleTime.getMinute(), scheduleTime.getHour(), scheduleTime.getDayOfMonth(), scheduleTime.getMonth(), scheduleTime.getDayOfWeek(), scheduleTime.isRepetitive() ? -1 : 1970, (AlarmListener)eventAdaptor);
            if (bl) {
                alarmEntry.setRingInNewThead();
            }
            MessageLog.trace(6, this.getClass(), "AlarmEntry created in createScheduler: with Name " + string);
            return new ScheduleEntryImpl(alarmEntry);
        }
        catch (PastDateException pastDateException) {
            return null;
        }
    }

    public ScheduleEntry createSchedule(String string, ScheduleTime[] scheduleTimeArray, ScheduledTask scheduledTask, boolean bl) {
        try {
            AlarmEntry[] alarmEntryArray = new AlarmEntry[scheduleTimeArray.length];
            for (int i = 0; i < alarmEntryArray.length; ++i) {
                EventAdaptor eventAdaptor = new EventAdaptor(scheduledTask);
                alarmEntryArray[i] = this._mgr.addAlarm(string, scheduleTimeArray[i].getMinute(), scheduleTimeArray[i].getHour(), scheduleTimeArray[i].getDayOfMonth(), scheduleTimeArray[i].getMonth(), scheduleTimeArray[i].getDayOfWeek(), scheduleTimeArray[i].isRepetitive() ? -1 : 1970, (AlarmListener)eventAdaptor);
                if (!bl) continue;
                alarmEntryArray[i].setRingInNewThead();
            }
            MessageLog.trace(6, this.getClass(), "AlarmEntry created in createScheduler: with Name " + string);
            return new ScheduleEntryImpl(alarmEntryArray);
        }
        catch (PastDateException pastDateException) {
            return null;
        }
    }

    public ScheduleEntry createSchedule(String string, Date date, ScheduledTask scheduledTask, boolean bl) {
        try {
            EventAdaptor eventAdaptor = new EventAdaptor(scheduledTask);
            AlarmEntry alarmEntry = this._mgr.addAlarm(string, date, (AlarmListener)eventAdaptor);
            if (bl) {
                alarmEntry.setRingInNewThead();
            }
            MessageLog.trace(6, this.getClass(), "AlarmEntry created in createScheduler: with Name " + string);
            return new ScheduleEntryImpl(alarmEntry);
        }
        catch (PastDateException pastDateException) {
            return null;
        }
    }

    public ScheduleEntry createRepeatingAlarm(String string, int n, ScheduledTask scheduledTask, boolean bl) {
        return this.createAlarm(string, n, true, scheduledTask, bl);
    }

    private ScheduleEntry createAlarm(String string, int n, boolean bl, ScheduledTask scheduledTask, boolean bl2) {
        try {
            EventAdaptor eventAdaptor = new EventAdaptor(scheduledTask);
            AlarmEntry alarmEntry = this._mgr.addAlarm(string, n, bl, eventAdaptor);
            if (bl2) {
                alarmEntry.setRingInNewThead();
            }
            return new ScheduleEntryImpl(alarmEntry);
        }
        catch (PastDateException pastDateException) {
            return null;
        }
    }

    void removeEntry(AlarmEntry alarmEntry) {
        this._mgr.removeAlarm(alarmEntry);
        alarmEntry.isRepeating = false;
    }
}

