/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.sigutil;

import enea.ose.system.InSignal;
import enea.ose.system.SignalPort;
import enea.ose.system.SignalRegistry;
import enea.ose.system.SignalSelect;
import enea.ose.system.ThisProcess;
import java.util.Enumeration;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.ObserverList;
import se.ericsson.cello.support.sigutil.PortListenerSupervisor;
import se.ericsson.cello.support.sigutil.SignalObserver;

public class MessageReceiver
extends Thread {
    PortListenerSupervisor pls;
    ObserverList oList;
    SignalPort mBox;
    private boolean isValid = true;
    int pid;
    static /* synthetic */ Class class$se$ericsson$cello$support$sigutil$signals$UpdateSignal;
    static /* synthetic */ Class class$enea$ose$system$UnregisteredSignal;

    public MessageReceiver(PortListenerSupervisor portListenerSupervisor, ObserverList observerList, SignalPort signalPort) {
        super("Osa_MessageReceiver_thread");
        this.pls = portListenerSupervisor;
        this.oList = observerList;
        this.mBox = signalPort;
    }

    public MessageReceiver(MessageReceiver messageReceiver) {
        this(messageReceiver.pls, messageReceiver.oList, messageReceiver.mBox);
    }

    public final void run() {
        SignalRegistry signalRegistry = this.oList.getSignalRegistry();
        this.pid = ThisProcess.getThisProcess().getPID();
        do {
            InSignal inSignal;
            Class<?> clazz;
            if ((clazz = (inSignal = this.mBox.receive(signalRegistry, SignalSelect.ANY_SIGNAL)).getClass()) == (class$se$ericsson$cello$support$sigutil$signals$UpdateSignal == null ? MessageReceiver.class$("se.ericsson.cello.support.sigutil.signals.UpdateSignal") : class$se$ericsson$cello$support$sigutil$signals$UpdateSignal)) {
                MessageLog.trace(9, this.getClass(), "UpdateSignal received");
                signalRegistry = this.oList.getSignalRegistry();
            } else if (clazz != (class$enea$ose$system$UnregisteredSignal == null ? MessageReceiver.class$("enea.ose.system.UnregisteredSignal") : class$enea$ose$system$UnregisteredSignal)) {
                this.handleSignal(inSignal, clazz);
            } else {
                MessageLog.trace(9, this.getClass(), "Unregistered signal: " + inSignal);
            }
            inSignal = null;
        } while (this.isValid);
        MessageLog.info(this.getClass(), "This thread should cease fetching messages from the signal port. It should have been replaced by another thread.");
    }

    private void handleSignal(InSignal inSignal, Class clazz) {
        MessageLog.trace(9, this.getClass(), "Handling signal " + clazz);
        Enumeration enumeration = this.oList.getEnumeratedObservers(clazz);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                SignalObserver signalObserver = (SignalObserver)enumeration.nextElement();
                MessageLog.trace(9, this.getClass(), "thread = " + this.pid + ", sig = " + clazz + ", so = " + signalObserver.getClass());
                if (this.isValid) {
                    this.pls.startTimeout(this, inSignal, signalObserver);
                    try {
                        signalObserver.signalReceived(inSignal);
                    }
                    catch (Throwable throwable) {
                        String string = "A signal observer throwed an exception, see stack trace";
                        MessageLog.traceError(this.getClass(), string, throwable);
                    }
                    this.pls.stopTimeout(this);
                    continue;
                }
                signalObserver.signalReceived(inSignal);
                MessageLog.trace(9, this.getClass(), "Signal: " + clazz + " is received without supervision.");
            }
        }
    }

    void setInvalid() {
        this.isValid = false;
    }
}

