/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.sigutil;

import enea.ose.system.OseProcess;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.PortManager;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.cello.support.sigutil.SignalPort;
import se.ericsson.cello.support.sigutil.SubscribeMgr;
import se.ericsson.cello.support.sigutil.SubscriptionObserver;
import se.ericsson.cello.support.sigutil.SubscriptionObserver2;
import se.ericsson.cello.support.sigutil.signals.NsAddServiceReply;
import se.ericsson.cello.support.sigutil.signals.NsAddServiceReq;
import se.ericsson.cello.support.sigutil.signals.NsGetServicePidReply;
import se.ericsson.cello.support.sigutil.signals.NsGetServicePidReq;
import se.ericsson.cello.support.sigutil.signals.NsRemoveServiceReply;
import se.ericsson.cello.support.sigutil.signals.NsRemoveServiceReq;

public class OseNameServer {
    static final int NS_SUCCESS = 0;
    static final int NS_FAILURE = 1;
    private SubscribeMgr subscribeMgr = new SubscribeMgr();
    private OseProcess oseNS = null;
    private static OseNameServer singleton = new OseNameServer();
    private static SignalPort sp = PortManager.instance();

    public static OseProcess lookup(String string) {
        return singleton.lookup_(string);
    }

    public static OseProcess lookupNoCache(String string) {
        return singleton.lookupNoCache_(string);
    }

    public static void addSubscriptionObserver(String string, SubscriptionObserver subscriptionObserver) {
        singleton.addSubscriptionObserver_(string, subscriptionObserver);
    }

    public static void addSubscriptionObserver(String string, SubscriptionObserver2 subscriptionObserver2) {
        singleton.addSubscriptionObserver_(string, subscriptionObserver2);
    }

    public static void removeSubscriptionObserver(String string, SubscriptionObserver subscriptionObserver) {
        singleton.removeSubscriptionObserver_(string, subscriptionObserver);
    }

    public static void removeSubscriptionObserver(String string, SubscriptionObserver2 subscriptionObserver2) {
        singleton.removeSubscriptionObserver_(string, subscriptionObserver2);
    }

    public static boolean isSubscribed(String string, SubscriptionObserver subscriptionObserver) {
        return singleton.isSubscribed_(string, subscriptionObserver);
    }

    public static boolean isSubscribed(String string, SubscriptionObserver2 subscriptionObserver2) {
        return singleton.isSubscribed_(string, subscriptionObserver2);
    }

    public static boolean addService(String string) {
        return singleton.addService_(string);
    }

    public static boolean removeService(String string) {
        return singleton.removeService_(string);
    }

    public static OseProcess getOseNs() {
        return singleton.getOseNs_();
    }

    OseProcess lookup_(String string) {
        OseProcess oseProcess = null;
        MessageLog.trace(9, this.getClass(), "lookup_(" + string + ")");
        oseProcess = this.subscribeMgr.getService(string);
        if (oseProcess == null) {
            oseProcess = this.lookupNoCache_(string);
        }
        return oseProcess;
    }

    OseProcess lookupNoCache_(String string) {
        OseProcess oseProcess = null;
        MessageLog.trace(9, this.getClass(), "lookupNoCache_(" + string + ")");
        NsGetServicePidReq nsGetServicePidReq = new NsGetServicePidReq(string);
        NsGetServicePidReply nsGetServicePidReply = (NsGetServicePidReply)SignalHelper.sendAndReceive(OseNameServer.getOseNs(), nsGetServicePidReq, NsGetServicePidReply.class);
        if (nsGetServicePidReply == null) {
            MessageLog.info(OseNameServer.class, "Failed to lookup " + string + " in OSE name server.");
        } else {
            int n = nsGetServicePidReply.getServicePid();
            if (n == 0) {
                MessageLog.trace(9, OseNameServer.class, "The name " + string + " is not registered in the OSE name server.");
            } else {
                MessageLog.trace(9, this.getClass(), "Looked up process for " + string + ", pid = " + n);
                try {
                    oseProcess = OseProcess.getProcess(n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MessageLog.info(OseNameServer.class, "Service pid not valid, probably a zombie");
                }
            }
        }
        return oseProcess;
    }

    void addSubscriptionObserver_(String string, Object object) {
        MessageLog.trace(9, this.getClass(), "addSubscriptionObserver_(" + string + ", " + object.getClass() + ")");
        this.subscribeMgr.addSubscriptionObserver_(string, object);
    }

    void removeSubscriptionObserver_(String string, Object object) {
        MessageLog.trace(9, this.getClass(), "removeSubscriptionObserver_()");
        this.subscribeMgr.removeSubscriptionObserver_(string, object);
        MessageLog.traceReturn(this.getClass(), "removeSubscriptionObserver_()");
    }

    boolean isSubscribed_(String string, Object object) {
        MessageLog.trace(9, this.getClass(), "isSubscribed_(" + string + ", " + object.getClass());
        return this.subscribeMgr.isSubscribed_(string, object);
    }

    boolean addService_(String string) {
        NsAddServiceReq nsAddServiceReq = new NsAddServiceReq(string);
        NsAddServiceReply nsAddServiceReply = (NsAddServiceReply)SignalHelper.sendAndReceive(OseNameServer.getOseNs(), nsAddServiceReq, NsAddServiceReply.class);
        return nsAddServiceReply != null && nsAddServiceReply.getStatus() != 1L;
    }

    boolean removeService_(String string) {
        NsRemoveServiceReq nsRemoveServiceReq = new NsRemoveServiceReq(string);
        NsRemoveServiceReply nsRemoveServiceReply = (NsRemoveServiceReply)SignalHelper.sendAndReceive(OseNameServer.getOseNs(), nsRemoveServiceReq, NsRemoveServiceReply.class);
        return nsRemoveServiceReply != null && nsRemoveServiceReply.getStatus() != 1L;
    }

    OseProcess getOseNs_() {
        if (this.oseNS == null) {
            this.oseNS = SignalHelper.huntProcess("ose_ns");
            Assert.cppAssert(this.oseNS != null, "Failed hunt to OSE NameServer");
        }
        return this.oseNS;
    }
}

