/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.sigutil;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalPort;
import enea.ose.system.SignalRegistry;
import enea.ose.system.SignalSelect;
import enea.ose.system.ThisProcess;
import java.util.LinkedList;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.signals.CsHuntSig;

public class SignalHelper {
    private static int RECEIVE_TIMEOUT = 100000;
    private static final int MAX_NR_OF_SIGNAL_PORTS = 5;
    private static LinkedList signalPorts = new LinkedList();
    private static int nrOfSignalPorts = 0;

    public static Signal sendAndReceive(OseProcess oseProcess, Signal signal, Class clazz) {
        SignalHelper.send(oseProcess, signal);
        if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
            MessageLog.trace(4, SignalHelper.class, "Sent signal " + signal.getClass() + " to " + oseProcess.getPID() + ", expecting " + clazz.getName());
        }
        return SignalHelper.receive(clazz, RECEIVE_TIMEOUT);
    }

    public static Signal sendAndReceive(OseProcess oseProcess, Signal signal, Class clazz, int n) {
        SignalHelper.send(oseProcess, signal);
        if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
            MessageLog.trace(4, SignalHelper.class, "Sent signal " + signal.getClass() + " to " + oseProcess.getPID() + ", expecting " + clazz.getName() + " within " + n);
        }
        return SignalHelper.receive(clazz, n);
    }

    public static Signal sendAndReceiveAttached(OseProcess oseProcess, Signal signal, Class clazz, int n) {
        SignalHelper.send(oseProcess, signal);
        if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
            MessageLog.trace(4, SignalHelper.class, "Sent signal " + signal.getClass() + " to " + oseProcess.getPID() + ", expecting " + clazz.getName() + " within " + n);
        }
        return SignalHelper.receiveAttached(oseProcess, clazz, n);
    }

    public static Signal sendAndReceiveAttached(OseProcess oseProcess, Signal signal, Class[] classArray, int n) {
        SignalHelper.send(oseProcess, signal);
        return SignalHelper.receiveAttached(null, oseProcess, classArray, n);
    }

    public static Signal sendAndReceiveAttachedClean(OseProcess oseProcess, Signal signal, Class clazz, int n) {
        Class[] classArray = new Class[]{clazz};
        return SignalHelper.sendAndReceiveAttachedClean(oseProcess, signal, classArray, n);
    }

    public static Signal sendAndReceiveAttachedClean(OseProcess oseProcess, Signal signal, Class[] classArray, int n) {
        SignalPort signalPort = SignalHelper.getSignalPort();
        oseProcess.post(signal, signalPort);
        Signal signal2 = SignalHelper.receiveAttached(signalPort, oseProcess, classArray, n);
        if (signal2 == null) {
            if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
                MessageLog.trace(4, SignalHelper.class, "Sent signal " + signal.getClass() + " to " + oseProcess.getPID() + ", received no signal within " + n);
            }
            SignalHelper.returnSignalPort(signalPort, true);
        } else {
            if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
                MessageLog.trace(4, SignalHelper.class, "Sent signal " + signal.getClass() + " to " + oseProcess.getPID() + ", received signal " + signal2.getClass());
            }
            SignalHelper.returnSignalPort(signalPort, false);
        }
        return signal2;
    }

    public static void send(OseProcess oseProcess, Signal signal) {
        oseProcess.post(signal);
    }

    public static void sendWithSender(OseProcess oseProcess, OseProcess oseProcess2, Signal signal) {
        oseProcess.post(signal, oseProcess2);
        if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
            MessageLog.trace(4, SignalHelper.class, "Sent signal " + signal.getClass() + " from " + oseProcess2.getPID() + " to " + oseProcess.getPID());
        }
    }

    public static Signal receive(Class clazz, int n) {
        InSignal inSignal = null;
        SignalRegistry signalRegistry = new SignalRegistry();
        signalRegistry.add(clazz);
        inSignal = ThisProcess.receive(signalRegistry, n);
        if (inSignal == null && n != 0) {
            MessageLog.info(SignalHelper.class, "Received timed out after " + n + " ms " + "waiting for signal " + clazz.getName());
        } else if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
            MessageLog.trace(4, SignalHelper.class, "Received signal " + clazz.getName());
        }
        return (Signal)inSignal;
    }

    public static Signal receiveAttached(OseProcess oseProcess, Class clazz, int n) {
        if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
            MessageLog.trace(4, SignalHelper.class, "Receive signal " + clazz.getName() + ", with timeout" + n);
        }
        Class[] classArray = new Class[]{clazz};
        return SignalHelper.receiveAttached(null, oseProcess, classArray, n);
    }

    public static Signal receiveAttached(OseProcess oseProcess, Class[] classArray, int n) {
        if (MessageLog.isTraceGroupEnabled(4, SignalHelper.class)) {
            MessageLog.trace(4, SignalHelper.class, "Receive signal within timeout" + n);
        }
        return SignalHelper.receiveAttached(null, oseProcess, classArray, n);
    }

    static Signal receiveAttached(SignalPort signalPort, OseProcess oseProcess, Class[] classArray, int n) {
        InSignal inSignal = null;
        SignalRegistry signalRegistry = new SignalRegistry();
        for (int i = 0; i < classArray.length; ++i) {
            signalRegistry.add(classArray[i]);
        }
        signalRegistry.add(AttachSignal.class);
        long l = oseProcess.attach2();
        if (signalPort == null) {
            inSignal = ThisProcess.receive(signalRegistry, n);
        } else {
            inSignal = signalPort.receive(signalRegistry, n);
            if (inSignal == null) {
                inSignal = ThisProcess.receive(signalRegistry, 0);
            }
        }
        if (inSignal == null) {
            OseProcess.detach2(l);
            return null;
        }
        if (!inSignal.getClass().equals(AttachSignal.class)) {
            OseProcess.detach2(l);
        }
        return (Signal)inSignal;
    }

    public static Signal receive(Class clazz) {
        return SignalHelper.receive(clazz, RECEIVE_TIMEOUT);
    }

    public static OseProcess huntProcess(String string, int n) {
        OseProcess.hunt(string, new CsHuntSig());
        SignalRegistry signalRegistry = new SignalRegistry();
        signalRegistry.add(CsHuntSig.class);
        InSignal inSignal = ThisProcess.receive(signalRegistry, n);
        if (inSignal == null) {
            MessageLog.info(SignalHelper.class, "No signal received within timeout, returning null");
            return null;
        }
        return inSignal.getSender();
    }

    public static OseProcess huntProcess(String string) {
        return SignalHelper.huntProcess(string, RECEIVE_TIMEOUT);
    }

    public static synchronized void setTimeOut(int n) {
        RECEIVE_TIMEOUT = n;
    }

    public static int getTimeOut() {
        return RECEIVE_TIMEOUT;
    }

    private static synchronized SignalPort getSignalPort() {
        SignalPort signalPort;
        while (signalPorts.size() > 0) {
            SignalRegistry signalRegistry;
            signalPort = (SignalPort)signalPorts.removeFirst();
            InSignal inSignal = signalPort.receive(signalRegistry = new SignalRegistry(), 0, SignalSelect.ANY_SIGNAL);
            if (inSignal == null) {
                return signalPort;
            }
            MessageLog.info(class$se$ericsson$cello$support$sigutil$SignalHelper == null ? SignalHelper.class$("se.ericsson.cello.support.sigutil.SignalHelper") : class$se$ericsson$cello$support$sigutil$SignalHelper, "Found unexpected signal in queue: sigNo: " + inSignal.getSigNo() + ", sender: " + inSignal.getSender().getPID());
            signalPort.dispose();
        }
        signalPort = new SignalPort("Osa_signalHelper_" + nrOfSignalPorts);
        ++nrOfSignalPorts;
        return signalPort;
    }

    private static synchronized void returnSignalPort(SignalPort signalPort, boolean bl) {
        if (bl || signalPorts.size() >= 5) {
            signalPort.dispose();
        } else {
            signalPorts.add(signalPort);
        }
    }
}

