/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.transaction;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.transaction.CHandler;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.cello.transaction.Resource2;
import se.ericsson.cello.transaction.Status;
import se.ericsson.cello.transaction.TerminationCause;
import se.ericsson.cello.transaction.Terminator;
import se.ericsson.cello.transaction.TransactionManager;
import se.ericsson.cello.transaction.TransactionResult;
import se.ericsson.cello.transaction.TransactionRolledBackException;

class ControlImpl
implements Control,
Terminator,
Coordinator {
    private int transactionIDNumber = 0;
    private boolean isRNC = false;
    private Status status = null;
    private TerminationCause terminationCause = new TerminationCause(10002);
    private Vector resources;
    private Set resourceSet;

    ControlImpl(int n) {
        this.transactionIDNumber = n;
        this.isRNC = CHandler.getIsRNC();
        this.resources = new Vector();
        if (this.isRNC) {
            this.resourceSet = Collections.synchronizedSet(new HashSet());
        }
        this.status = Status.ACTIVE;
        TransactionManager.instance().putTransaction(n, this);
    }

    public Terminator getTerminator() {
        return this;
    }

    public Coordinator getCoordinator() {
        return this;
    }

    public int getTransactionID() {
        return this.transactionIDNumber;
    }

    public int getTransactionSize() throws InactiveTransactionException {
        TransactionResult transactionResult = new TransactionResult();
        int n = CHandler.getTransactionSize(this.getTransactionID(), transactionResult);
        switch (transactionResult.value) {
            case 0: {
                break;
            }
            case 7: {
                throw new InactiveTransactionException(this.getTransactionID(), this.terminationCause);
            }
            case 6: {
                return 0;
            }
            default: {
                throw new InactiveTransactionException("Error in getTransactionSize: " + transactionResult);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws TransactionRolledBackException, InactiveTransactionException {
        boolean bl = false;
        ControlImpl controlImpl = this;
        synchronized (controlImpl) {
            if (this.status.equals(Status.NO_TRANSACTION) || this.status.equals(Status.PREPARING)) {
                throw new InactiveTransactionException(this.getTransactionID(), this.terminationCause);
            }
            if (this.status.equals(Status.MARKED_ROLLBACK)) {
                bl = true;
                this.status = Status.NO_TRANSACTION;
            } else {
                this.status = Status.PREPARING;
            }
        }
        if (bl) {
            this.doRollback(true, 6);
            throw new TransactionRolledBackException("Transaction " + this.getTransactionID() + " marked rollback only, cannot commit");
        }
        for (int i = 0; i < this.resources.size(); ++i) {
            Resource2 resource2 = (Resource2)this.resources.elementAt(i);
            try {
                resource2.prepare(this);
                continue;
            }
            catch (PrepareFailedException prepareFailedException) {
                this.status = Status.NO_TRANSACTION;
                this.doRollback(true, 6);
                throw new TransactionRolledBackException(prepareFailedException.reason);
            }
        }
        this.status = Status.NO_TRANSACTION;
        TransactionResult transactionResult = new TransactionResult();
        CHandler.commit(this.getTransactionID(), transactionResult);
        if (transactionResult.value == 0) {
            this.terminationCause = new TerminationCause(10001);
            for (int i = 0; i < this.resources.size(); ++i) {
                Resource2 resource2 = (Resource2)this.resources.elementAt(i);
                resource2.commit();
            }
        } else {
            this.doRollback(false, transactionResult.terminationCause);
            throw new TransactionRolledBackException("Error in committing transaction " + this.getTransactionID() + "(" + this.terminationCause + ")", this.terminationCause);
        }
        this.reset();
    }

    public void rollback() throws InactiveTransactionException {
        this.rollback(true, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback(boolean bl, int n) throws InactiveTransactionException {
        ControlImpl controlImpl = this;
        synchronized (controlImpl) {
            if (this.status.equals(Status.NO_TRANSACTION) || this.status.equals(Status.PREPARING)) {
                throw new InactiveTransactionException(this.getTransactionID(), this.terminationCause);
            }
            this.status = Status.NO_TRANSACTION;
        }
        this.doRollback(bl, n);
    }

    private void doRollback(boolean bl, int n) {
        this.terminationCause = new TerminationCause(n);
        this.rollbackResources(bl);
        this.reset();
    }

    private void rollbackResources(boolean bl) {
        TransactionResult transactionResult = new TransactionResult();
        if (bl) {
            CHandler.rollback(this.getTransactionID(), transactionResult);
        }
        for (int i = 0; i < this.resources.size(); ++i) {
            Resource2 resource2 = (Resource2)this.resources.elementAt(i);
            resource2.rollback();
        }
    }

    private synchronized void reset() {
        TransactionManager.instance().removeTransaction(this);
        this.resources.removeAllElements();
        if (this.isRNC) {
            this.resourceSet.clear();
        }
    }

    public boolean isSameTransaction(Coordinator coordinator) {
        return this.getTransactionID() == coordinator.getTransactionID();
    }

    public synchronized Status getStatus() {
        if (this.status.equals(Status.PREPARING)) {
            return Status.ACTIVE;
        }
        return this.status;
    }

    public synchronized Status getStatus2() {
        return this.status;
    }

    public TerminationCause getTerminationCause() {
        return this.terminationCause;
    }

    public synchronized void registerResource(Resource resource) throws InactiveTransactionException {
        Assert.cppAssert(resource != null, "Resource null");
        if (!this.getStatus().equals(Status.ACTIVE)) {
            throw new InactiveTransactionException(this.getTransactionID(), this.terminationCause);
        }
        if (!this.isRNC) {
            for (int i = 0; i < this.resources.size(); ++i) {
                Resource2 resource2 = (Resource2)this.resources.elementAt(i);
                if (!(resource2 instanceof ResourceWrapper)) continue;
                Assert.cppAssert(resource != ((ResourceWrapper)resource2).resource, "Resource already registered");
            }
        }
        ResourceWrapper resourceWrapper = new ResourceWrapper(resource);
        if (this.isRNC) {
            Assert.cppAssert(this.resourceSet.add(resourceWrapper), "Resource already registered");
        }
        this.resources.addElement(resourceWrapper);
    }

    public synchronized void registerResource(Resource2 resource2) throws InactiveTransactionException {
        Assert.cppAssert(resource2 != null, "Resource null");
        if (!this.getStatus().equals(Status.ACTIVE)) {
            throw new InactiveTransactionException(this.getTransactionID(), this.terminationCause);
        }
        Assert.cppAssert(this.resources.indexOf(resource2) == -1, "Resource already registered");
        this.resources.addElement(resource2);
        if (this.isRNC) {
            this.resourceSet.add(resource2);
        }
    }

    public synchronized void rollbackOnly() throws InactiveTransactionException {
        if (!this.status.equals(Status.ACTIVE)) {
            throw new InactiveTransactionException(this.getTransactionID(), this.terminationCause);
        }
        this.status = Status.MARKED_ROLLBACK;
    }

    private class ResourceWrapper
    implements Resource2 {
        public Resource resource;

        ResourceWrapper(Resource resource) {
            this.resource = resource;
        }

        public void commit() {
            this.resource.commit();
        }

        public void rollback() {
            this.resource.rollback();
        }

        public void prepare(Coordinator coordinator) throws PrepareFailedException {
            if (!this.resource.prepare()) {
                throw new PrepareFailedException("Prepare failed");
            }
        }

        public Resource getResource() {
            return this.resource;
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (object instanceof ResourceWrapper) {
                return this.resource.equals(((ResourceWrapper)object).resource);
            }
            return super.equals(object);
        }
    }
}

